/*
 * Decompiled with CFR 0.152.
 */
package net.fichotheque.xml.defs;

import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.fichotheque.SubsetKey;
import net.fichotheque.corpus.metadata.FieldKey;
import net.fichotheque.extraction.FilterParameters;
import net.fichotheque.extraction.def.AddendaExtractDef;
import net.fichotheque.extraction.def.AlbumExtractDef;
import net.fichotheque.extraction.def.CorpusExtractDef;
import net.fichotheque.extraction.def.DocumentFilter;
import net.fichotheque.extraction.def.ExtractionDef;
import net.fichotheque.extraction.def.FicheFilter;
import net.fichotheque.extraction.def.GroupClause;
import net.fichotheque.extraction.def.GroupParams;
import net.fichotheque.extraction.def.IllustrationFilter;
import net.fichotheque.extraction.def.MotcleFilter;
import net.fichotheque.extraction.def.PackClause;
import net.fichotheque.extraction.def.TagNameInfo;
import net.fichotheque.extraction.def.ThesaurusExtractDef;
import net.fichotheque.extraction.def.TitleClause;
import net.fichotheque.extraction.filterunit.AddendaExtractFilterUnit;
import net.fichotheque.extraction.filterunit.AlbumExtractFilterUnit;
import net.fichotheque.extraction.filterunit.BodyFilterUnit;
import net.fichotheque.extraction.filterunit.ChronoFilterUnit;
import net.fichotheque.extraction.filterunit.CorpusExtractFilterUnit;
import net.fichotheque.extraction.filterunit.DataFilterUnit;
import net.fichotheque.extraction.filterunit.DefaultIncludeUnit;
import net.fichotheque.extraction.filterunit.FicheParentageFilterUnit;
import net.fichotheque.extraction.filterunit.FieldKeyFilterUnit;
import net.fichotheque.extraction.filterunit.FieldNamePrefixFilterUnit;
import net.fichotheque.extraction.filterunit.FilterUnit;
import net.fichotheque.extraction.filterunit.HeadFilterUnit;
import net.fichotheque.extraction.filterunit.LotFilterUnit;
import net.fichotheque.extraction.filterunit.MasterMotcleFilterUnit;
import net.fichotheque.extraction.filterunit.PhraseFilterUnit;
import net.fichotheque.extraction.filterunit.ThesaurusExtractFilterUnit;
import net.fichotheque.selection.DocumentCondition;
import net.fichotheque.selection.FicheCondition;
import net.fichotheque.selection.IllustrationCondition;
import net.fichotheque.selection.MotcleCondition;
import net.fichotheque.selection.SubsetCondition;
import net.fichotheque.utils.ExtractionUtils;
import net.fichotheque.utils.FichothequeXMLUtils;
import net.mapeadores.util.exceptions.SwitchException;
import net.mapeadores.util.text.StringUtils;
import net.mapeadores.util.xml.AppendableXMLPart;
import net.mapeadores.util.xml.AppendableXMLWriter;
import net.mapeadores.util.xml.XMLWriter;

public class ExtractionDefXMLPart
extends AppendableXMLPart {
    private final boolean compactStyle;

    public ExtractionDefXMLPart(AppendableXMLWriter xmlWriter, boolean compactStyle) {
        super(xmlWriter);
        this.compactStyle = compactStyle;
    }

    public ExtractionDefXMLPart addExtractionDef(ExtractionDef extractionDef) throws IOException {
        this.startOpenTag("extraction");
        this.addTagName(extractionDef.getTagNameInfo());
        this.endOpenTag();
        this.addDynamicCorpusExtract(extractionDef.getDynamicCorpusExtractDef());
        this.addDynamicThesaurusExtract(extractionDef.getDynamicThesaurusExtractDef());
        List<CorpusExtractDef> corpusExtractDefList = extractionDef.getStaticCorpusExtractDefList();
        List<ThesaurusExtractDef> thesaurusExtractDefList = extractionDef.getStaticThesaurusExtractDefList();
        if (!corpusExtractDefList.isEmpty() || !thesaurusExtractDefList.isEmpty()) {
            this.startOpenTag("static");
            this.addTagName(extractionDef.getStaticTagNameInfo());
            this.endOpenTag();
            for (CorpusExtractDef corpusExtractDef : corpusExtractDefList) {
                this.addCorpusExtract(corpusExtractDef, ExtractionUtils.EMPTY_FILTERPARAMETERS);
            }
            for (ThesaurusExtractDef thesaurusExtractDef : thesaurusExtractDefList) {
                this.addThesaurusExtract(thesaurusExtractDef, ExtractionUtils.EMPTY_FILTERPARAMETERS);
            }
            this.closeTag("static");
        }
        this.closeTag("extraction");
        return this;
    }

    private void addDynamicCorpusExtract(CorpusExtractDef corpusExtractDef) throws IOException {
        if (corpusExtractDef == null) {
            return;
        }
        if (this.canIgnore(corpusExtractDef)) {
            this.addFicheFilter(corpusExtractDef.getFicheFilter());
        } else {
            this.addCorpusExtract(corpusExtractDef, ExtractionUtils.EMPTY_FILTERPARAMETERS);
        }
    }

    private void addCorpusExtract(CorpusExtractFilterUnit filterUnit) throws IOException {
        this.addCorpusExtract(filterUnit.getCorpusExtractDef(), filterUnit);
    }

    private void addCorpusExtract(CorpusExtractDef corpusExtractDef, FilterParameters filterParameters) throws IOException {
        String tagName = "fiches";
        List<FicheCondition.Entry> entryList = corpusExtractDef.getConditionEntryList();
        String onlyCorpusAttribute = this.getOnlyCorpusAttribute(entryList);
        this.startOpenTag(tagName);
        this.addAttribute("name", corpusExtractDef.getName());
        if (onlyCorpusAttribute != null) {
            this.addAttribute("corpus", onlyCorpusAttribute);
        }
        this.addTagName(corpusExtractDef.getTagNameInfo());
        if (corpusExtractDef.isMaster()) {
            this.addAttribute("source", "master");
        }
        if (corpusExtractDef.isDescendantAxis()) {
            this.addAttribute("axis", "descendant");
        }
        this.endOpenTag();
        if (onlyCorpusAttribute == null) {
            for (FicheCondition.Entry entry : corpusExtractDef.getConditionEntryList()) {
                this.openTag("fiche-query");
                FichothequeXMLUtils.writeFicheQuery((XMLWriter)this, entry, true);
                this.closeTag("fiche-query");
            }
        }
        this.addGroupClause(corpusExtractDef.getGroupClause());
        this.addPackClause(corpusExtractDef.getPackClause());
        this.addTitleClause(corpusExtractDef.getTitleClause());
        this.addParameters(filterParameters);
        this.addFicheFilter(corpusExtractDef.getFicheFilter());
        this.closeTag(tagName);
    }

    private void addFicheFilter(FicheFilter ficheFilter) throws IOException {
        this.startOpenTag("fiche");
        this.addTagName(ficheFilter.getTagNameInfo());
        List<FilterUnit> filterUnitList = ficheFilter.getFilterUnitList();
        if (filterUnitList.isEmpty()) {
            this.closeEmptyTag();
        } else {
            this.endOpenTag();
            for (FilterUnit filterUnit : filterUnitList) {
                this.addFilterUnit(filterUnit);
            }
            this.closeTag("fiche");
        }
    }

    private void addDynamicThesaurusExtract(ThesaurusExtractDef thesaurusExtractDef) throws IOException {
        if (thesaurusExtractDef == null) {
            return;
        }
        this.addThesaurusExtract(thesaurusExtractDef, ExtractionUtils.EMPTY_FILTERPARAMETERS);
    }

    private void addThesaurusExtract(ThesaurusExtractFilterUnit filterUnit) throws IOException {
        this.addThesaurusExtract(filterUnit.getThesaurusExtractDef(), filterUnit);
    }

    private void addThesaurusExtract(ThesaurusExtractDef thesaurusExtractDef, FilterParameters filterParameters) throws IOException {
        String tagName = "motcles";
        this.startOpenTag(tagName);
        this.addAttribute("name", thesaurusExtractDef.getName());
        this.addTagName(thesaurusExtractDef.getTagNameInfo());
        if (thesaurusExtractDef.isMaster()) {
            this.addAttribute("source", "master");
        }
        this.endOpenTag();
        for (MotcleCondition.Entry entry : thesaurusExtractDef.getConditionEntryList()) {
            this.openTag("motcle-query");
            FichothequeXMLUtils.writeMotcleQuery((XMLWriter)this, entry, true);
            this.closeTag("motcle-query");
        }
        this.addParameters(filterParameters);
        this.addMotcleFilter(thesaurusExtractDef.getMotcleFilter());
        this.closeTag(tagName);
    }

    private void addAddendaExtract(AddendaExtractFilterUnit filterUnit) throws IOException {
        AddendaExtractDef addendaExtractDef = filterUnit.getAddendaExtractDef();
        String tagName = "documents";
        this.startOpenTag(tagName);
        this.addAttribute("name", addendaExtractDef.getName());
        this.addTagName(addendaExtractDef.getTagNameInfo());
        this.endOpenTag();
        for (DocumentCondition.Entry entry : addendaExtractDef.getConditionEntryList()) {
            this.openTag("document-query");
            FichothequeXMLUtils.writeDocumentQuery(this, entry.getDocumentQuery(), entry.getJunctionCondition());
            this.closeTag("document-query");
        }
        this.addParameters(filterUnit);
        DocumentFilter documentFilter = addendaExtractDef.getDocumentFilter();
        this.startOpenTag("document");
        this.addTagName(documentFilter.getTagNameInfo());
        this.closeEmptyTag();
        this.closeTag(tagName);
    }

    private void addAlbumExtract(AlbumExtractFilterUnit filterUnit) throws IOException {
        AlbumExtractDef albumExtractDef = filterUnit.getAlbumExtractDef();
        String tagName = "illustrations";
        this.startOpenTag(tagName);
        this.addAttribute("name", albumExtractDef.getName());
        this.addTagName(albumExtractDef.getTagNameInfo());
        this.endOpenTag();
        for (IllustrationCondition.Entry entry : albumExtractDef.getConditionEntryList()) {
            this.openTag("illustration-query");
            FichothequeXMLUtils.writeIllustrationQuery(this, entry.getIllustrationQuery(), entry.getJunctionCondition());
            this.closeTag("illustration-query");
        }
        this.addParameters(filterUnit);
        IllustrationFilter illustrationFilter = albumExtractDef.getIllustrationFilter();
        this.startOpenTag("illustration");
        this.addTagName(illustrationFilter.getTagNameInfo());
        this.closeEmptyTag();
        this.closeTag(tagName);
    }

    private void addGroupClause(GroupClause groupClause) throws IOException {
        if (groupClause == null) {
            return;
        }
        this.startOpenTag("group");
        this.addAttribute("type", groupClause.getGroupType());
        GroupParams groupParams = groupClause.getGroupParams();
        if (groupParams != null) {
            this.addAttribute("params", groupParams.toString());
        }
        this.addAttribute("sort", groupClause.getSortOrder());
        this.addTagName(groupClause.getTagNameInfo());
        GroupClause subGroupClause = groupClause.getSubGroupClause();
        if (subGroupClause != null) {
            this.endOpenTag();
            this.addGroupClause(subGroupClause);
            this.closeTag("group");
        } else {
            this.closeEmptyTag();
        }
    }

    private void addPackClause(PackClause packClause) throws IOException {
        if (packClause == null) {
            return;
        }
        this.startOpenTag("pack");
        this.addAttribute("size", String.valueOf(packClause.getPackSize()));
        int modulo = packClause.getModulo();
        if (modulo > 0) {
            this.addAttribute("size", String.valueOf(modulo));
        }
        this.addTagName(packClause.getTagNameInfo());
        this.closeEmptyTag();
    }

    private void addTitleClause(TitleClause titleClause) throws IOException {
        if (titleClause == null) {
            return;
        }
        if (titleClause.withTitle()) {
            this.addEmptyElement("title");
        }
    }

    private void addFilterUnit(FilterUnit filterUnit) throws IOException {
        if (filterUnit instanceof HeadFilterUnit) {
            this.addEmptyElement("entete");
        } else if (filterUnit instanceof BodyFilterUnit) {
            this.addEmptyElement("corpsdefiche");
        } else if (filterUnit instanceof FieldKeyFilterUnit) {
            this.addFieldKey((FieldKeyFilterUnit)filterUnit);
        } else if (filterUnit instanceof FieldNamePrefixFilterUnit) {
            this.addFieldNamePrefix((FieldNamePrefixFilterUnit)filterUnit);
        } else if (filterUnit instanceof LotFilterUnit) {
            this.addLot((LotFilterUnit)filterUnit);
        } else if (filterUnit instanceof ChronoFilterUnit) {
            if (this.compactStyle) {
                this.appendCompact("chrono");
            } else {
                this.addEmptyElement("chrono");
            }
        } else if (filterUnit instanceof PhraseFilterUnit) {
            if (this.compactStyle) {
                this.appendCompact("phrase_");
                this.addText(((PhraseFilterUnit)filterUnit).getName());
            } else {
                this.startOpenTag("phrase");
                this.addAttribute("name", ((PhraseFilterUnit)filterUnit).getName());
                this.closeEmptyTag();
            }
        } else if (filterUnit instanceof AddendaExtractFilterUnit) {
            if (!this.insertDefaultIncludeUnit(filterUnit)) {
                this.addAddendaExtract((AddendaExtractFilterUnit)filterUnit);
            }
        } else if (filterUnit instanceof CorpusExtractFilterUnit) {
            if (!this.insertDefaultIncludeUnit(filterUnit)) {
                this.addCorpusExtract((CorpusExtractFilterUnit)filterUnit);
            }
        } else if (filterUnit instanceof ThesaurusExtractFilterUnit) {
            if (!this.insertDefaultIncludeUnit(filterUnit)) {
                this.addThesaurusExtract((ThesaurusExtractFilterUnit)filterUnit);
            }
        } else if (filterUnit instanceof AlbumExtractFilterUnit) {
            if (!this.insertDefaultIncludeUnit(filterUnit)) {
                this.addAlbumExtract((AlbumExtractFilterUnit)filterUnit);
            }
        } else if (filterUnit instanceof FicheParentageFilterUnit) {
            this.addFicheParentage((FicheParentageFilterUnit)filterUnit);
        } else if (filterUnit instanceof MasterMotcleFilterUnit) {
            this.addMasterMotcle((MasterMotcleFilterUnit)filterUnit);
        } else if (filterUnit instanceof DataFilterUnit) {
            this.addData((DataFilterUnit)filterUnit);
        }
    }

    private boolean insertDefaultIncludeUnit(FilterUnit filterUnit) throws IOException {
        if (!this.compactStyle) {
            return false;
        }
        if (!(filterUnit instanceof DefaultIncludeUnit)) {
            return false;
        }
        this.appendIndent();
        this.append(((DefaultIncludeUnit)((Object)filterUnit)).getExtendedIncludeKey().getKeyString());
        return true;
    }

    private void addTagName(TagNameInfo tagNameInfo) throws IOException {
        switch (tagNameInfo.getType()) {
            case 3: {
                this.addAttribute("tag-name", tagNameInfo.getCustomTagName());
                break;
            }
            case 2: {
                this.addAttribute("tag-name", "_null");
            }
        }
    }

    private void addFicheParentage(FicheParentageFilterUnit filterUnit) throws IOException {
        FicheFilter ficheFilter = filterUnit.getFicheFilter();
        this.startOpenTag("fiche");
        List<SubsetKey> subsetKeyList = filterUnit.getSubsetKeyList();
        if (!subsetKeyList.isEmpty()) {
            StringBuilder buf = new StringBuilder();
            for (SubsetKey subsetKey : subsetKeyList) {
                if (buf.length() > 0) {
                    buf.append(',');
                }
                buf.append(subsetKey.getSubsetName());
            }
            this.addAttribute("corpus", buf.toString());
        }
        this.addTagName(ficheFilter.getTagNameInfo());
        List<FilterUnit> filterUnitList = ficheFilter.getFilterUnitList();
        if (filterUnitList.isEmpty() && filterUnit.isEmpty()) {
            this.closeEmptyTag();
        } else {
            this.endOpenTag();
            this.addParameters(filterUnit);
            for (FilterUnit childFilterUnit : filterUnitList) {
                this.addFilterUnit(childFilterUnit);
            }
            this.closeTag("fiche");
        }
    }

    private void addMasterMotcle(MasterMotcleFilterUnit filterUnit) throws IOException {
        this.addMotcleFilter(filterUnit.getMotcleFilter(), filterUnit);
    }

    private void addMotcleFilter(MotcleFilter motcleFilter) throws IOException {
        this.addMotcleFilter(motcleFilter, ExtractionUtils.EMPTY_FILTERPARAMETERS);
    }

    private void addMotcleFilter(MotcleFilter motcleFilter, FilterParameters filterParameters) throws IOException {
        MotcleFilter childrenFilter;
        MotcleFilter previousFilter;
        MotcleFilter nextFilter;
        MotcleFilter parentFilter;
        String tagName = this.getTagName(motcleFilter);
        this.startOpenTag(tagName);
        if (this.isRecursive(motcleFilter)) {
            this.addAttribute("recursive", "1");
        }
        this.addTagName(motcleFilter.getTagNameInfo());
        if (motcleFilter.isNoneFiltering() && filterParameters.isEmpty()) {
            this.closeEmptyTag();
            return;
        }
        this.endOpenTag();
        this.addParameters(filterParameters);
        if (motcleFilter.withIcon()) {
            this.addEmptyElement("icon");
        }
        if (motcleFilter.withLabels()) {
            this.addEmptyElement("labels");
        }
        if (motcleFilter.withLevel()) {
            this.addEmptyElement("level");
        }
        if (motcleFilter.withFicheStylePhrase()) {
            this.startOpenTag("phrase");
            this.addAttribute("name", "fichestyle");
            this.closeEmptyTag();
        }
        if ((parentFilter = motcleFilter.getParentFilter()) != null && !parentFilter.equals(motcleFilter)) {
            this.addMotcleFilter(parentFilter);
        }
        if ((nextFilter = motcleFilter.getNextFilter()) != null) {
            this.addMotcleFilter(nextFilter);
        }
        if ((previousFilter = motcleFilter.getPreviousFilter()) != null) {
            this.addMotcleFilter(previousFilter);
        }
        if ((childrenFilter = motcleFilter.getChildrenFilter()) != null && !childrenFilter.equals(motcleFilter)) {
            this.addMotcleFilter(childrenFilter);
        }
        for (FilterUnit filterUnit : motcleFilter.getFilterUnitList()) {
            this.addFilterUnit(filterUnit);
        }
        this.closeTag(tagName);
    }

    private boolean isRecursive(MotcleFilter motcleFilter) {
        boolean isRecursive = false;
        switch (motcleFilter.getType()) {
            case 1: {
                MotcleFilter childrenFilter = motcleFilter.getChildrenFilter();
                if (childrenFilter == null || childrenFilter.equals(motcleFilter)) break;
                isRecursive = true;
                break;
            }
            case 2: {
                MotcleFilter parentFilter = motcleFilter.getParentFilter();
                if (parentFilter == null || parentFilter.equals(motcleFilter)) break;
                isRecursive = true;
                break;
            }
        }
        return isRecursive;
    }

    private String getTagName(MotcleFilter motcleFilter) {
        switch (motcleFilter.getType()) {
            case 4: {
                return "next";
            }
            case 2: {
                return "parent";
            }
            case 3: {
                return "previous";
            }
        }
        return "motcle";
    }

    private void addData(DataFilterUnit dataFilterUnit) throws IOException {
        if (this.compactStyle && dataFilterUnit.isEmpty()) {
            this.appendCompact("data_" + dataFilterUnit.getName());
            return;
        }
        this.startOpenTag("data");
        this.addAttribute("name", dataFilterUnit.getName());
        if (dataFilterUnit.isEmpty()) {
            this.closeEmptyTag();
        } else {
            this.endOpenTag();
            this.addParameters(dataFilterUnit);
            this.closeTag("data");
        }
    }

    private void addFieldKey(FieldKeyFilterUnit filterUnit) throws IOException {
        FieldKey fieldKey = filterUnit.getFieldKey();
        if (this.compactStyle && filterUnit.isEmpty()) {
            this.appendCompact(fieldKey.getKeyString());
            return;
        }
        switch (fieldKey.getCategory()) {
            case 1: {
                this.startOpenTag("prop");
                this.addAttribute("name", fieldKey.getFieldName());
                break;
            }
            case 2: {
                this.startOpenTag("info");
                this.addAttribute("name", fieldKey.getFieldName());
                break;
            }
            case 3: {
                this.startOpenTag("section");
                this.addAttribute("name", fieldKey.getFieldName());
                break;
            }
            case 0: {
                this.startOpenTag(fieldKey.getKeyString());
                break;
            }
            default: {
                throw new SwitchException("Unknown category = " + fieldKey.getCategory());
            }
        }
        if (filterUnit.isEmpty()) {
            this.closeEmptyTag();
        } else {
            this.endOpenTag();
            this.addParameters(filterUnit);
            switch (fieldKey.getCategory()) {
                case 1: {
                    this.closeTag("prop");
                    break;
                }
                case 2: {
                    this.closeTag("info");
                    break;
                }
                case 3: {
                    this.closeTag("section");
                    break;
                }
                case 0: {
                    this.closeTag(fieldKey.getKeyString());
                    break;
                }
                default: {
                    throw new SwitchException("Unknown category = " + fieldKey.getCategory());
                }
            }
        }
    }

    private void addFieldNamePrefix(FieldNamePrefixFilterUnit filterUnit) throws IOException {
        short category = filterUnit.getCategory();
        String tagName = FieldKey.categoryToString(category);
        this.startOpenTag(tagName);
        this.addAttribute("name", filterUnit.getPrefix() + "*");
        if (filterUnit.isEmpty()) {
            this.closeEmptyTag();
        } else {
            this.endOpenTag();
            this.addParameters(filterUnit);
            this.closeTag(tagName);
        }
    }

    private void addLot(LotFilterUnit lotFilterUnit) throws IOException {
        this.startOpenTag("lot");
        this.addTagName(lotFilterUnit.getTagNameInfo());
        this.endOpenTag();
        for (FilterUnit filterUnit : lotFilterUnit.getFilterUnitList()) {
            this.addFilterUnit(filterUnit);
        }
        this.closeTag("lot");
    }

    private void appendCompact(String text) throws IOException {
        this.appendIndent();
        this.append(text);
    }

    private boolean canIgnore(CorpusExtractDef corpusExtractDef) {
        if (corpusExtractDef.getTagNameInfo().getType() != 2) {
            return false;
        }
        if (corpusExtractDef.getName() != null) {
            return false;
        }
        if (corpusExtractDef.hasClauseObjects()) {
            return false;
        }
        if (corpusExtractDef.hasBooleanParameters()) {
            return false;
        }
        return corpusExtractDef.getConditionEntryList().isEmpty();
    }

    private String getOnlyCorpusAttribute(List<FicheCondition.Entry> entryList) {
        if (entryList.size() != 1) {
            return null;
        }
        FicheCondition.Entry entry = entryList.get(0);
        if (entry.getJunctionCondition() != null) {
            return null;
        }
        if (entry.includeSatellites()) {
            return null;
        }
        if (!entry.getFicheQuery().isOnlyCorpusCondition()) {
            return null;
        }
        SubsetCondition corpusCondition = entry.getFicheQuery().getCorpusCondition();
        if (corpusCondition.isWithCurrent() || corpusCondition.isExclude()) {
            return null;
        }
        StringBuilder buf = new StringBuilder();
        for (SubsetKey corpusKey : corpusCondition.getSubsetKeySet()) {
            if (buf.length() > 0) {
                buf.append(",");
            }
            buf.append(corpusKey.getSubsetName());
        }
        return buf.toString();
    }

    private void addParameters(FilterParameters filterParameters) throws IOException {
        HashMap<String, String> cellParamMap = new HashMap<String, String>();
        block8: for (String string : filterParameters.getParameterNameSet()) {
            String cellSubparam;
            if (string.startsWith("cell-") && StringUtils.isTechnicalName(cellSubparam = string.substring("cell-".length()), false)) {
                cellParamMap.put(cellSubparam, filterParameters.getFirstValue(string));
                continue;
            }
            switch (string) {
                case "hide": {
                    this.addSimpleElement("hide", filterParameters.getFirstValue(string));
                    break;
                }
                case "groups": {
                    for (String value : filterParameters.getParameter(string)) {
                        this.addSimpleElement("groups", value);
                    }
                    continue block8;
                }
                default: {
                    for (String value : filterParameters.getParameter(string)) {
                        this.startOpenTag("param");
                        this.addAttribute("name", string);
                        this.endOpenTag();
                        this.addText(value);
                        this.closeTag("param", false);
                    }
                    continue block8;
                }
            }
        }
        if (!cellParamMap.isEmpty()) {
            this.startOpenTag("cell");
            for (Map.Entry entry : cellParamMap.entrySet()) {
                this.addAttribute((String)entry.getKey(), (String)entry.getValue());
            }
            this.closeEmptyTag();
        }
    }

    public static ExtractionDefXMLPart init(AppendableXMLWriter xmlWriter, boolean compactStyle) {
        return new ExtractionDefXMLPart(xmlWriter, compactStyle);
    }
}

