/*
 * Decompiled with CFR 0.152.
 */
package net.fichotheque.utils;

import java.io.IOException;
import java.util.List;
import net.fichotheque.corpus.metadata.FieldKey;
import net.fichotheque.format.FichothequeFormatDef;
import net.fichotheque.format.FormatSourceKey;
import net.mapeadores.util.format.FormatDef;
import net.mapeadores.util.format.FormatUtils;
import net.mapeadores.util.instruction.InstructionUtils;

public final class FichothequeFormatUtils {
    private FichothequeFormatUtils() {
    }

    public static FieldKey toFieldKey(Object value) {
        if (value == null) {
            return null;
        }
        try {
            return (FieldKey)value;
        }
        catch (ClassCastException cce) {
            return null;
        }
    }

    public static String toLines(FichothequeFormatDef formatDef) {
        StringBuilder buf = new StringBuilder();
        try {
            FichothequeFormatUtils.appendLines(formatDef, buf);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return buf.toString();
    }

    public static void appendLines(FichothequeFormatDef formatDef, Appendable appendable) throws IOException {
        String[] array = FichothequeFormatUtils.toStringArray(formatDef);
        appendable.append(array[0]);
        appendable.append('\n');
        String format = array[1];
        String param = array[2];
        if (format == null) {
            if (param != null) {
                appendable.append("-\n");
            }
        } else {
            appendable.append(format);
            appendable.append('\n');
        }
        if (param != null) {
            appendable.append(param);
            appendable.append('\n');
        }
    }

    public static String[] toStringArray(FichothequeFormatDef formatDef) {
        StringBuilder buf = new StringBuilder();
        for (FormatSourceKey formatSourceKey : formatDef.getFormatSourceKeyList()) {
            if (buf.length() > 0) {
                buf.append(',');
            }
            buf.append(formatSourceKey);
        }
        String[] result = new String[]{buf.toString(), FichothequeFormatUtils.formatPatternListToString(formatDef), FichothequeFormatUtils.paramToString(formatDef)};
        return result;
    }

    public static String getFormatPatternBySourceIndex(FichothequeFormatDef formatDef, int sourceIndex) {
        List<FormatDef.Pattern> patternList = formatDef.getPatternList();
        int size = patternList.size();
        if (size == 0) {
            return null;
        }
        if (sourceIndex >= size) {
            sourceIndex = size - 1;
        }
        return FichothequeFormatUtils.getFormatPattern(patternList, sourceIndex);
    }

    private static String getFormatPattern(List<FormatDef.Pattern> patternList, int i) {
        FormatDef.Pattern formatPattern = patternList.get(i);
        if (!formatPattern.isDefault()) {
            return formatPattern.getPattern();
        }
        if (i == 0) {
            return null;
        }
        return FichothequeFormatUtils.getFormatPattern(patternList, i - 1);
    }

    public static String formatPatternListToString(FichothequeFormatDef formatDef) {
        List<FormatDef.Pattern> patternList = formatDef.getPatternList();
        if (patternList.isEmpty()) {
            return null;
        }
        StringBuilder buf = new StringBuilder();
        for (FormatDef.Pattern pattern : patternList) {
            if (buf.length() > 0) {
                buf.append("||");
            }
            if (pattern.isDefault()) {
                buf.append(' ');
                continue;
            }
            buf.append(pattern.getPattern());
        }
        return buf.toString();
    }

    public static String paramToString(FichothequeFormatDef formatDef) {
        ParamStringBuilder stringBuilder = new ParamStringBuilder(formatDef);
        String result = stringBuilder.toString();
        if (result.length() == 0) {
            return null;
        }
        return result;
    }

    public static boolean isSame(FichothequeFormatDef formatDef1, FichothequeFormatDef formatDef2) {
        String stg1 = FichothequeFormatUtils.toLines(formatDef1);
        String stg2 = FichothequeFormatUtils.toLines(formatDef2);
        return stg1.equals(stg2);
    }

    private static class ParamStringBuilder {
        StringBuilder buf;
        boolean suite = false;
        FichothequeFormatDef formatDef;

        ParamStringBuilder(FichothequeFormatDef formatDef) {
            this.formatDef = formatDef;
            this.buf = new StringBuilder();
            this.initSum();
            this.initInstructionString("posttransform");
            this.initInstructionString("prefix");
            this.initInstructionString("suffix");
            this.initCast();
            this.initBoolean("jsonarray");
            this.initInteger("maxlength");
            this.initInteger("fixedlength");
            this.initFixedChar();
            this.initBoolean("fixedempty");
            this.initPosition();
            this.initInteger("limit");
            this.initBoolean("unique");
            this.initInstructionString("sep");
            this.initInstructionString("defval");
            this.initBoolean("null");
            this.initGlobalSelect();
            this.initBoolean("columnsum");
            this.initFormula();
            for (FormatDef.InnerSeparator innerSeparator : formatDef.getInnerSeparatorList()) {
                this.testSuite();
                this.buf.append("sep");
                this.buf.append(innerSeparator.getSourceIndex() + 1);
                this.buf.append('=');
                this.appendInstructionString(innerSeparator.getSeparator());
            }
            for (FormatDef.SourceSeparator sourceSeparator : formatDef.getSourceSeparatorList()) {
                this.testSuite();
                this.buf.append("sep");
                this.buf.append(sourceSeparator.getSourceIndex1() + 1);
                this.buf.append('_');
                this.buf.append(sourceSeparator.getSourceIndex2() + 1);
                this.buf.append('=');
                this.appendInstructionString(sourceSeparator.getSeparator());
            }
            Object fieldKeyValue = formatDef.getParameterValue("defprop");
            if (fieldKeyValue != null) {
                this.testSuite();
                this.buf.append("defprop");
                this.buf.append('=');
                this.buf.append(((FieldKey)fieldKeyValue).getKeyString());
            }
            this.initBoolean("noitem");
            this.initBoolean("onlyitem");
            this.initBoolean("idsort");
        }

        public String toString() {
            return this.buf.toString();
        }

        private void initBoolean(String name) {
            if (FormatUtils.getBoolean(this.formatDef, name)) {
                this.testSuite();
                this.buf.append(name);
            }
        }

        private void initInstructionString(String name) {
            Object value = this.formatDef.getParameterValue(name);
            if (value != null) {
                this.testSuite();
                this.buf.append(name);
                this.buf.append('=');
                this.appendInstructionString((String)value);
            }
        }

        private void initInteger(String name) {
            Object value = this.formatDef.getParameterValue(name);
            if (value != null) {
                this.testSuite();
                this.buf.append(name);
                this.buf.append('=');
                this.buf.append(((Integer)value).toString());
            }
        }

        private void initCast() {
            String cast;
            Object value = this.formatDef.getParameterValue("cast");
            if (value != null && !(cast = (String)value).isEmpty()) {
                this.testSuite();
                this.buf.append("cast");
                this.buf.append('=');
                this.buf.append(cast);
            }
        }

        private void initFixedChar() {
            Object value = this.formatDef.getParameterValue("fixedchar");
            if (value != null) {
                this.testSuite();
                this.buf.append("fixedchar");
                this.buf.append('=');
                this.buf.append((Character)value);
            }
        }

        private void initSum() {
            Object value = this.formatDef.getParameterValue("sum");
            if (value != null) {
                this.testSuite();
                this.buf.append("sum");
                String sumCast = (String)value;
                if (!sumCast.isEmpty()) {
                    this.buf.append('=');
                    this.buf.append(sumCast);
                }
            }
        }

        private void initFormula() {
            Object value = this.formatDef.getParameterValue("formula");
            if (value != null) {
                this.testSuite();
                this.buf.append("formula");
                String formulaCast = (String)value;
                if (!formulaCast.isEmpty()) {
                    this.buf.append('=');
                    this.buf.append(formulaCast);
                }
            }
        }

        private void initPosition() {
            Object value = this.formatDef.getParameterValue("pos");
            if (value != null) {
                this.testSuite();
                int position = (Integer)value;
                this.buf.append("pos");
                this.buf.append('=');
                if (position == 999999999) {
                    this.buf.append("last");
                } else {
                    this.buf.append(position + 1);
                }
            }
        }

        private void initGlobalSelect() {
            Object value = this.formatDef.getParameterValue("globalselect");
            if (value != null) {
                this.testSuite();
                this.buf.append("globalselect");
                if (!((Boolean)value).booleanValue()) {
                    this.buf.append("=0");
                }
            }
        }

        private void appendInstructionString(String s) {
            try {
                InstructionUtils.appendInstructionString(s, this.buf);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        private void testSuite() {
            if (this.suite) {
                this.buf.append(',');
            } else {
                this.suite = true;
            }
        }
    }
}

