/*
 * Decompiled with CFR 0.152.
 */
package net.fichotheque.tools.importation.parsers.thesaurus;

import java.text.ParseException;
import java.util.LinkedHashMap;
import net.fichotheque.Fichotheque;
import net.fichotheque.thesaurus.Thesaurus;
import net.fichotheque.thesaurus.metadata.ThesaurusFieldKey;
import net.fichotheque.tools.importation.ParseResultBuilder;
import net.fichotheque.tools.importation.parsers.handlers.AttributeHandler;
import net.fichotheque.tools.importation.parsers.handlers.IdalphaHandler;
import net.fichotheque.tools.importation.parsers.handlers.JunctionHandlers;
import net.fichotheque.tools.importation.parsers.handlers.LabelHandler;
import net.fichotheque.tools.importation.thesaurus.ThesaurusImportBuilder;
import net.mapeadores.util.attr.AttributeKey;

class ThesaurusColumns {
    private static final String BABELIEN_KEY = "babelien";
    private final int idIndex;
    private final int parentIdIndex;
    private final int statusIndex;
    private final IdalphaHandler idalphaHandler;
    private final IdalphaHandler parentIdalphaHandler;
    private final LabelHandler[] labelHandlerArray;
    private final AttributeHandler[] attributeHandlerArray;
    private final JunctionHandlers junctionHandlers;

    private ThesaurusColumns(int idIndex, int parentIdIndex, int statusIndex, IdalphaHandler idalphaHandler, IdalphaHandler parentIdalphaHandler, LabelHandler[] labelHandlerArray, AttributeHandler[] attributeHandlerArray, JunctionHandlers junctionHandlers) {
        this.idIndex = idIndex;
        this.parentIdIndex = parentIdIndex;
        this.statusIndex = statusIndex;
        this.labelHandlerArray = labelHandlerArray;
        this.idalphaHandler = idalphaHandler;
        this.parentIdalphaHandler = parentIdalphaHandler;
        this.attributeHandlerArray = attributeHandlerArray;
        this.junctionHandlers = junctionHandlers;
    }

    public int getIdIndex() {
        return this.idIndex;
    }

    public int getParentIdIndex() {
        return this.parentIdIndex;
    }

    public int getStatusIndex() {
        return this.statusIndex;
    }

    public IdalphaHandler getIdalphaHandler() {
        return this.idalphaHandler;
    }

    public IdalphaHandler getParentIdalphaHandler() {
        return this.parentIdalphaHandler;
    }

    public boolean hasLabelHandler() {
        return this.labelHandlerArray != null;
    }

    public LabelHandler[] getLabelHandlerArray() {
        return this.labelHandlerArray;
    }

    public boolean hasAttributeHandler() {
        return this.attributeHandlerArray != null;
    }

    public AttributeHandler[] getAttributeHandlerArray() {
        return this.attributeHandlerArray;
    }

    public boolean hasJunctionHandler() {
        return !this.junctionHandlers.isEmpty();
    }

    public JunctionHandlers getJunctionHandlers() {
        return this.junctionHandlers;
    }

    static ThesaurusColumns parse(String[] fieldArray, ThesaurusImportBuilder thesaurusImportBuilder, ParseResultBuilder parseResultBuilder) {
        Thesaurus thesaurus = thesaurusImportBuilder.getThesaurus();
        Fichotheque fichotheque = thesaurusImportBuilder.getThesaurus().getFichotheque();
        boolean isBabelien = thesaurus.isBabelienType();
        boolean isIdalpha = thesaurus.isIdalphaType();
        int idIndex = -1;
        int parentIdIndex = -1;
        int statusIndex = -1;
        IdalphaHandler idalphaHandler = null;
        IdalphaHandler parentIdalphaHandler = null;
        LinkedHashMap<Object, LabelHandler> labelHandlerMap = new LinkedHashMap<Object, LabelHandler>();
        LinkedHashMap<AttributeKey, AttributeHandler> attributeHandlerMap = new LinkedHashMap<AttributeKey, AttributeHandler>();
        JunctionHandlers junctionHandlers = new JunctionHandlers(false, false);
        int length = fieldArray.length;
        for (int i = 0; i < length; ++i) {
            String field = fieldArray[i].trim();
            try {
                LabelHandler.Babelien babelienHandler;
                ThesaurusFieldKey thesaurusFieldKey = ThesaurusFieldKey.parse(field);
                if (thesaurusFieldKey.equals(ThesaurusFieldKey.ID)) {
                    if (idIndex == -1) {
                        idIndex = i;
                        continue;
                    }
                    parseResultBuilder.duplicateColumn(field);
                    continue;
                }
                if (thesaurusFieldKey.equals(ThesaurusFieldKey.PARENT_ID)) {
                    if (parentIdIndex == -1) {
                        parentIdIndex = i;
                        continue;
                    }
                    parseResultBuilder.duplicateColumn(field);
                    continue;
                }
                if (thesaurusFieldKey.equals(ThesaurusFieldKey.BABELIENLANG)) {
                    if (!isBabelien) {
                        parseResultBuilder.notAvailableColumn(field);
                        continue;
                    }
                    babelienHandler = (LabelHandler.Babelien)labelHandlerMap.get(BABELIEN_KEY);
                    if (babelienHandler != null) {
                        babelienHandler = new LabelHandler.Babelien();
                        labelHandlerMap.put(BABELIEN_KEY, babelienHandler);
                    }
                    if (babelienHandler.hasLangIndex()) {
                        parseResultBuilder.duplicateColumn(field);
                        continue;
                    }
                    babelienHandler.setLangIndex(i);
                    continue;
                }
                if (thesaurusFieldKey.equals(ThesaurusFieldKey.BABELIENLABEL)) {
                    if (!isBabelien) {
                        parseResultBuilder.notAvailableColumn(field);
                        continue;
                    }
                    babelienHandler = (LabelHandler.Babelien)labelHandlerMap.get(BABELIEN_KEY);
                    if (babelienHandler != null) {
                        babelienHandler = new LabelHandler.Babelien();
                        labelHandlerMap.put(BABELIEN_KEY, babelienHandler);
                    }
                    babelienHandler.addIndex(i);
                    continue;
                }
                if (thesaurusFieldKey.equals(ThesaurusFieldKey.IDALPHA)) {
                    if (!isIdalpha) {
                        parseResultBuilder.notUsableIdalpha(field);
                        continue;
                    }
                    if (idalphaHandler == null) {
                        idalphaHandler = new IdalphaHandler();
                    }
                    idalphaHandler.addIndex(i);
                    continue;
                }
                if (thesaurusFieldKey.equals(ThesaurusFieldKey.PARENT_IDALPHA)) {
                    if (!isIdalpha) {
                        parseResultBuilder.notUsableIdalpha(field);
                        continue;
                    }
                    if (parentIdalphaHandler == null) {
                        parentIdalphaHandler = new IdalphaHandler();
                    }
                    parentIdalphaHandler.addIndex(i);
                    continue;
                }
                if (thesaurusFieldKey.equals(ThesaurusFieldKey.STATUS)) {
                    if (statusIndex == -1) {
                        statusIndex = i;
                        continue;
                    }
                    parseResultBuilder.duplicateColumn(field);
                    continue;
                }
                if (thesaurusFieldKey.isLabelThesaurusFieldKey()) {
                    if (isBabelien) {
                        parseResultBuilder.notAvailableColumn(field);
                        continue;
                    }
                    LabelHandler handler = (LabelHandler)labelHandlerMap.get(thesaurusFieldKey);
                    if (handler == null) {
                        handler = new LabelHandler.ByLang(thesaurusFieldKey.getLang());
                        labelHandlerMap.put(thesaurusFieldKey, handler);
                    }
                    handler.addIndex(i);
                    continue;
                }
                parseResultBuilder.notAvailableColumn(field);
                continue;
            }
            catch (ParseException pe) {
                try {
                    AttributeKey attributeKey = AttributeKey.parse(field);
                    AttributeHandler attributeHandler = (AttributeHandler)attributeHandlerMap.get(attributeKey);
                    if (attributeHandler == null) {
                        attributeHandler = new AttributeHandler(attributeKey);
                        attributeHandlerMap.put(attributeKey, attributeHandler);
                    }
                    attributeHandler.addIndex(i);
                    continue;
                }
                catch (ParseException pe2) {
                    if (junctionHandlers.testJunctionHandlerCandidate(fichotheque, field, i, parseResultBuilder)) continue;
                    parseResultBuilder.wrongColumn(field);
                }
            }
        }
        LabelHandler.Babelien babelienHandler = (LabelHandler.Babelien)labelHandlerMap.get(BABELIEN_KEY);
        if (babelienHandler != null) {
            if (!babelienHandler.hasLangIndex()) {
                labelHandlerMap.remove(BABELIEN_KEY);
                parseResultBuilder.missingColumn(ThesaurusFieldKey.BABELIENLANG.toString());
            } else if (!babelienHandler.hasLibIndices()) {
                labelHandlerMap.remove(BABELIEN_KEY);
                parseResultBuilder.missingColumn(ThesaurusFieldKey.BABELIENLABEL.toString());
            }
        }
        LabelHandler[] labelHandlerArray = null;
        int labelHandlerSize = labelHandlerMap.size();
        if (labelHandlerSize > 0) {
            labelHandlerArray = labelHandlerMap.values().toArray(new LabelHandler[labelHandlerSize]);
        }
        AttributeHandler[] attributeHandlerArray = null;
        int attributeHandlerSize = attributeHandlerMap.size();
        if (attributeHandlerSize > 0) {
            attributeHandlerArray = attributeHandlerMap.values().toArray(new AttributeHandler[attributeHandlerSize]);
        }
        return new ThesaurusColumns(idIndex, parentIdIndex, statusIndex, idalphaHandler, parentIdalphaHandler, labelHandlerArray, attributeHandlerArray, junctionHandlers);
    }
}

