/*
 * Decompiled with CFR 0.152.
 */
package net.fichotheque.tools.importation.parsers.handlers;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.fichotheque.Fichotheque;
import net.fichotheque.Subset;
import net.fichotheque.SubsetKey;
import net.fichotheque.include.IncludeKey;
import net.fichotheque.tools.importation.ParseResultBuilder;
import net.fichotheque.tools.importation.parsers.Row;
import net.fichotheque.tools.importation.parsers.TiesParser;
import net.mapeadores.util.text.StringUtils;

public class JunctionHandlers {
    private final boolean replaceDefault;
    private final boolean allowLiage;
    private final List<InternalJunctionHandler> list = new ArrayList<InternalJunctionHandler>();
    private final Map<IncludeKey, InternalJunctionHandler> map = new HashMap<IncludeKey, InternalJunctionHandler>();
    private InternalJunctionHandler liageJunctionHandler;

    public JunctionHandlers(boolean replaceDefault, boolean allowLiage) {
        this.replaceDefault = replaceDefault;
        this.allowLiage = allowLiage;
    }

    public boolean isEmpty() {
        return this.list.isEmpty();
    }

    public void handle(Row row, TiesParser tiesParser) {
        for (InternalJunctionHandler junctionHandler : this.list) {
            junctionHandler.handle(row, tiesParser);
        }
    }

    public boolean testJunctionHandlerCandidate(Fichotheque fichotheque, String field, int index, ParseResultBuilder parseResultBuilder) {
        InternalJunctionHandler junctionHandler;
        int idx = field.indexOf("!");
        boolean replace = this.replaceDefault;
        boolean idalphaOnly = false;
        if (idx > 0) {
            String[] tokens;
            String params = field.substring(idx + 1);
            field = field.substring(0, idx);
            String[] stringArray = tokens = StringUtils.getTokens(params, ',', (short)2);
            int n = stringArray.length;
            block12: for (int i = 0; i < n; ++i) {
                String token;
                switch (token = stringArray[i]) {
                    case "append": {
                        replace = false;
                        continue block12;
                    }
                    case "replace": {
                        replace = true;
                        continue block12;
                    }
                    case "idalpha": {
                        idalphaOnly = true;
                    }
                }
            }
        }
        try {
            IncludeKey includeKey = IncludeKey.parse(field);
            SubsetKey subsetKey = includeKey.getSubsetKey();
            Subset subset = fichotheque.getSubset(subsetKey);
            if (subset == null) {
                parseResultBuilder.unknownSubset(includeKey.getKeyString());
                return true;
            }
            junctionHandler = this.getOrCreate(includeKey);
        }
        catch (ParseException pe) {
            if (field.equals("liage")) {
                if (!this.allowLiage) {
                    parseResultBuilder.notAvailableColumn(field);
                    return true;
                }
                if (this.liageJunctionHandler == null) {
                    this.liageJunctionHandler = new InternalJunctionHandler();
                    this.list.add(this.liageJunctionHandler);
                }
                junctionHandler = this.liageJunctionHandler;
            }
            return false;
        }
        if (replace) {
            junctionHandler.setReplace(true);
        }
        if (idalphaOnly) {
            junctionHandler.setIdalphaOnly(true);
        }
        junctionHandler.addIndex(index);
        return true;
    }

    private InternalJunctionHandler getOrCreate(IncludeKey includeKey) {
        InternalJunctionHandler junctionHandler = this.map.get(includeKey);
        if (junctionHandler == null) {
            junctionHandler = new InternalJunctionHandler(includeKey);
            this.list.add(junctionHandler);
            this.map.put(includeKey, junctionHandler);
        }
        return junctionHandler;
    }

    private static class InternalJunctionHandler {
        private final boolean isLiage;
        private final IncludeKey includeKey;
        private final List<Integer> indexList = new ArrayList<Integer>();
        private boolean replace = false;
        private boolean idalphaOnly = false;

        private InternalJunctionHandler(IncludeKey includeKey) {
            this.includeKey = includeKey;
            this.isLiage = false;
        }

        private InternalJunctionHandler() {
            this.isLiage = true;
            this.includeKey = null;
        }

        private void setReplace(boolean replace) {
            this.replace = replace;
        }

        private void setIdalphaOnly(boolean idalphaOnly) {
            this.idalphaOnly = idalphaOnly;
        }

        private void handle(Row row, TiesParser tiesParser) {
            if (this.replace && !this.isLiage) {
                tiesParser.addRemovedIncludeKey(this.includeKey);
            }
            int columnCount = row.getColumnCount();
            if (this.indexList.size() == 1) {
                int index = this.indexList.get(0);
                if (index < columnCount) {
                    if (this.isLiage) {
                        tiesParser.addLiage(Collections.singletonList(this.cleanValue(row, index)), this.replace);
                    } else {
                        tiesParser.add(this.includeKey, Collections.singletonList(this.cleanValue(row, index)), this.replace, this.idalphaOnly);
                    }
                }
            } else {
                ArrayList<String> stringList = new ArrayList<String>();
                for (Integer index : this.indexList) {
                    if (index >= columnCount) continue;
                    stringList.add(this.cleanValue(row, index));
                }
                if (this.isLiage) {
                    tiesParser.addLiage(stringList, this.replace);
                } else {
                    tiesParser.add(this.includeKey, stringList, this.replace, this.idalphaOnly);
                }
            }
        }

        private void addIndex(int index) {
            this.indexList.add(index);
        }

        private String cleanValue(Row row, int index) {
            String value = row.getColumnValue(index);
            int length = value.length();
            if (length == 0) {
                return value;
            }
            StringBuilder buf = new StringBuilder();
            block3: for (int i = 0; i < length; ++i) {
                char carac = value.charAt(i);
                switch (carac) {
                    case '\u00a0': 
                    case '\u2007': 
                    case '\u202f': {
                        buf.append(' ');
                        continue block3;
                    }
                    default: {
                        buf.append(carac);
                    }
                }
            }
            return buf.toString();
        }
    }
}

