/*
 * Decompiled with CFR 0.152.
 */
package net.fichotheque.tools.format.patterndefs;

import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.fichotheque.format.PatternDef;
import net.fichotheque.tools.format.patterndefs.PatternDefUtils;
import net.mapeadores.util.text.StringUtils;

public class PatternDefBuilder {
    private final Map<String, ParameterDefBuilder> builderMap = new LinkedHashMap<String, ParameterDefBuilder>();
    private final String name;
    private String directValueType = null;

    public PatternDefBuilder(String name) {
        this.name = name;
    }

    public PatternDefBuilder setDirectValueType(String directValueType) {
        this.directValueType = directValueType;
        return this;
    }

    public PatternDefBuilder addParameter(String name, String ... availableValues) {
        ParameterDefBuilder builder = this.builderMap.get(name);
        if (builder == null) {
            builder = new ParameterDefBuilder(name);
            this.builderMap.put(name, builder);
        }
        builder.add(availableValues);
        return this;
    }

    public PatternDef toPatternDef() {
        int size = this.builderMap.size();
        PatternDef.ParameterDef[] array = new PatternDef.ParameterDef[size];
        int p = 0;
        for (ParameterDefBuilder builder : this.builderMap.values()) {
            array[p] = builder.toParameterDef();
            ++p;
        }
        return new InternalPatternDef(this.name, this.directValueType, PatternDefUtils.wrap(array));
    }

    public static PatternDefBuilder init(String name) {
        return new PatternDefBuilder(name);
    }

    private static class ParameterDefBuilder {
        private final String name;
        private final Set<String> valueSet = new LinkedHashSet<String>();

        private ParameterDefBuilder(String name) {
            this.name = name;
        }

        private ParameterDefBuilder add(String ... values) {
            if (values != null) {
                for (String value : values) {
                    this.valueSet.add(value);
                }
            }
            return this;
        }

        private PatternDef.ParameterDef toParameterDef() {
            List<String> finalList = StringUtils.toList(this.valueSet);
            return new InternalParameterDef(this.name, finalList);
        }
    }

    private static class InternalPatternDef
    implements PatternDef {
        private final String name;
        private final String directValueType;
        private final List<PatternDef.ParameterDef> parameterDefList;

        private InternalPatternDef(String name, String parametersFamily, List<PatternDef.ParameterDef> parameterDefList) {
            this.name = name;
            this.directValueType = parametersFamily;
            this.parameterDefList = parameterDefList;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public String getDirectValueType() {
            return this.directValueType;
        }

        @Override
        public List<PatternDef.ParameterDef> getParameterDefList() {
            return this.parameterDefList;
        }
    }

    private static class InternalParameterDef
    implements PatternDef.ParameterDef {
        private final String name;
        private final List<String> availableValueList;

        private InternalParameterDef(String name, List<String> availableValueList) {
            this.name = name;
            this.availableValueList = availableValueList;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public List<String> getAvailableValueList() {
            return this.availableValueList;
        }
    }
}

