/*
 * Decompiled with CFR 0.152.
 */
package net.fichotheque.tools.format.formatters;

import java.io.IOException;
import net.fichotheque.album.Illustration;
import net.fichotheque.format.FormatContext;
import net.fichotheque.format.FormatSource;
import net.fichotheque.format.formatters.IllustrationFormatter;
import net.fichotheque.json.IllustrationJson;
import net.fichotheque.tools.format.formatters.JsonParameters;
import net.fichotheque.tools.format.patterndefs.DefaultPattern;
import net.fichotheque.utils.FormatterUtils;
import net.mapeadores.util.exceptions.ShouldNotOccurException;
import net.mapeadores.util.instruction.Argument;
import net.mapeadores.util.instruction.Instruction;
import net.mapeadores.util.instruction.InstructionResolver;
import net.mapeadores.util.instruction.InstructionResolverProvider;
import net.mapeadores.util.json.JSONWriter;
import net.mapeadores.util.logging.ErrorMessageException;
import net.mapeadores.util.logging.MessageHandler;

public final class IllustrationFormatterParser {
    private static final IllustrationFormatter ALBUM_PART = (illustration, weight, formatSource) -> illustration.getSubsetName();
    private static final IllustrationFormatter FORMAT_PART = (illustration, weight, formatSource) -> illustration.getFormatType();
    private static final IllustrationFormatter ID_PART = (illustration, weight, formatSource) -> String.valueOf(illustration.getId());
    private static final IllustrationFormatter WEIGHT_PART = (illustration, weight, formatSource) -> String.valueOf(weight);
    private static final IllustrationFormatter WITHWEIGHTFILTER_FORMSYNTAX_PART = new FormSyntaxPart(true);
    private static final IllustrationFormatter WITHOUTWEIGHTFILTER_FORMSYNTAX_PART = new FormSyntaxPart(false);
    private static final JsonParameters DEFAULT_JSONPARAMETERS = JsonParameters.parse("format");

    private IllustrationFormatterParser() {
    }

    public static IllustrationFormatter parse(String pattern, FormatContext formatContext, boolean withWeightFilter, MessageHandler messageHandler) {
        if (pattern == null) {
            pattern = DefaultPattern.illustration();
        }
        try {
            return IllustrationFormatterParser.parse(pattern, formatContext, withWeightFilter);
        }
        catch (ErrorMessageException fe) {
            messageHandler.addMessage("severe.format.pattern", fe.getErrorMessage());
            return null;
        }
    }

    public static IllustrationFormatter parse(String pattern, FormatContext formatContext, boolean withWeightFilter) throws ErrorMessageException {
        Object[] partArray = FormatterUtils.parsePattern(new InternalInstructionResolver(formatContext, withWeightFilter), pattern);
        return new InternalIllustrationFormatter(partArray);
    }

    private static class InternalInstructionResolver
    implements InstructionResolver {
        private final InstructionResolverProvider provider;
        private final boolean withWeightFilter;

        private InternalInstructionResolver(FormatContext formatContext, boolean withWeightFilter) {
            this.provider = formatContext.getInstructionResolverProvider();
            this.withWeightFilter = withWeightFilter;
        }

        @Override
        public Object resolve(Instruction instruction) throws ErrorMessageException {
            String key;
            Object formatter;
            InstructionResolver resolver = this.provider.getInstructionResolver(IllustrationFormatter.class);
            if (resolver != null && (formatter = resolver.resolve(instruction)) != null) {
                return formatter;
            }
            Argument arg1 = (Argument)instruction.get(0);
            switch (key = arg1.getKey()) {
                case "album": {
                    return ALBUM_PART;
                }
                case "format": {
                    return FORMAT_PART;
                }
                case "formsyntax": {
                    if (this.withWeightFilter) {
                        return WITHWEIGHTFILTER_FORMSYNTAX_PART;
                    }
                    return WITHOUTWEIGHTFILTER_FORMSYNTAX_PART;
                }
                case "id": 
                case "idalbum": {
                    return ID_PART;
                }
                case "json": {
                    JsonParameters jsonParameters = JsonParameters.fromInstruction(instruction);
                    if (jsonParameters == null) {
                        jsonParameters = DEFAULT_JSONPARAMETERS;
                    }
                    return new JsonPart(jsonParameters);
                }
                case "weight": 
                case "poids": {
                    return WEIGHT_PART;
                }
            }
            return null;
        }
    }

    private static class InternalIllustrationFormatter
    implements IllustrationFormatter {
        private final Object[] partArray;

        private InternalIllustrationFormatter(Object[] partArray) {
            this.partArray = partArray;
        }

        @Override
        public String formatIllustration(Illustration illustration, int weight, FormatSource formatSource) {
            StringBuilder buf = new StringBuilder();
            for (Object obj : this.partArray) {
                if (obj instanceof String) {
                    buf.append((String)obj);
                    continue;
                }
                IllustrationFormatter formatter = (IllustrationFormatter)obj;
                buf.append(formatter.formatIllustration(illustration, weight, formatSource));
            }
            return buf.toString();
        }
    }

    private static class FormSyntaxPart
    implements IllustrationFormatter {
        private final boolean withWeightFilter;

        private FormSyntaxPart(boolean withWeightFilter) {
            this.withWeightFilter = withWeightFilter;
        }

        @Override
        public String formatIllustration(Illustration illustration, int weight, FormatSource formatSource) {
            if (this.withWeightFilter || weight == 1) {
                return String.valueOf(illustration.getId());
            }
            StringBuilder buf = new StringBuilder();
            buf.append(String.valueOf(illustration.getId()));
            buf.append(" <");
            buf.append(weight);
            buf.append(">");
            return buf.toString();
        }
    }

    private static class JsonPart
    implements IllustrationFormatter {
        private final JsonParameters jsonParameters;

        private JsonPart(JsonParameters jsonParameters) {
            this.jsonParameters = jsonParameters;
        }

        @Override
        public String formatIllustration(Illustration illustration, int weight, FormatSource formatSource) {
            StringBuilder buf = new StringBuilder();
            JSONWriter jsonWriter = new JSONWriter(buf);
            try {
                jsonWriter.object();
                IllustrationJson.properties(jsonWriter, illustration, this.jsonParameters);
                jsonWriter.endObject();
            }
            catch (IOException ioe) {
                throw new ShouldNotOccurException(ioe);
            }
            return buf.toString();
        }
    }
}

