/*
 * Decompiled with CFR 0.152.
 */
package net.fichotheque.tools.extraction.corpus;

import java.util.Locale;
import net.fichotheque.corpus.FicheMeta;
import net.fichotheque.extraction.def.FicheFilter;
import net.fichotheque.extraction.def.GroupClause;
import net.fichotheque.extraction.run.FicheExtractInfo;
import net.fichotheque.extraction.run.FicheGroup;
import net.fichotheque.extraction.run.FieldsGroupParams;
import net.fichotheque.junction.Junction;
import net.fichotheque.tools.extraction.corpus.GroupBuilder;
import net.fichotheque.tools.extraction.corpus.GroupEngine;
import net.fichotheque.tools.extraction.corpus.GroupEngineProvider;
import net.mapeadores.util.text.alphabet.Alphabet;
import net.mapeadores.util.text.alphabet.AlphabeticEntry;
import net.mapeadores.util.text.collation.group.CollationGroupBuilder;
import net.mapeadores.util.text.collation.group.ObjectWrapper;

class TitleGroupEngine
extends GroupEngine {
    private final GroupClause groupClause;
    private final GroupEngineProvider subGroupEngineProvider;
    private boolean alphabetMode = false;
    private final CollationGroupBuilder collationGroupBuilder;

    TitleGroupEngine(GroupClause groupClause, GroupEngineProvider subGroupEngineProvider) {
        this.groupClause = groupClause;
        this.subGroupEngineProvider = subGroupEngineProvider;
        FieldsGroupParams groupParams = (FieldsGroupParams)groupClause.getGroupParams();
        if (groupParams != null) {
            this.alphabetMode = groupParams.getMode() == 1;
        }
        this.collationGroupBuilder = new CollationGroupBuilder(Locale.getDefault());
    }

    @Override
    public void add(FicheMeta ficheMeta, FicheFilter ficheFilter, Junction junction) {
        String titre = ficheMeta.getTitle();
        AlphabeticEntry groupClauseObject = null;
        if (this.alphabetMode) {
            AlphabeticEntry alphabeticEntry = Alphabet.newInstance(titre, ficheMeta.getLang());
            titre = alphabeticEntry.getEntryString();
            groupClauseObject = alphabeticEntry;
        }
        FicheExtractInfo info = GroupBuilder.toFicheExtractInfo(ficheMeta, ficheFilter, junction, groupClauseObject);
        ObjectWrapper objectWrapper = ObjectWrapper.newCleanedInstance(titre, info);
        this.collationGroupBuilder.addObjectWrapper(objectWrapper);
    }

    @Override
    public FicheGroup[] toFicheGroupArray() {
        return TitleGroupEngine.toGroupArray(this.collationGroupBuilder, this.groupClause, this.subGroupEngineProvider);
    }
}

