/*
 * Decompiled with CFR 0.152.
 */
package net.fichotheque.tools.extraction.builders;

import java.util.ArrayList;
import java.util.List;
import net.fichotheque.extraction.def.CorpusExtractDef;
import net.fichotheque.extraction.def.ExtractionDef;
import net.fichotheque.extraction.def.TagNameInfo;
import net.fichotheque.extraction.def.ThesaurusExtractDef;

public class ExtractionDefBuilder {
    private CorpusExtractDef dynamicCorpusExtractDef;
    private ThesaurusExtractDef dynamicThesaurusExtractDef;
    private TagNameInfo tagNameInfo = TagNameInfo.DEFAULT;
    private TagNameInfo staticTagNameInfo = TagNameInfo.DEFAULT;
    private final List<CorpusExtractDef> staticCorpusExtractDefList = new ArrayList<CorpusExtractDef>();
    private final List<ThesaurusExtractDef> staticThesaurusExtractDefList = new ArrayList<ThesaurusExtractDef>();

    public ExtractionDefBuilder setDynamicCorpusExtractDef(CorpusExtractDef corpusExtractDef) {
        this.dynamicCorpusExtractDef = corpusExtractDef;
        return this;
    }

    public ExtractionDefBuilder setDynamicThesaurusExtractDef(ThesaurusExtractDef thesaurusExtractDef) {
        this.dynamicThesaurusExtractDef = thesaurusExtractDef;
        return this;
    }

    public ExtractionDefBuilder setTagNameInfo(TagNameInfo tagNameInfo) {
        this.tagNameInfo = tagNameInfo;
        return this;
    }

    public ExtractionDefBuilder setStaticTagNameInfo(TagNameInfo staticTagNameInfo) {
        this.staticTagNameInfo = staticTagNameInfo;
        return this;
    }

    public ExtractionDefBuilder addStatic(CorpusExtractDef corpusExtractDef) {
        this.staticCorpusExtractDefList.add(corpusExtractDef);
        return this;
    }

    public ExtractionDefBuilder addStatic(ThesaurusExtractDef thesaurusExtractDef) {
        this.staticThesaurusExtractDefList.add(thesaurusExtractDef);
        return this;
    }

    public ExtractionDef toExtractionDef() {
        return new InternalExtractionDef(this.dynamicCorpusExtractDef, this.dynamicThesaurusExtractDef, this.tagNameInfo, this.staticCorpusExtractDefList, this.staticThesaurusExtractDefList, this.staticTagNameInfo);
    }

    public static ExtractionDefBuilder init() {
        return new ExtractionDefBuilder();
    }

    private static class InternalExtractionDef
    implements ExtractionDef {
        private final CorpusExtractDef dynamicCorpusExtractDef;
        private final ThesaurusExtractDef dynamicThesaurusExtractDef;
        private final TagNameInfo tagNameInfo;
        private final TagNameInfo staticTagNameInfo;
        private final List<CorpusExtractDef> staticCorpusExtractDefList;
        private final List<ThesaurusExtractDef> staticThesaurusExtractDefList;

        private InternalExtractionDef(CorpusExtractDef dynamicCorpusExtractDef, ThesaurusExtractDef dynamicThesaurusExtractDef, TagNameInfo tagNameInfo, List<CorpusExtractDef> staticCorpusExtractDefList, List<ThesaurusExtractDef> staticThesaurusExtractDefList, TagNameInfo staticTagNameInfo) {
            this.dynamicCorpusExtractDef = dynamicCorpusExtractDef;
            this.dynamicThesaurusExtractDef = dynamicThesaurusExtractDef;
            this.tagNameInfo = tagNameInfo;
            this.staticCorpusExtractDefList = staticCorpusExtractDefList;
            this.staticThesaurusExtractDefList = staticThesaurusExtractDefList;
            this.staticTagNameInfo = staticTagNameInfo;
        }

        @Override
        public CorpusExtractDef getDynamicCorpusExtractDef() {
            return this.dynamicCorpusExtractDef;
        }

        @Override
        public ThesaurusExtractDef getDynamicThesaurusExtractDef() {
            return this.dynamicThesaurusExtractDef;
        }

        @Override
        public TagNameInfo getTagNameInfo() {
            return this.tagNameInfo;
        }

        @Override
        public List<CorpusExtractDef> getStaticCorpusExtractDefList() {
            return this.staticCorpusExtractDefList;
        }

        @Override
        public List<ThesaurusExtractDef> getStaticThesaurusExtractDefList() {
            return this.staticThesaurusExtractDefList;
        }

        @Override
        public TagNameInfo getStaticTagNameInfo() {
            return this.staticTagNameInfo;
        }
    }
}

