/*
 * Decompiled with CFR 0.152.
 */
package net.fichotheque.tools.extraction.builders;

import java.util.Collections;
import java.util.List;
import net.fichotheque.extraction.def.AddendaExtractDef;
import net.fichotheque.extraction.def.DocumentFilter;
import net.fichotheque.extraction.def.TagNameInfo;
import net.fichotheque.selection.DocumentCondition;
import net.fichotheque.utils.SelectionUtils;

public class AddendaExtractDefBuilder {
    private DocumentFilter documentFilter;
    private String name = null;
    private TagNameInfo tagNameInfo = TagNameInfo.DEFAULT;
    private List<DocumentCondition.Entry> entryList = SelectionUtils.EMPTY_DOCUMENTCONDITIONENTRYLIST;

    public AddendaExtractDefBuilder(DocumentFilter documentFilter) {
        if (documentFilter == null) {
            throw new IllegalArgumentException("documentFilter is null");
        }
        this.documentFilter = documentFilter;
    }

    public AddendaExtractDefBuilder setDocumentFilter(DocumentFilter DocumentFilter2) {
        if (this.documentFilter == null) {
            throw new IllegalArgumentException("documentFilter is null");
        }
        this.documentFilter = DocumentFilter2;
        return this;
    }

    public AddendaExtractDefBuilder setName(String name) {
        if (name != null && name.length() == 0) {
            name = null;
        }
        this.name = name;
        return this;
    }

    public AddendaExtractDefBuilder setTagNameInfo(TagNameInfo tagNameInfo) {
        this.tagNameInfo = tagNameInfo;
        return this;
    }

    public AddendaExtractDefBuilder setEntryList(List<DocumentCondition.Entry> list) {
        this.entryList = list;
        return this;
    }

    public AddendaExtractDefBuilder setEntryList(DocumentCondition.Entry entry) {
        this.entryList = Collections.singletonList(entry);
        return this;
    }

    public AddendaExtractDef toAddendaExtractDef() {
        return new InternalAddendaExtractDef(this.documentFilter, this.name, this.tagNameInfo, this.entryList);
    }

    public static AddendaExtractDefBuilder init(DocumentFilter documentFilter) {
        return new AddendaExtractDefBuilder(documentFilter);
    }

    private static class InternalAddendaExtractDef
    implements AddendaExtractDef {
        private final DocumentFilter documentFilter;
        private final String name;
        private final TagNameInfo tagNameInfo;
        private final List<DocumentCondition.Entry> entryList;

        private InternalAddendaExtractDef(DocumentFilter documentFilter, String name, TagNameInfo tagNameInfo, List<DocumentCondition.Entry> entryList) {
            this.tagNameInfo = tagNameInfo;
            this.name = name;
            this.documentFilter = documentFilter;
            this.entryList = entryList;
        }

        @Override
        public TagNameInfo getTagNameInfo() {
            return this.tagNameInfo;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public DocumentFilter getDocumentFilter() {
            return this.documentFilter;
        }

        @Override
        public List<DocumentCondition.Entry> getConditionEntryList() {
            return this.entryList;
        }
    }
}

