/*
 * Decompiled with CFR 0.152.
 */
package net.fichotheque.tools.exportation.table.inclusionresolvers;

import java.text.ParseException;
import java.util.List;
import net.fichotheque.Subset;
import net.fichotheque.SubsetKey;
import net.fichotheque.corpus.Corpus;
import net.fichotheque.corpus.fiche.FicheItem;
import net.fichotheque.corpus.fiche.FicheItems;
import net.fichotheque.corpus.fiche.LanguageItem;
import net.fichotheque.corpus.metadata.CorpusField;
import net.fichotheque.corpus.metadata.FieldKey;
import net.fichotheque.exportation.table.Col;
import net.fichotheque.exportation.table.ColDef;
import net.fichotheque.exportation.table.TableExportContext;
import net.fichotheque.exportation.table.TableInclusionDef;
import net.fichotheque.exportation.table.TableInclusionResolver;
import net.fichotheque.format.FormatSource;
import net.fichotheque.format.formatters.SourceFormatter;
import net.fichotheque.pointeurs.FichePointeur;
import net.fichotheque.pointeurs.SubsetItemPointeur;
import net.fichotheque.thesaurus.Thesaurus;
import net.fichotheque.utils.FichothequeUtils;
import net.fichotheque.utils.TableExportUtils;
import net.mapeadores.util.exceptions.ShouldNotOccurException;
import net.mapeadores.util.instruction.Argument;
import net.mapeadores.util.instruction.Instruction;
import net.mapeadores.util.instruction.InstructionParser;
import net.mapeadores.util.localisation.Lang;
import net.mapeadores.util.logging.LineMessageHandler;
import net.mapeadores.util.logging.LogUtils;
import net.mapeadores.util.text.Labels;
import net.mapeadores.util.text.alphabet.Alphabet;
import net.mapeadores.util.text.alphabet.AlphabeticEntry;

public class AlphabeticInclusionResolver
implements TableInclusionResolver {
    public static final String NAMESPACE = "alphabetic";
    public static final String MERGE_NUMBERS_OPTION = "merge_numbers";
    public static final String CORPUS_OPTION = "corpus";
    public static final String LANGFIELD_OPTION = "langfield";
    public static final String SORTLANG_OPTION = "sortlang";
    private static final ColDef ENTRY = new InternalColDef("alphabetic_entry", "");
    private static final ColDef ARTICLE = new InternalColDef("alphabetic_article", "");
    private static final ColDef WITH_SPACE = new InternalColDef("alphabetic_withspace", "integer");
    private static final ColDef INITIAL = new InternalColDef("alphabetic_initial", "");
    private static final ColDef SORT = new InternalColDef("alphabetic_sort", "");

    @Override
    public boolean test(TableInclusionDef tableInclusionDef, Subset subset, TableExportContext tableExportContext, int lineNumber, LineMessageHandler lineMessageHandler) {
        Corpus corpus;
        String nameSpace = tableInclusionDef.getNameSpace();
        if (!nameSpace.equals(NAMESPACE)) {
            return false;
        }
        int instructionLineNumber = lineNumber + 1;
        Instruction instruction = this.getConfigInstruction(tableInclusionDef, instructionLineNumber, lineMessageHandler);
        if (subset instanceof Thesaurus) {
            corpus = this.getSatelliteCorpus(instruction, subset, instructionLineNumber, lineMessageHandler);
            if (corpus == null) {
                return false;
            }
        } else if (subset instanceof Corpus) {
            corpus = (Corpus)subset;
        } else {
            return false;
        }
        this.getLangField(instruction, corpus, instructionLineNumber, lineMessageHandler);
        this.getSortLang(instruction, instructionLineNumber, lineMessageHandler);
        return true;
    }

    @Override
    public Col[] resolve(TableInclusionDef tableInclusionDef, Subset subset, TableExportContext tableExportContext) {
        Corpus corpus;
        LineMessageHandler lineMessageHandler = LogUtils.NULL_LINEMESSAGEHANDLER;
        String nameSpace = tableInclusionDef.getNameSpace();
        if (!nameSpace.equals(NAMESPACE)) {
            return TableExportUtils.EMPTY_COLARRAY;
        }
        Instruction instruction = this.getConfigInstruction(tableInclusionDef, 0, lineMessageHandler);
        SubsetKey satelliteSubsetKey = null;
        if (subset instanceof Thesaurus) {
            corpus = this.getSatelliteCorpus(instruction, subset, 0, lineMessageHandler);
            if (corpus == null) {
                return AlphabeticInclusionResolver.getErrorColArray();
            }
            satelliteSubsetKey = corpus.getSubsetKey();
        } else if (subset instanceof Corpus) {
            corpus = (Corpus)subset;
        } else {
            return AlphabeticInclusionResolver.getErrorColArray();
        }
        CorpusField corpusField = this.getLangField(instruction, corpus, 0, lineMessageHandler);
        if (corpusField == null) {
            return AlphabeticInclusionResolver.getErrorColArray();
        }
        boolean mergeNumbersOption = false;
        if (instruction != null) {
            for (Argument argument : instruction) {
                if (!argument.getKey().equals(MERGE_NUMBERS_OPTION)) continue;
                mergeNumbersOption = true;
                break;
            }
        }
        Lang sortLang = this.getSortLang(instruction, 0, lineMessageHandler);
        return AlphabeticInclusionResolver.getSuccessColArray(satelliteSubsetKey, corpusField.getFieldKey(), sortLang, mergeNumbersOption);
    }

    private Instruction getConfigInstruction(TableInclusionDef tableInclusionDef, int lineNumber, LineMessageHandler lineMessageHandler) {
        List<String> configLineList = tableInclusionDef.getConfigLineList();
        if (configLineList.isEmpty()) {
            return null;
        }
        Instruction instruction = InstructionParser.parse(configLineList.get(0), LogUtils.encapsulate(lineMessageHandler, "severe.format.syntax", lineNumber));
        return instruction;
    }

    private Corpus getSatelliteCorpus(Instruction instruction, Subset subset, int lineNumber, LineMessageHandler lineMessageHandler) {
        if (instruction == null) {
            lineMessageHandler.addMessage("severe.format.syntax", lineNumber, "_ error.empty.tableexport.configline", lineNumber);
            return null;
        }
        boolean corpusHere = false;
        SubsetKey parentageSubsetKey = null;
        for (Argument argument : instruction) {
            if (!argument.getKey().equals(CORPUS_OPTION)) continue;
            String value = argument.getValue();
            if (value != null) {
                corpusHere = true;
                try {
                    parentageSubsetKey = SubsetKey.parse((short)1, value);
                }
                catch (ParseException pe) {
                    lineMessageHandler.addMessage("severe.format.syntax", lineNumber, "_ error.wrong.argumentvalue", CORPUS_OPTION, value);
                }
                break;
            }
            lineMessageHandler.addMessage("severe.format.syntax", lineNumber, "_ error.empty.argumentvalue", CORPUS_OPTION);
            break;
        }
        if (parentageSubsetKey == null) {
            if (!corpusHere) {
                lineMessageHandler.addMessage("severe.format.syntax", lineNumber, "_ error.empty.argumentkey", CORPUS_OPTION);
            }
            return null;
        }
        Corpus other = (Corpus)subset.getFichotheque().getSubset(parentageSubsetKey);
        if (other == null) {
            lineMessageHandler.addMessage("warning.format.fichotheque", lineNumber, "_ error.unknown.subset", parentageSubsetKey);
            return null;
        }
        if (!FichothequeUtils.ownToSameParentage(subset, other)) {
            lineMessageHandler.addMessage("severe.format.syntax", lineNumber, "_ error.unsupported.parentage", parentageSubsetKey, subset.getSubsetKey());
            return null;
        }
        return other;
    }

    private CorpusField getLangField(Instruction instruction, Corpus corpus, int lineNumber, LineMessageHandler lineMessageHandler) {
        if (instruction == null) {
            return corpus.getCorpusMetadata().getCorpusField(FieldKey.LANG);
        }
        boolean langFieldHere = false;
        CorpusField corpusField = null;
        for (Argument argument : instruction) {
            if (!argument.getKey().equals(LANGFIELD_OPTION)) continue;
            String value = argument.getValue();
            if (value != null) {
                langFieldHere = true;
                try {
                    FieldKey fieldKey = FieldKey.parse(value);
                    corpusField = corpus.getCorpusMetadata().getCorpusField(fieldKey);
                    if (corpusField != null) break;
                    lineMessageHandler.addMessage("warning.format.fichotheque", lineNumber, "_ error.unknown.fieldkey", value);
                }
                catch (ParseException pe) {
                    lineMessageHandler.addMessage("severe.format.syntax", lineNumber, "_ error.wrong.argumentvalue", LANGFIELD_OPTION, value);
                }
                break;
            }
            lineMessageHandler.addMessage("severe.format.syntax", lineNumber, "_ error.empty.argumentvalue", LANGFIELD_OPTION);
            break;
        }
        if (!langFieldHere) {
            corpusField = corpus.getCorpusMetadata().getCorpusField(FieldKey.LANG);
        }
        return corpusField;
    }

    private Lang getSortLang(Instruction instruction, int lineNumber, LineMessageHandler lineMessageHandler) {
        if (instruction == null) {
            return null;
        }
        for (Argument argument : instruction) {
            if (!argument.getKey().equals(SORTLANG_OPTION)) continue;
            String value = argument.getValue();
            if (value != null) {
                try {
                    Lang lang = Lang.parse(value);
                    return lang;
                }
                catch (ParseException pe) {
                    lineMessageHandler.addMessage("severe.format.syntax", lineNumber, "_ error.wrong.argumentvalue", SORTLANG_OPTION, value);
                    break;
                }
            }
            lineMessageHandler.addMessage("severe.format.syntax", lineNumber, "_ error.empty.argumentvalue", SORTLANG_OPTION);
            break;
        }
        return null;
    }

    private static boolean isNumber(String initialChar) {
        try {
            Integer.parseInt(initialChar);
            return true;
        }
        catch (NumberFormatException nfe) {
            return false;
        }
    }

    private static Col[] getErrorColArray() {
        ErrorFormatter errorFormatter = new ErrorFormatter();
        Col[] colArray = new Col[]{TableExportUtils.toCol(ENTRY, errorFormatter), TableExportUtils.toCol(ARTICLE, errorFormatter), TableExportUtils.toCol(WITH_SPACE, errorFormatter), TableExportUtils.toCol(INITIAL, errorFormatter), TableExportUtils.toCol(SORT, errorFormatter)};
        return colArray;
    }

    private static Col[] getSuccessColArray(SubsetKey satelliteSubsetKey, FieldKey langFieldKey, Lang sortLang, boolean mergeNumbersOption) {
        Col[] colArray = new Col[]{TableExportUtils.toCol(ENTRY, new AlphabeticFormatter(0, satelliteSubsetKey, langFieldKey, sortLang, mergeNumbersOption)), TableExportUtils.toCol(ARTICLE, new AlphabeticFormatter(1, satelliteSubsetKey, langFieldKey, sortLang, mergeNumbersOption)), TableExportUtils.toCol(WITH_SPACE, new AlphabeticFormatter(2, satelliteSubsetKey, langFieldKey, sortLang, mergeNumbersOption)), TableExportUtils.toCol(INITIAL, new AlphabeticFormatter(3, satelliteSubsetKey, langFieldKey, sortLang, mergeNumbersOption)), TableExportUtils.toCol(SORT, new AlphabeticFormatter(4, satelliteSubsetKey, langFieldKey, sortLang, mergeNumbersOption))};
        return colArray;
    }

    private static Lang getLang(FichePointeur fichePointeur, FieldKey fieldKey) {
        Object object = fichePointeur.getValue(fieldKey);
        if (object == null) {
            return null;
        }
        if (object instanceof LanguageItem) {
            return ((LanguageItem)object).getLang();
        }
        if (object instanceof FicheItems) {
            FicheItems ficheItems = (FicheItems)object;
            int count = ficheItems.size();
            for (int i = 0; i < count; ++i) {
                FicheItem ficheItem = (FicheItem)ficheItems.get(i);
                if (!(ficheItem instanceof LanguageItem)) continue;
                return ((LanguageItem)ficheItem).getLang();
            }
            return null;
        }
        return null;
    }

    private static class ErrorFormatter
    implements SourceFormatter {
        private ErrorFormatter() {
        }

        @Override
        public String formatSource(FormatSource formatSource) {
            return "#ERROR - check test";
        }
    }

    private static class AlphabeticFormatter
    implements SourceFormatter {
        private final int index;
        private final SubsetKey satelliteSubsetKey;
        private final FieldKey langFieldKey;
        private final Lang sortLang;
        private final boolean mergeNumbersOption;

        private AlphabeticFormatter(int index, SubsetKey satelliteSubsetKey, FieldKey langFieldKey, Lang sortLang, boolean mergeNumbersOption) {
            this.index = index;
            this.satelliteSubsetKey = satelliteSubsetKey;
            this.langFieldKey = langFieldKey;
            this.sortLang = sortLang;
            this.mergeNumbersOption = mergeNumbersOption;
        }

        @Override
        public String formatSource(FormatSource formatSource) {
            AlphabeticEntry entry;
            SubsetItemPointeur pointeur = formatSource.getSubsetItemPointeur();
            if (this.satelliteSubsetKey != null) {
                pointeur = pointeur.getParentagePointeur(this.satelliteSubsetKey);
            }
            if (pointeur == null || !(pointeur instanceof FichePointeur)) {
                return "#ERROR : not fiche Pointeur";
            }
            Object object = pointeur.getCurrentObject(AlphabeticInclusionResolver.NAMESPACE);
            if (object == null) {
                FichePointeur fichePointeur = (FichePointeur)pointeur;
                String title = (String)fichePointeur.getValue(FieldKey.TITLE);
                if (title == null) {
                    pointeur.putCurrentObject(AlphabeticInclusionResolver.NAMESPACE, Boolean.FALSE);
                    return null;
                }
                Lang lang = AlphabeticInclusionResolver.getLang(fichePointeur, this.langFieldKey);
                if (lang == null) {
                    lang = formatSource.getDefaultLang();
                }
                entry = this.sortLang == null ? Alphabet.newInstance(title, lang) : Alphabet.newInstance(title, lang, this.sortLang);
                pointeur.putCurrentObject(AlphabeticInclusionResolver.NAMESPACE, entry);
            } else {
                if (object.equals(Boolean.FALSE)) {
                    return "";
                }
                if (!(object instanceof AlphabeticEntry)) {
                    return "#ERROR";
                }
                entry = (AlphabeticEntry)object;
            }
            switch (this.index) {
                case 0: {
                    return entry.getEntryString();
                }
                case 1: {
                    if (entry.isWithArticle()) {
                        return entry.getArticleString();
                    }
                    return null;
                }
                case 2: {
                    if (entry.isWithSeparationSpace()) {
                        return "1";
                    }
                    return "0";
                }
                case 3: {
                    String initialChar = entry.getInitialChar();
                    if (this.mergeNumbersOption && AlphabeticInclusionResolver.isNumber(initialChar)) {
                        return "0";
                    }
                    return initialChar;
                }
                case 4: {
                    return entry.getAlphabeticSort();
                }
            }
            throw new ShouldNotOccurException();
        }
    }

    private static class InternalColDef
    implements ColDef {
        private final String name;
        private final String castType;

        private InternalColDef(String name, String castType) {
            this.name = name;
            this.castType = castType;
        }

        @Override
        public String getColName() {
            return this.name;
        }

        @Override
        public Labels getCustomLabels() {
            return null;
        }

        @Override
        public Object getParameterValue(String paramKey) {
            if (paramKey.equals("cast")) {
                return this.castType;
            }
            return null;
        }

        @Override
        public String getCastType() {
            return this.castType;
        }
    }
}

