/*
 * Decompiled with CFR 0.152.
 */
package net.fichotheque.tools.exportation.table;

import java.util.ArrayList;
import java.util.List;
import net.fichotheque.exportation.table.TableExportContentDescription;
import net.fichotheque.exportation.table.TableExportDef;
import net.fichotheque.exportation.table.TableExportDescription;
import net.fichotheque.utils.TableExportUtils;

public class TableExportDescriptionBuilder {
    private final TableExportDef tableExportDef;
    private final List<TableExportContentDescription> contentDescriptionList = new ArrayList<TableExportContentDescription>();
    private String state = "disabled";

    public TableExportDescriptionBuilder(TableExportDef tableExportDef) {
        this.tableExportDef = tableExportDef;
    }

    public TableExportDescriptionBuilder setState(String state) {
        this.state = state;
        return this;
    }

    public TableExportDescriptionBuilder addTableExportContentDescription(TableExportContentDescription tableExportContentDescription) {
        this.contentDescriptionList.add(tableExportContentDescription);
        return this;
    }

    public TableExportDescription toTableExportDescription() {
        List<TableExportContentDescription> finalList = TableExportUtils.wrap(this.contentDescriptionList.toArray(new TableExportContentDescription[this.contentDescriptionList.size()]));
        return new InternalTableExportDescription(this.tableExportDef, this.state, finalList);
    }

    public static TableExportDescriptionBuilder init(TableExportDef tableExportDef) {
        return new TableExportDescriptionBuilder(tableExportDef);
    }

    private static class InternalTableExportDescription
    implements TableExportDescription {
        private final TableExportDef tableExportDef;
        private final String state;
        private final List<TableExportContentDescription> list;

        private InternalTableExportDescription(TableExportDef tableExportDef, String state, List<TableExportContentDescription> list) {
            this.tableExportDef = tableExportDef;
            this.state = state;
            this.list = list;
        }

        @Override
        public TableExportDef getTableExportDef() {
            return this.tableExportDef;
        }

        @Override
        public String getState() {
            return this.state;
        }

        @Override
        public List<TableExportContentDescription> getTableExportContentDescriptionList() {
            return this.list;
        }

        @Override
        public boolean isEditable() {
            return true;
        }
    }
}

