/*
 * Decompiled with CFR 0.152.
 */
package net.fichotheque.tools.exportation.table;

import java.io.IOException;
import java.util.Collection;
import java.util.List;
import net.fichotheque.Subset;
import net.fichotheque.SubsetItem;
import net.fichotheque.exportation.table.ColDef;
import net.fichotheque.exportation.table.SubsetTable;
import net.fichotheque.exportation.table.SumCellConverter;
import net.fichotheque.exportation.table.SumResult;
import net.fichotheque.tools.exportation.table.FormulaEngine;
import net.fichotheque.tools.exportation.table.NamedRangeHandler;
import net.fichotheque.tools.exportation.table.TableExportEngine;
import net.fichotheque.tools.exportation.table.TableExportOdsParameters;
import net.fichotheque.utils.TableDefUtils;
import net.mapeadores.opendocument.io.odtable.OdsXMLPart;
import net.mapeadores.opendocument.io.odtable.StyleManager;
import net.mapeadores.util.exceptions.NestedIOException;
import net.mapeadores.util.localisation.Lang;
import net.mapeadores.util.money.Amount;
import net.mapeadores.util.primitives.Decimal;
import net.mapeadores.util.primitives.FuzzyDate;
import net.mapeadores.util.table.TableWriter;
import net.mapeadores.util.xml.XMLWriter;

public class SubsetTableOdsXMLPart
extends OdsXMLPart {
    private static final String COLUMNHEADER_STYLE = "ColumnHeader";
    private static final String TITLE_STYLE = "Title";
    private final TableExportOdsParameters tableExportOdsParameters;

    public SubsetTableOdsXMLPart(XMLWriter xmlWriter, StyleManager styleManager, TableExportOdsParameters tableExportOdsParameters) {
        super(xmlWriter, styleManager);
        this.tableExportOdsParameters = tableExportOdsParameters;
    }

    public int addSubsetTable(String tableName, SubsetTable subsetTable, Collection<SubsetItem> subsetItems, int startRowNumber, NamedRangeHandler namedRangeHandler) throws IOException {
        SumResult sumResult;
        Subset subset = subsetTable.getSubset();
        int rowCount = 0;
        switch (this.tableExportOdsParameters.getHeaderType()) {
            case "columntitle": {
                this.printHeaderTitle(subsetTable.getColDefList(), this.tableExportOdsParameters.getWorkingLang(), subset);
                ++startRowNumber;
                ++rowCount;
                break;
            }
            case "columnkey": {
                this.printHeaderKey(subsetTable.getColDefList());
                ++startRowNumber;
                ++rowCount;
            }
        }
        InternalTableWriter tableWriter = new InternalTableWriter(tableName, startRowNumber, new FormulaEngine(subsetTable));
        try {
            SumCellConverter sumCellConverter = this.tableExportOdsParameters.getSumCellConverter();
            TableExportEngine.exportSubset(subsetTable, tableWriter, this.tableExportOdsParameters.getSumCellConverter(), subsetItems);
            sumResult = sumCellConverter.getSumResult(subsetTable);
            rowCount += tableWriter.rowCount;
            namedRangeHandler.setCurrentSubset(subset.getSubsetKey());
        }
        catch (NestedIOException nioe) {
            throw nioe.getIOException();
        }
        return rowCount += TableExportEngine.writeSumRows(tableWriter, sumResult, tableWriter.rowNumber + 1, namedRangeHandler);
    }

    public int addTitleRows(String title) throws IOException {
        this.rowStart().stringCell(title, TITLE_STYLE).rowEnd().rowStart().rowEnd();
        return 2;
    }

    private void printHeaderTitle(List<ColDef> colDefList, Lang workingLang, Subset subset) throws IOException {
        this.rowStart();
        for (ColDef colDef : colDefList) {
            this.stringCell(TableDefUtils.getColTitle(colDef, workingLang, this.tableExportOdsParameters.getTableExportContext().getSourceLabelProvider(), subset), COLUMNHEADER_STYLE, 1);
        }
        this.rowEnd();
    }

    private void printHeaderKey(List<ColDef> colDefList) throws IOException {
        this.rowStart();
        for (ColDef colDef : colDefList) {
            this.stringCell(colDef.getColName(), COLUMNHEADER_STYLE, 1);
        }
        this.rowEnd();
    }

    private class InternalTableWriter
    implements TableWriter {
        private final String tableName;
        private final FormulaEngine formulaEngine;
        private int rowNumber;
        private int rowCount;
        private int columnNumber;

        private InternalTableWriter(String tableName, int startRowNumber, FormulaEngine formulaEngine) {
            this.tableName = tableName;
            this.rowNumber = startRowNumber - 1;
            this.rowCount = 0;
            this.formulaEngine = formulaEngine;
        }

        @Override
        public int startRow() {
            ++this.rowNumber;
            ++this.rowCount;
            this.columnNumber = 0;
            try {
                SubsetTableOdsXMLPart.this.rowStart();
            }
            catch (IOException ioe) {
                throw new NestedIOException(ioe);
            }
            return this.rowNumber;
        }

        @Override
        public int addIntegerCell(Long lg) {
            ++this.columnNumber;
            try {
                if (lg == null) {
                    SubsetTableOdsXMLPart.this.emptyCell();
                } else {
                    SubsetTableOdsXMLPart.this.numberCell(lg.toString());
                }
            }
            catch (IOException ioe) {
                throw new NestedIOException(ioe);
            }
            return this.columnNumber;
        }

        @Override
        public int addDecimalCell(Decimal decimal) {
            ++this.columnNumber;
            try {
                if (decimal == null) {
                    SubsetTableOdsXMLPart.this.emptyCell();
                } else {
                    SubsetTableOdsXMLPart.this.numberCell(decimal.toString());
                }
            }
            catch (IOException ioe) {
                throw new NestedIOException(ioe);
            }
            return this.columnNumber;
        }

        @Override
        public int addDateCell(FuzzyDate date) {
            ++this.columnNumber;
            try {
                if (date == null) {
                    SubsetTableOdsXMLPart.this.emptyCell();
                } else {
                    String cellStyleName = SubsetTableOdsXMLPart.this.getCellStyleName(this.tableName, this.columnNumber, (short)1, null);
                    SubsetTableOdsXMLPart.this.dateCell(date, cellStyleName);
                }
            }
            catch (IOException ioe) {
                throw new NestedIOException(ioe);
            }
            return this.columnNumber;
        }

        @Override
        public int addStringCell(String s) {
            ++this.columnNumber;
            try {
                if (s == null) {
                    SubsetTableOdsXMLPart.this.emptyCell();
                } else if (this.formulaEngine.isFormulaColumn(this.columnNumber)) {
                    this.formulaEngine.writeFormulaCell(this.rowNumber, this.columnNumber, SubsetTableOdsXMLPart.this, s);
                } else {
                    SubsetTableOdsXMLPart.this.stringCell(s);
                }
            }
            catch (IOException ioe) {
                throw new NestedIOException(ioe);
            }
            return this.columnNumber;
        }

        @Override
        public int addMoneyCell(Amount amount) {
            ++this.columnNumber;
            try {
                if (amount == null) {
                    SubsetTableOdsXMLPart.this.emptyCell();
                } else {
                    String cellStyleName = SubsetTableOdsXMLPart.this.getCurrencyStyleName(this.tableName, this.columnNumber, null, amount.getCurrency());
                    SubsetTableOdsXMLPart.this.currencyCell(amount, cellStyleName);
                }
            }
            catch (IOException ioe) {
                throw new NestedIOException(ioe);
            }
            return this.columnNumber;
        }

        @Override
        public int addPercentageCell(Decimal decimal) {
            ++this.columnNumber;
            try {
                if (decimal == null) {
                    SubsetTableOdsXMLPart.this.emptyCell();
                } else {
                    SubsetTableOdsXMLPart.this.percentageCell(decimal.toString());
                }
            }
            catch (IOException ioe) {
                throw new NestedIOException(ioe);
            }
            return this.columnNumber;
        }

        @Override
        public int endRow() {
            try {
                SubsetTableOdsXMLPart.this.rowEnd();
            }
            catch (IOException ioe) {
                throw new NestedIOException(ioe);
            }
            return this.rowNumber;
        }
    }
}

