/*
 * Decompiled with CFR 0.152.
 */
package net.fichotheque.tools.exportation.balayage;

import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import net.fichotheque.exportation.balayage.BalayageOutput;
import net.fichotheque.exportation.balayage.BalayageUnit;
import net.fichotheque.selection.DocumentQuery;
import net.fichotheque.selection.FicheQuery;
import net.fichotheque.selection.IllustrationQuery;
import net.fichotheque.selection.MotcleQuery;
import net.fichotheque.tools.exportation.balayage.BalayageOutputBuilder;
import net.fichotheque.utils.BalayageUtils;
import net.fichotheque.utils.SelectionUtils;
import net.mapeadores.util.annotation.Nullable;
import net.mapeadores.util.text.StringUtils;

public class BalayageUnitBuilder {
    private final Set<String> modeSet = new LinkedHashSet<String>();
    private final Set<String> extensionSet = new LinkedHashSet<String>();
    private final List<BalayageOutputBuilder> outputBuilderList = new ArrayList<BalayageOutputBuilder>();
    private final String type;
    private String name = "";
    private String extractionPath = "";
    private boolean globalSelect = true;
    private FicheQuery ficheQuery = SelectionUtils.EMPTY_FICHEQUERY;
    private MotcleQuery motcleQuery = SelectionUtils.EMPTY_MOTCLEQUERY;
    private IllustrationQuery illustrationQuery = SelectionUtils.EMPTY_ILLUSTRATIONQUERY;
    private DocumentQuery documentQuery = SelectionUtils.EMPTY_DOCUMENTQUERY;

    public BalayageUnitBuilder(String type) {
        this.type = type;
    }

    public BalayageUnitBuilder setName(String name) {
        this.name = StringUtils.nullTrim(name);
        return this;
    }

    public BalayageUnitBuilder setGlobalSelect(boolean globalSelect) {
        this.globalSelect = globalSelect;
        return this;
    }

    public BalayageUnitBuilder setExtractionPath(String extractionPath) {
        this.extractionPath = StringUtils.nullTrim(extractionPath);
        return this;
    }

    public BalayageUnitBuilder addMode(String mode) {
        this.modeSet.add(mode);
        return this;
    }

    public BalayageUnitBuilder setFicheQuery(@Nullable FicheQuery ficheQuery) {
        this.ficheQuery = ficheQuery == null ? SelectionUtils.EMPTY_FICHEQUERY : ficheQuery;
        return this;
    }

    public BalayageUnitBuilder setMotcleQuery(@Nullable MotcleQuery motcleQuery) {
        this.motcleQuery = motcleQuery == null ? SelectionUtils.EMPTY_MOTCLEQUERY : motcleQuery;
        return this;
    }

    public BalayageUnitBuilder setIllustrationQuery(@Nullable IllustrationQuery illustrationQuery) {
        this.illustrationQuery = illustrationQuery == null ? SelectionUtils.EMPTY_ILLUSTRATIONQUERY : illustrationQuery;
        return this;
    }

    public BalayageUnitBuilder setDocumentQuery(@Nullable DocumentQuery documentQuery) {
        this.documentQuery = documentQuery == null ? SelectionUtils.EMPTY_DOCUMENTQUERY : documentQuery;
        return this;
    }

    public BalayageUnitBuilder addExtension(String s) {
        this.extensionSet.add(s);
        return this;
    }

    public BalayageOutputBuilder addOutputBuilder() {
        BalayageOutputBuilder iob = new BalayageOutputBuilder();
        this.outputBuilderList.add(iob);
        return iob;
    }

    public BalayageUnit toBalayageUnit() {
        List<String> modeList = StringUtils.toList(this.modeSet);
        List<String> extensionList = StringUtils.toList(this.extensionSet);
        InternalBalayageUnit balayageUnit = new InternalBalayageUnit(this.type, this.name, this.extractionPath, this.globalSelect, this.ficheQuery, this.motcleQuery, this.illustrationQuery, this.documentQuery, modeList, extensionList);
        int outputSize = this.outputBuilderList.size();
        BalayageOutput[] outputArray = new BalayageOutput[outputSize];
        for (int i = 0; i < outputSize; ++i) {
            outputArray[i] = this.outputBuilderList.get(i).toBalayageOutput(balayageUnit);
        }
        balayageUnit.outputList = BalayageUtils.wrap(outputArray);
        return balayageUnit;
    }

    public static BalayageUnitBuilder init(String type) {
        return new BalayageUnitBuilder(type);
    }

    private static class InternalBalayageUnit
    implements BalayageUnit {
        private final String type;
        private final String name;
        private final String extractionPath;
        private boolean globalSelect = true;
        private final FicheQuery ficheQuery;
        private final MotcleQuery motcleQuery;
        private final IllustrationQuery illustrationQuery;
        private final DocumentQuery documentQuery;
        private final List<String> modeList;
        private final List<String> extensionList;
        private List<BalayageOutput> outputList;

        private InternalBalayageUnit(String type, String name, String extractionPath, boolean globalSelect, FicheQuery ficheQuery, MotcleQuery motcleQuery, IllustrationQuery illustrationQuery, DocumentQuery documentQuery, List<String> modeList, List<String> extensionList) {
            this.type = type;
            this.name = name;
            this.extractionPath = extractionPath;
            this.globalSelect = globalSelect;
            this.ficheQuery = ficheQuery;
            this.motcleQuery = motcleQuery;
            this.illustrationQuery = illustrationQuery;
            this.documentQuery = documentQuery;
            this.modeList = modeList;
            this.extensionList = extensionList;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public String getType() {
            return this.type;
        }

        @Override
        public boolean isGlobalSelect() {
            return this.globalSelect;
        }

        @Override
        public FicheQuery getFicheQuery() {
            return this.ficheQuery;
        }

        @Override
        public MotcleQuery getMotcleQuery() {
            return this.motcleQuery;
        }

        @Override
        public IllustrationQuery getIllustrationQuery() {
            return this.illustrationQuery;
        }

        @Override
        public DocumentQuery getDocumentQuery() {
            return this.documentQuery;
        }

        @Override
        public List<BalayageOutput> getOutputList() {
            return this.outputList;
        }

        @Override
        public List<String> getModeList() {
            return this.modeList;
        }

        @Override
        public List<String> getExtensionList() {
            return this.extensionList;
        }

        @Override
        public String getExtractionPath() {
            return this.extractionPath;
        }
    }
}

