/*
 * Decompiled with CFR 0.152.
 */
package net.fichotheque.tools.exportation.balayage;

import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import net.fichotheque.exportation.balayage.BalayageConstants;
import net.fichotheque.exportation.balayage.BalayageDef;
import net.fichotheque.exportation.balayage.BalayagePostscriptum;
import net.fichotheque.exportation.balayage.BalayageUnit;
import net.fichotheque.selection.SelectionOptions;
import net.fichotheque.tools.exportation.balayage.BalayagePostscriptumBuilder;
import net.fichotheque.tools.exportation.balayage.BalayageUnitBuilder;
import net.fichotheque.tools.selection.SelectionOptionsBuilder;
import net.fichotheque.utils.BalayageUtils;
import net.mapeadores.util.annotation.Nullable;
import net.mapeadores.util.attr.Attributes;
import net.mapeadores.util.localisation.Lang;
import net.mapeadores.util.localisation.Langs;
import net.mapeadores.util.localisation.LangsUtils;
import net.mapeadores.util.misc.DefBuilder;
import net.mapeadores.util.text.Labels;
import net.mapeadores.util.text.RelativePath;
import net.mapeadores.util.text.StringUtils;

public class BalayageDefBuilder
extends DefBuilder {
    private final String name;
    private final SelectionOptionsBuilder selectionOptionsBuilder = new SelectionOptionsBuilder();
    private final BalayagePostscriptumBuilder balayagePostscriptumBuilder = new BalayagePostscriptumBuilder();
    private final Set<Lang> langSet = new LinkedHashSet<Lang>();
    private final List<BalayageUnitBuilder> unitList = new ArrayList<BalayageUnitBuilder>();
    private String targetName = "";
    private RelativePath targetPath = RelativePath.EMPTY;
    private String defaultLangOption = "none";
    private boolean ignoreTransformation = false;

    public BalayageDefBuilder(String name) {
        this(name, null);
    }

    public BalayageDefBuilder(String name, @Nullable Attributes initAttributes) {
        super(initAttributes);
        if (!StringUtils.isTechnicalName(name, true)) {
            throw new IllegalArgumentException("Wrong syntax");
        }
        this.name = name;
    }

    public SelectionOptionsBuilder getSelectionOptionsBuilder() {
        return this.selectionOptionsBuilder;
    }

    public BalayagePostscriptumBuilder getBalayagePostscriptumBuilder() {
        return this.balayagePostscriptumBuilder;
    }

    public BalayageDefBuilder addLang(Lang lang) {
        this.langSet.add(lang);
        return this;
    }

    public BalayageDefBuilder setTargetName(String targetName) {
        this.targetName = StringUtils.nullTrim(targetName);
        return this;
    }

    public BalayageDefBuilder setTargetPath(RelativePath targetPath) {
        if (targetPath == null) {
            targetPath = RelativePath.EMPTY;
        }
        this.targetPath = targetPath;
        return this;
    }

    public BalayageDefBuilder setDefaultLangOption(String defaultLangOption) {
        if ((defaultLangOption = BalayageConstants.checkLangOption(defaultLangOption)).equals("")) {
            defaultLangOption = "none";
        }
        this.defaultLangOption = defaultLangOption;
        return this;
    }

    public BalayageDefBuilder setIgnoreTransformation(boolean ignoreTransformation) {
        this.ignoreTransformation = ignoreTransformation;
        return this;
    }

    public BalayageUnitBuilder addBalayageUnitBuilder(String type) {
        BalayageUnitBuilder unitBuilder = new BalayageUnitBuilder(type);
        this.unitList.add(unitBuilder);
        return unitBuilder;
    }

    public BalayageDef toBalayageDef() {
        List<BalayageUnit> balayageUnitList = BalayageUtils.EMPTY_UNITLIST;
        int unitLength = this.unitList.size();
        if (unitLength > 0) {
            BalayageUnit[] balayageUnitArray = new BalayageUnit[unitLength];
            for (int i = 0; i < unitLength; ++i) {
                balayageUnitArray[i] = this.unitList.get(i).toBalayageUnit();
            }
            balayageUnitList = BalayageUtils.wrap(balayageUnitArray);
        }
        Labels titleLabels = this.toLabels();
        Attributes attributes = this.toAttributes();
        Langs langs = LangsUtils.fromCollection(this.langSet);
        return new InternalBalayageDef(this.name, langs, this.targetName, this.targetPath, this.defaultLangOption, this.ignoreTransformation, this.selectionOptionsBuilder.toSelectionOptions(), this.balayagePostscriptumBuilder.toBalayagePostscriptum(), balayageUnitList, titleLabels, attributes);
    }

    public static BalayageDefBuilder init(String name, @Nullable Attributes initAttributes) {
        return new BalayageDefBuilder(name, initAttributes);
    }

    private static class InternalBalayageDef
    implements BalayageDef {
        private final String name;
        private final Langs langs;
        private final String targetName;
        private final RelativePath targetPath;
        private final String defaultLangOption;
        private final boolean ignoreTransformation;
        private final SelectionOptions selectionOptions;
        private final BalayagePostscriptum balayagePostscriptum;
        private final List<BalayageUnit> balayageUnitList;
        private final Labels titleLabels;
        private final Attributes attributes;

        private InternalBalayageDef(String name, Langs langs, String targetName, RelativePath targetPath, String defaultLangOption, boolean ignoreTransformation, SelectionOptions selectionOptions, BalayagePostscriptum balayagePostscriptum, List<BalayageUnit> balayageUnitList, Labels titleLabels, Attributes attributes) {
            this.name = name;
            this.langs = langs;
            this.targetName = targetName;
            this.targetPath = targetPath;
            this.defaultLangOption = defaultLangOption;
            this.ignoreTransformation = ignoreTransformation;
            this.selectionOptions = selectionOptions;
            this.balayagePostscriptum = balayagePostscriptum;
            this.balayageUnitList = balayageUnitList;
            this.titleLabels = titleLabels;
            this.attributes = attributes;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public Labels getTitleLabels() {
            return this.titleLabels;
        }

        @Override
        public Attributes getAttributes() {
            return this.attributes;
        }

        @Override
        public Langs getLangs() {
            return this.langs;
        }

        @Override
        public String getTargetName() {
            return this.targetName;
        }

        @Override
        public RelativePath getTargetPath() {
            return this.targetPath;
        }

        @Override
        public String getDefaultLangOption() {
            return this.defaultLangOption;
        }

        @Override
        public boolean ignoreTransformation() {
            return this.ignoreTransformation;
        }

        @Override
        public SelectionOptions getSelectionOptions() {
            return this.selectionOptions;
        }

        @Override
        public BalayagePostscriptum getPostscriptum() {
            return this.balayagePostscriptum;
        }

        @Override
        public List<BalayageUnit> getBalayageUnitList() {
            return this.balayageUnitList;
        }
    }
}

