/*
 * Decompiled with CFR 0.152.
 */
package net.fichotheque.tools.corpus;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.fichotheque.corpus.FicheChange;
import net.fichotheque.corpus.fiche.Fiche;
import net.fichotheque.corpus.fiche.FicheAPI;
import net.fichotheque.corpus.fiche.FicheBlocks;
import net.fichotheque.corpus.fiche.FicheItem;
import net.fichotheque.corpus.fiche.FicheItems;
import net.fichotheque.corpus.fiche.Info;
import net.fichotheque.corpus.fiche.ParaItem;
import net.fichotheque.corpus.fiche.Prop;
import net.fichotheque.corpus.fiche.Section;
import net.fichotheque.corpus.metadata.FieldKey;
import net.fichotheque.utils.CorpusMetadataUtils;
import net.mapeadores.util.localisation.Lang;
import net.mapeadores.util.text.CleanedString;

public class FicheChangeBuilder {
    private final Map<FieldKey, Boolean> fieldKeyMap = new HashMap<FieldKey, Boolean>();
    private final Fiche fiche;

    public FicheChangeBuilder() {
        this(new Fiche());
    }

    public FicheChangeBuilder(Fiche fiche) {
        this.fiche = fiche;
    }

    public FicheChangeBuilder setTitle(CleanedString cs) {
        if (cs == null) {
            this.fieldKeyMap.put(FieldKey.TITLE, Boolean.FALSE);
            this.fiche.setTitle("");
        } else {
            this.fieldKeyMap.put(FieldKey.TITLE, Boolean.TRUE);
            this.fiche.setTitle(cs.toString());
        }
        return this;
    }

    public FicheChangeBuilder setLang(Lang lang) {
        if (lang == null) {
            this.fieldKeyMap.put(FieldKey.LANG, Boolean.FALSE);
            this.fiche.setLang(null);
        } else {
            this.fieldKeyMap.put(FieldKey.LANG, Boolean.TRUE);
            this.fiche.setLang(lang);
        }
        return this;
    }

    public FicheChangeBuilder setSubtitle(ParaItem subtitlePara) {
        if (subtitlePara == null || subtitlePara.isEmpty()) {
            this.fieldKeyMap.put(FieldKey.SUBTITLE, Boolean.FALSE);
            this.fiche.setSubtitle(null);
        } else {
            this.fieldKeyMap.put(FieldKey.SUBTITLE, Boolean.TRUE);
            this.fiche.setSubtitle(subtitlePara);
        }
        return this;
    }

    public FicheChangeBuilder appendOwners(FicheItems ficheItems) {
        if (ficheItems.isEmpty()) {
            this.setRemoveable(FieldKey.OWNERS);
        } else {
            this.fieldKeyMap.put(FieldKey.OWNERS, Boolean.TRUE);
            this.fiche.appendOwners(ficheItems);
        }
        return this;
    }

    public FicheChangeBuilder setProp(FieldKey fieldKey, FicheItem ficheItem) {
        this.fiche.setProp(fieldKey, ficheItem);
        if (ficheItem == null) {
            this.fieldKeyMap.put(fieldKey, Boolean.FALSE);
        } else {
            this.fieldKeyMap.put(fieldKey, Boolean.TRUE);
        }
        return this;
    }

    public FicheChangeBuilder appendInfo(FieldKey fieldKey, FicheItems ficheItems) {
        if (ficheItems.isEmpty()) {
            this.setRemoveable(fieldKey);
        } else {
            this.fieldKeyMap.put(fieldKey, Boolean.TRUE);
            this.fiche.appendInfo(fieldKey, ficheItems);
        }
        return this;
    }

    public FicheChangeBuilder appendSection(FieldKey fieldKey, FicheBlocks ficheBlocks) {
        if (ficheBlocks.isEmpty()) {
            this.setRemoveable(fieldKey);
        } else {
            this.fieldKeyMap.put(fieldKey, Boolean.TRUE);
            this.fiche.appendSection(fieldKey, ficheBlocks);
        }
        return this;
    }

    public FicheChangeBuilder removeField(FieldKey fieldKey) {
        block0 : switch (fieldKey.getCategory()) {
            case 1: {
                this.setProp(fieldKey, null);
                break;
            }
            case 2: {
                this.setRemoveable(fieldKey);
                break;
            }
            case 3: {
                this.setRemoveable(fieldKey);
                break;
            }
            case 0: {
                switch (fieldKey.getKeyString()) {
                    case "title": {
                        this.setTitle(null);
                        break block0;
                    }
                    case "subtitle": {
                        this.setSubtitle(null);
                        break block0;
                    }
                    case "lang": {
                        this.setLang(null);
                        break block0;
                    }
                    case "owners": {
                        this.setRemoveable(fieldKey);
                    }
                }
            }
        }
        return this;
    }

    public FicheChangeBuilder appendFiche(FicheAPI fiche) {
        FicheItems owners;
        ParaItem subtitlePara;
        Lang lang;
        CleanedString title = CleanedString.newInstance(fiche.getTitle());
        if (title != null) {
            this.setTitle(title);
        }
        if ((lang = fiche.getLang()) != null) {
            this.setLang(lang);
        }
        if ((subtitlePara = fiche.getSubtitle()) != null) {
            this.setSubtitle(subtitlePara);
        }
        if ((owners = fiche.getOwners()) != null) {
            this.appendOwners(owners);
        }
        for (Prop prop : fiche.getPropList()) {
            this.setProp(prop.getFieldKey(), prop.getFicheItem());
        }
        for (Info info : fiche.getInfoList()) {
            this.appendInfo(info.getFieldKey(), info);
        }
        for (Section section : fiche.getSectionList()) {
            this.appendSection(section.getFieldKey(), section);
        }
        return this;
    }

    public FicheChangeBuilder merge(FicheChangeBuilder otherFicheChangeBuilder) {
        Fiche otherFiche = otherFicheChangeBuilder.fiche;
        for (Info info : otherFiche.getInfoList()) {
            this.appendInfo(info.getFieldKey(), info);
        }
        for (Section section : otherFiche.getSectionList()) {
            this.appendSection(section.getFieldKey(), section);
        }
        FicheItems otherOwners = otherFiche.getOwners();
        if (otherOwners != null) {
            this.appendOwners(otherOwners);
        }
        for (Map.Entry<FieldKey, Boolean> entry : otherFicheChangeBuilder.fieldKeyMap.entrySet()) {
            FieldKey fieldKey;
            boolean b = entry.getValue();
            if (b || this.fieldKeyMap.containsKey(fieldKey = entry.getKey())) continue;
            this.fieldKeyMap.put(fieldKey, Boolean.FALSE);
        }
        return this;
    }

    public FicheChange toFicheChange() {
        boolean notEmpty = false;
        ArrayList<FieldKey> removedList = new ArrayList<FieldKey>();
        for (Map.Entry<FieldKey, Boolean> entry : this.fieldKeyMap.entrySet()) {
            Boolean b = entry.getValue();
            if (!b.booleanValue()) {
                removedList.add(entry.getKey());
                continue;
            }
            notEmpty = true;
        }
        Fiche ficheAPI = notEmpty ? this.fiche : null;
        List<FieldKey> finalRemovedList = CorpusMetadataUtils.wrap(removedList.toArray(new FieldKey[removedList.size()]));
        return new InternalFicheChange(ficheAPI, finalRemovedList);
    }

    private void setRemoveable(FieldKey fieldKey) {
        if (!this.fieldKeyMap.containsKey(fieldKey)) {
            this.fieldKeyMap.put(fieldKey, Boolean.FALSE);
        }
    }

    public static FicheChangeBuilder init() {
        return new FicheChangeBuilder();
    }

    public static FicheChangeBuilder init(Fiche fiche) {
        return new FicheChangeBuilder(fiche);
    }

    private static class InternalFicheChange
    implements FicheChange {
        private final FicheAPI ficheAPI;
        private final List<FieldKey> removedList;

        private InternalFicheChange(FicheAPI ficheAPI, List<FieldKey> removedList) {
            this.ficheAPI = ficheAPI;
            this.removedList = removedList;
        }

        @Override
        public FicheAPI getFicheAPI() {
            return this.ficheAPI;
        }

        @Override
        public List<FieldKey> getRemovedList() {
            return this.removedList;
        }
    }
}

