/*
 * Decompiled with CFR 0.152.
 */
package net.fichotheque.thesaurus.policies;

import java.util.List;
import net.fichotheque.SubsetKey;
import net.fichotheque.externalsource.ExternalSourceDef;
import net.fichotheque.thesaurus.Thesaurus;

public interface DynamicEditPolicy {
    public static final String NONE_TYPE = "none";
    public static final String ALLOW_TYPE = "allow";
    public static final String CHECK_TYPE = "check";
    public static final String TRANSFER_TYPE = "transfer";
    public static final String EXTERNAL_TYPE = "external";

    public String getType();

    default public boolean isLax() {
        return false;
    }

    default public boolean isValid(Thesaurus thesaurus) {
        switch (this.getType()) {
            case "allow": 
            case "check": {
                return thesaurus.isBabelienType();
            }
            case "transfer": {
                return thesaurus.isBabelienType() || thesaurus.isMultiType();
            }
        }
        return true;
    }

    public static interface External
    extends DynamicEditPolicy {
        public ExternalSourceDef getExternalSourceDef();

        @Override
        default public String getType() {
            return DynamicEditPolicy.EXTERNAL_TYPE;
        }
    }

    public static interface Transfer
    extends DynamicEditPolicy {
        public SubsetKey getTransferThesaurusKey();

        @Override
        default public String getType() {
            return DynamicEditPolicy.TRANSFER_TYPE;
        }
    }

    public static interface Check
    extends DynamicEditPolicy {
        public List<SubsetKey> getCheckSubseKeyList();

        @Override
        default public boolean isLax() {
            return true;
        }

        @Override
        default public String getType() {
            return DynamicEditPolicy.CHECK_TYPE;
        }
    }

    public static interface Allow
    extends DynamicEditPolicy {
        @Override
        default public boolean isLax() {
            return true;
        }

        @Override
        default public String getType() {
            return DynamicEditPolicy.ALLOW_TYPE;
        }
    }

    public static interface None
    extends DynamicEditPolicy {
        @Override
        default public String getType() {
            return DynamicEditPolicy.NONE_TYPE;
        }
    }
}

