/*
 * Decompiled with CFR 0.152.
 */
package net.fichotheque.junction;

import net.fichotheque.SubsetItem;
import net.fichotheque.SubsetKey;

public final class JunctionKey
implements Comparable<JunctionKey> {
    private final SubsetKey subsetKey1;
    private final SubsetKey subsetKey2;
    private final int id1;
    private final int id2;

    public JunctionKey(SubsetKey subsetKey1, SubsetKey subsetKey2, int id1, int id2) {
        int compare = subsetKey1.compareTo(subsetKey2);
        if (compare > 0) {
            this.subsetKey2 = subsetKey1;
            this.subsetKey1 = subsetKey2;
            this.id1 = id2;
            this.id2 = id1;
        } else if (compare == 0) {
            this.subsetKey1 = subsetKey1;
            this.subsetKey2 = subsetKey2;
            if (id1 == id2) {
                throw new IllegalArgumentException("SubsetKey and id are the same");
            }
            if (id2 < id1) {
                this.id1 = id2;
                this.id2 = id1;
            } else {
                this.id1 = id1;
                this.id2 = id2;
            }
        } else {
            this.subsetKey1 = subsetKey1;
            this.subsetKey2 = subsetKey2;
            this.id1 = id1;
            this.id2 = id2;
        }
    }

    public SubsetKey getSubsetKey1() {
        return this.subsetKey1;
    }

    public SubsetKey getSubsetKey2() {
        return this.subsetKey2;
    }

    public int getId1() {
        return this.id1;
    }

    public int getId2() {
        return this.id2;
    }

    public int getOrder(SubsetItem subsetItem) {
        SubsetKey subsetKey = subsetItem.getSubsetKey();
        int id = subsetItem.getId();
        if (subsetKey.equals(this.subsetKey1)) {
            if (id == this.id1) {
                return 1;
            }
            if (subsetKey.equals(this.subsetKey2)) {
                if (id == this.id2) {
                    return 2;
                }
                return 0;
            }
            return 0;
        }
        if (subsetKey.equals(this.subsetKey2)) {
            if (id == this.id2) {
                return 2;
            }
            return 0;
        }
        return 0;
    }

    public int hashCode() {
        return this.subsetKey1.hashCode() * 1000 + this.id1 * 100 + this.subsetKey2.hashCode() * 10 + this.id2;
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (other == this) {
            return true;
        }
        if (other.getClass() != this.getClass()) {
            return false;
        }
        JunctionKey otherJunctionKey = (JunctionKey)other;
        if (otherJunctionKey.id1 != this.id1) {
            return false;
        }
        if (otherJunctionKey.id2 != this.id2) {
            return false;
        }
        if (!otherJunctionKey.subsetKey1.equals(this.subsetKey1)) {
            return false;
        }
        return otherJunctionKey.subsetKey2.equals(this.subsetKey2);
    }

    public String toString() {
        return this.subsetKey1 + "/" + this.id1 + "|" + this.subsetKey2 + "/" + this.id2;
    }

    @Override
    public int compareTo(JunctionKey otherJunctionKey) {
        int comp = this.subsetKey1.compareTo(otherJunctionKey.subsetKey1);
        if (comp != 0) {
            return comp;
        }
        comp = this.subsetKey2.compareTo(otherJunctionKey.subsetKey2);
        if (comp != 0) {
            return comp;
        }
        if (this.id1 < otherJunctionKey.id1) {
            return -1;
        }
        if (this.id1 > otherJunctionKey.id1) {
            return 1;
        }
        if (this.id2 < otherJunctionKey.id2) {
            return -1;
        }
        if (this.id2 > otherJunctionKey.id2) {
            return 1;
        }
        return 0;
    }

    public static JunctionKey toJunctionKey(SubsetItem subsetItem1, SubsetItem subsetItem2) {
        return new JunctionKey(subsetItem1.getSubsetKey(), subsetItem2.getSubsetKey(), subsetItem1.getId(), subsetItem2.getId());
    }

    public static int getOrder(SubsetItem mainSubsetItem, SubsetItem otherSubsetItem) {
        JunctionKey junctionKey = JunctionKey.toJunctionKey(mainSubsetItem, otherSubsetItem);
        return junctionKey.getOrder(mainSubsetItem);
    }
}

