/*
 * Decompiled with CFR 0.152.
 */
package net.fichotheque.format;

import java.text.ParseException;
import net.fichotheque.FichothequeConstants;
import net.fichotheque.SubsetKey;
import net.fichotheque.corpus.metadata.FieldKey;
import net.fichotheque.corpus.metadata.SubfieldKey;
import net.fichotheque.format.SubsetPathKey;
import net.fichotheque.include.IncludeKey;
import net.fichotheque.thesaurus.metadata.ThesaurusFieldKey;
import net.mapeadores.util.attr.AttributeKey;

public final class FormatSourceKey {
    public static final short SPECIAL_TYPE = 0;
    public static final short FIELDKEY_TYPE = 1;
    public static final short SUBFIELDKEY_TYPE = 2;
    public static final short INCLUDEKEY_TYPE = 3;
    public static final short THESAURUSFIELDKEY_TYPE = 4;
    public static final short NAMEPREFIXFIELDKEY_TYPE = 5;
    public static final short ATTRIBUTEKEY_TYPE = 6;
    public static final short ID_TYPE = 7;
    public static final short PARENTAGESUBSETKEY_TYPE = 8;
    public static final short SPECIALINCLUDENAME_TYPE = 9;
    public static final short LANG_TYPE = 10;
    public static final FormatSourceKey EXTRACTION = new FormatSourceKey(0, "extraction");
    public static final FormatSourceKey CONSTANT = new FormatSourceKey(0, "constant");
    public static final FormatSourceKey ID = new FormatSourceKey(7, "id");
    public static final FormatSourceKey LANG = new FormatSourceKey(10, "lang");
    public static final FormatSourceKey DATE_CREATION = new FormatSourceKey(9, "date_creation");
    public static final FormatSourceKey DATE_MODIFICATION = new FormatSourceKey(9, "date_modification");
    private final short sourceType;
    private final Object keyObject;
    private final SubsetPathKey subsetPathKey;

    private FormatSourceKey(short sourceType, Object keyObject) {
        this.sourceType = sourceType;
        this.keyObject = keyObject;
        this.subsetPathKey = null;
    }

    private FormatSourceKey(short sourceType, Object keyObject, SubsetPathKey subsetPathKey) {
        this.sourceType = sourceType;
        this.keyObject = keyObject;
        this.subsetPathKey = subsetPathKey;
    }

    public static FormatSourceKey newFieldKeyInstance(FieldKey fieldKey) {
        return FormatSourceKey.newFieldKeyInstance(fieldKey, null);
    }

    public static FormatSourceKey newFieldKeyInstance(FieldKey fieldKey, SubsetPathKey subsetPathKey) {
        if (fieldKey == null) {
            throw new IllegalArgumentException("fieldKey is null");
        }
        FormatSourceKey formatSourceKey = new FormatSourceKey(1, fieldKey, subsetPathKey);
        return formatSourceKey;
    }

    public static FormatSourceKey newSubfieldKeyInstance(SubfieldKey subfieldKey) {
        return FormatSourceKey.newSubfieldKeyInstance(subfieldKey, null);
    }

    public static FormatSourceKey newSubfieldKeyInstance(SubfieldKey subfieldKey, SubsetPathKey subsetPathKey) {
        if (subfieldKey == null) {
            throw new IllegalArgumentException("subfieldKey is null");
        }
        return new FormatSourceKey(2, subfieldKey, subsetPathKey);
    }

    public static FormatSourceKey newIncludeKeyInstance(IncludeKey includeKey) {
        return FormatSourceKey.newIncludeKeyInstance(includeKey, null);
    }

    public static FormatSourceKey newIncludeKeyInstance(IncludeKey includeKey, SubsetPathKey subsetPathKey) {
        if (includeKey == null) {
            throw new IllegalArgumentException("includeKey is null");
        }
        return new FormatSourceKey(3, includeKey, subsetPathKey);
    }

    public static FormatSourceKey newSpecialIncludeNameInstance(String specialIncludeName) {
        return FormatSourceKey.newSpecialIncludeNameInstance(specialIncludeName, null);
    }

    public static FormatSourceKey newSpecialIncludeNameInstance(String specialIncludeName, SubsetPathKey subsetPathKey) {
        if (specialIncludeName == null) {
            throw new IllegalArgumentException("specialIncludeName is null");
        }
        specialIncludeName = FichothequeConstants.checkSpecialIncludeName(specialIncludeName);
        return new FormatSourceKey(9, specialIncludeName, subsetPathKey);
    }

    public static FormatSourceKey newThesaurusFieldKeyInstance(ThesaurusFieldKey thesaurusFieldKey) {
        return FormatSourceKey.newThesaurusFieldKeyInstance(thesaurusFieldKey, null);
    }

    public static FormatSourceKey newThesaurusFieldKeyInstance(ThesaurusFieldKey thesaurusFieldKey, SubsetPathKey subsetPathKey) {
        if (thesaurusFieldKey == null) {
            throw new IllegalArgumentException("thesaurusFieldKey is null");
        }
        return new FormatSourceKey(4, thesaurusFieldKey, subsetPathKey);
    }

    public static FormatSourceKey newNamePrefixFieldKeyInstance(FieldKey namePrefixFieldKey) {
        return FormatSourceKey.newNamePrefixFieldKeyInstance(namePrefixFieldKey, null);
    }

    public static FormatSourceKey newNamePrefixFieldKeyInstance(FieldKey namePrefixFieldKey, SubsetPathKey subsetPathKey) {
        if (namePrefixFieldKey == null) {
            throw new IllegalArgumentException("namePrefixFieldKey is null");
        }
        if (namePrefixFieldKey.isSpecial()) {
            throw new IllegalArgumentException("namePrefixFieldKey is a special field: " + namePrefixFieldKey.getKeyString());
        }
        FormatSourceKey formatSourceKey = new FormatSourceKey(5, namePrefixFieldKey, subsetPathKey);
        return formatSourceKey;
    }

    public static FormatSourceKey newAttributeKeyInstance(AttributeKey attributeKey) {
        return FormatSourceKey.newAttributeKeyInstance(attributeKey, null);
    }

    public static FormatSourceKey newAttributeKeyInstance(AttributeKey attributeKey, SubsetPathKey subsetPathKey) {
        if (attributeKey == null) {
            throw new IllegalArgumentException("attributeKey is null");
        }
        return new FormatSourceKey(6, attributeKey, subsetPathKey);
    }

    public static FormatSourceKey newIdInstance(SubsetPathKey subsetPathKey) {
        return new FormatSourceKey(7, "id", subsetPathKey);
    }

    public static FormatSourceKey newLangInstance(SubsetPathKey subsetPathKey) {
        return new FormatSourceKey(10, "lang", subsetPathKey);
    }

    public static FormatSourceKey newParentageSubsetKeyInstance(SubsetKey subsetKey) {
        return FormatSourceKey.newParentageSubsetKeyInstance(subsetKey, null);
    }

    public static FormatSourceKey newParentageSubsetKeyInstance(SubsetKey subsetKey, SubsetPathKey subsetPathKey) {
        if (subsetKey == null) {
            throw new IllegalArgumentException("subsetKey is null");
        }
        if (!subsetKey.isCorpusSubset() && !subsetKey.isThesaurusSubset()) {
            throw new IllegalArgumentException("wrong subsetKey type: " + subsetKey);
        }
        FormatSourceKey formatSourceKey = new FormatSourceKey(8, subsetKey, subsetPathKey);
        return formatSourceKey;
    }

    public short getSourceType() {
        return this.sourceType;
    }

    public Object getKeyObject() {
        return this.keyObject;
    }

    public SubsetPathKey getSubsetPathKey() {
        return this.subsetPathKey;
    }

    public String getKeyString() {
        return this.toString();
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        if (this.subsetPathKey != null) {
            buf.append(this.subsetPathKey.toString());
            buf.append('/');
        }
        if (this.sourceType == 8) {
            buf.append(SubsetKey.toParentageString((SubsetKey)this.keyObject));
        } else {
            buf.append(this.keyObject.toString());
            if (this.sourceType == 5) {
                buf.append('*');
            }
        }
        return buf.toString();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (obj.getClass() != this.getClass()) {
            return false;
        }
        FormatSourceKey other = (FormatSourceKey)obj;
        if (other.sourceType != this.sourceType) {
            return false;
        }
        if (this.subsetPathKey != null) {
            if (other.subsetPathKey == null) return false;
            if (this.subsetPathKey.equals(other.subsetPathKey)) return other.keyObject.equals(this.keyObject);
            return false;
        }
        if (other.subsetPathKey == null) return other.keyObject.equals(this.keyObject);
        return false;
    }

    public int hashCode() {
        int hashCode = 0;
        if (this.subsetPathKey != null) {
            hashCode = this.subsetPathKey.hashCode();
        }
        return hashCode + this.keyObject.hashCode();
    }

    public static FormatSourceKey parse(String formatSource) throws ParseException {
        switch (formatSource) {
            case "extraction": {
                return EXTRACTION;
            }
            case "constant": 
            case "null": {
                return CONSTANT;
            }
            case "id": {
                return ID;
            }
            case "lang": {
                return LANG;
            }
        }
        SubsetPathKey subsetPathKey = null;
        int idx = formatSource.lastIndexOf(47);
        if (idx != -1) {
            String subsetPathString = formatSource.substring(0, idx);
            subsetPathKey = SubsetPathKey.parse(subsetPathString);
            switch (formatSource = formatSource.substring(idx + 1)) {
                case "id": {
                    return FormatSourceKey.newIdInstance(subsetPathKey);
                }
                case "lang": {
                    return FormatSourceKey.newLangInstance(subsetPathKey);
                }
            }
        }
        if (formatSource.endsWith("*")) {
            FieldKey namePrefixFieldKey = FieldKey.parse(formatSource.substring(0, formatSource.length() - 1));
            try {
                return FormatSourceKey.newNamePrefixFieldKeyInstance(namePrefixFieldKey, subsetPathKey);
            }
            catch (IllegalArgumentException iae) {
                throw new ParseException("Special field key", 0);
            }
        }
        try {
            String specialFormatSource = FichothequeConstants.checkSpecialIncludeName(formatSource);
            return FormatSourceKey.newSpecialIncludeNameInstance(specialFormatSource, subsetPathKey);
        }
        catch (IllegalArgumentException specialFormatSource) {
            try {
                FieldKey fk = FieldKey.parse(formatSource);
                return FormatSourceKey.newFieldKeyInstance(fk, subsetPathKey);
            }
            catch (ParseException pe1) {
                try {
                    SubfieldKey subfieldKey = SubfieldKey.parse(formatSource);
                    return FormatSourceKey.newSubfieldKeyInstance(subfieldKey, subsetPathKey);
                }
                catch (ParseException pe2) {
                    try {
                        IncludeKey includeKey = IncludeKey.parse(formatSource);
                        return FormatSourceKey.newIncludeKeyInstance(includeKey, subsetPathKey);
                    }
                    catch (ParseException pe3) {
                        try {
                            ThesaurusFieldKey thesaurusFieldKey = ThesaurusFieldKey.parse(formatSource);
                            return FormatSourceKey.newThesaurusFieldKeyInstance(thesaurusFieldKey, subsetPathKey);
                        }
                        catch (ParseException pe4) {
                            try {
                                AttributeKey attributeKey = AttributeKey.parse(formatSource);
                                return FormatSourceKey.newAttributeKeyInstance(attributeKey, subsetPathKey);
                            }
                            catch (ParseException pe5) {
                                try {
                                    SubsetKey parentageSubsetKey = SubsetKey.parseParentageSubsetKey(formatSource);
                                    return FormatSourceKey.newParentageSubsetKeyInstance(parentageSubsetKey, subsetPathKey);
                                }
                                catch (ParseException pe6) {
                                    throw new ParseException("Unable to parse " + formatSource, 0);
                                }
                            }
                        }
                    }
                }
            }
        }
    }
}

