/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.tools.importation;

import fr.exemole.bdfserver.api.BdfServer;
import fr.exemole.bdfserver.tools.configuration.ConfigurationUtils;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import net.fichotheque.importation.CorpusImport;
import net.fichotheque.importation.LabelImport;
import net.fichotheque.importation.ThesaurusImport;
import net.fichotheque.xml.importation.CorpusImportXMLPart;
import net.fichotheque.xml.importation.LabelImportXMLPart;
import net.fichotheque.xml.importation.ThesaurusImportXMLPart;
import net.mapeadores.util.xml.AppendableXMLWriter;
import net.mapeadores.util.xml.XMLUtils;

public final class ImportationFileUtils {
    private static final DateFormat NAME_FORMAT = new SimpleDateFormat("yyyy-MM-dd'_'HH-mm-ss");

    private ImportationFileUtils() {
    }

    public static File saveTmpXml(BdfServer bdfServer, LabelImport labelImport) throws IOException {
        File xmlTmpFile = ImportationFileUtils.createXmlTmpFile(bdfServer, "labelimport");
        try (BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(xmlTmpFile), "UTF-8"));){
            AppendableXMLWriter xmlWriter = XMLUtils.toXMLWriter(writer);
            xmlWriter.appendXMLDeclaration();
            LabelImportXMLPart labelImportXMLPart = new LabelImportXMLPart(xmlWriter);
            labelImportXMLPart.addLabelImport(labelImport);
        }
        return xmlTmpFile;
    }

    public static File saveTmpXml(BdfServer bdfServer, ThesaurusImport thesaurusImport) throws IOException {
        File xmlTmpFile = ImportationFileUtils.createXmlTmpFile(bdfServer, "thesaurusimport");
        try (BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(xmlTmpFile), "UTF-8"));){
            AppendableXMLWriter xmlWriter = XMLUtils.toXMLWriter(writer);
            xmlWriter.appendXMLDeclaration();
            ThesaurusImportXMLPart thesaurusImportXMLPart = new ThesaurusImportXMLPart(xmlWriter);
            thesaurusImportXMLPart.addThesaurusImport(thesaurusImport);
        }
        return xmlTmpFile;
    }

    public static File saveTmpXml(BdfServer bdfServer, CorpusImport corpusImport) throws IOException {
        File xmlTmpFile = ImportationFileUtils.createXmlTmpFile(bdfServer, "corpusimport");
        try (BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(xmlTmpFile), "UTF-8"));){
            AppendableXMLWriter xmlWriter = XMLUtils.toXMLWriter(writer);
            xmlWriter.appendXMLDeclaration();
            CorpusImportXMLPart corpusImportXMLPart = new CorpusImportXMLPart(xmlWriter);
            corpusImportXMLPart.addCorpusImport(corpusImport);
        }
        return xmlTmpFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File createXmlTmpFile(BdfServer bdfServer, String basename) {
        BdfServer bdfServer2 = bdfServer;
        synchronized (bdfServer2) {
            File tmpDirectory = ConfigurationUtils.getTmpDirectory(bdfServer, true);
            String name = ImportationFileUtils.getTmpName(tmpDirectory, basename, ".xml");
            return new File(tmpDirectory, name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File createTmpDir(BdfServer bdfServer, String basename) throws IOException {
        BdfServer bdfServer2 = bdfServer;
        synchronized (bdfServer2) {
            File tmpDirectory = ConfigurationUtils.getTmpDirectory(bdfServer, true);
            String name = ImportationFileUtils.getTmpName(tmpDirectory, basename, "");
            File dir = new File(tmpDirectory, name);
            dir.mkdir();
            return dir;
        }
    }

    private static String getTmpName(File dir, String basename, String extension) {
        String prefix = basename + "_" + NAME_FORMAT.format(new Date());
        String name = prefix + extension;
        File file = new File(dir, name);
        if (!file.exists()) {
            return name;
        }
        int p = 2;
        while ((file = new File(name = prefix + "_" + p + extension)).exists()) {
            ++p;
        }
        return name;
    }
}

