/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.tools.diagnostic.urlscan;

import fr.exemole.bdfserver.api.BdfServer;
import fr.exemole.bdfserver.tools.diagnostic.urlscan.UrlInfo;
import fr.exemole.bdfserver.tools.diagnostic.urlscan.UrlReport;
import fr.exemole.bdfserver.tools.diagnostic.urlscan.UrlReportCache;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.fichotheque.corpus.Corpus;
import net.fichotheque.corpus.FicheMeta;
import net.fichotheque.corpus.Fiches;
import net.fichotheque.corpus.fiche.FicheAPI;
import net.fichotheque.corpus.fiche.FicheBlock;
import net.fichotheque.corpus.fiche.FicheBlocks;
import net.fichotheque.corpus.fiche.FicheItem;
import net.fichotheque.corpus.fiche.FicheItems;
import net.fichotheque.corpus.fiche.Insert;
import net.fichotheque.corpus.fiche.Li;
import net.fichotheque.corpus.fiche.LinkItem;
import net.fichotheque.corpus.fiche.ParagraphBlock;
import net.fichotheque.corpus.fiche.S;
import net.fichotheque.corpus.fiche.Table;
import net.fichotheque.corpus.fiche.Td;
import net.fichotheque.corpus.fiche.TextContent;
import net.fichotheque.corpus.fiche.Tr;
import net.fichotheque.corpus.fiche.Ul;
import net.fichotheque.corpus.fiche.ZoneBlock;
import net.fichotheque.corpus.metadata.CorpusField;
import net.fichotheque.corpus.metadata.CorpusMetadata;
import net.fichotheque.corpus.metadata.FieldKey;
import net.fichotheque.utils.CorpusMetadataUtils;

public final class UrlScanEngine {
    private final Map<String, UrlInfo> infoMap = new HashMap<String, UrlInfo>();
    private final BdfServer bdfServer;
    private final UrlReportCache cache;
    private final Map<String, UrlReport> urlReportMap;

    private UrlScanEngine(BdfServer bdfServer) {
        this.bdfServer = bdfServer;
        this.cache = new UrlReportCache(bdfServer);
        this.urlReportMap = this.cache.read();
    }

    private void add(String url, FicheMeta ficheMeta, FieldKey fieldKey) {
        UrlInfo info = this.infoMap.get(url);
        if (info == null) {
            UrlReport urlReport = this.urlReportMap.get(url);
            info = UrlInfo.initWithFicheInfo(url, urlReport);
            this.infoMap.put(url, info);
        }
        info.add(ficheMeta, fieldKey);
    }

    private void scanCorpus(Corpus corpus, List<FicheMeta> ficheMetaList) {
        CorpusInfo corpusInfo = new CorpusInfo(corpus);
        if (!corpusInfo.isEmpty()) {
            for (FicheMeta ficheMeta : ficheMetaList) {
                corpusInfo.scanFiche(ficheMeta);
            }
        }
    }

    private void cacheResult() {
        this.cache.cache(this.urlReportMap.values(), false);
    }

    public static Map<String, UrlInfo> run(BdfServer bdfServer) {
        UrlScanEngine urlScanEngine = new UrlScanEngine(bdfServer);
        for (Corpus corpus : bdfServer.getFichotheque().getCorpusList()) {
            urlScanEngine.scanCorpus(corpus, corpus.getFicheMetaList());
        }
        urlScanEngine.cacheResult();
        return urlScanEngine.infoMap;
    }

    public static Map<String, UrlInfo> run(BdfServer bdfServer, Fiches fiches) {
        UrlScanEngine urlScanEngine = new UrlScanEngine(bdfServer);
        for (Fiches.Entry entry : fiches.getEntryList()) {
            urlScanEngine.scanCorpus(entry.getCorpus(), entry.getFicheMetaList());
        }
        urlScanEngine.cacheResult();
        return urlScanEngine.infoMap;
    }

    private class CorpusInfo {
        private final String corpusName;
        private final Corpus corpus;
        private final FieldKey[] linkFieldArray;
        private final FieldKey[] sectionFieldArray;
        private final boolean withSection;
        private FicheMeta currentFicheMeta;
        private FieldKey currentFieldKey;

        private CorpusInfo(Corpus corpus) {
            this.corpus = corpus;
            this.corpusName = corpus.getSubsetName();
            CorpusMetadata corpusMetadata = corpus.getCorpusMetadata();
            List<CorpusField> fieldList = CorpusMetadataUtils.getCorpusFieldListByFicheItemType(corpusMetadata, "link", false);
            this.linkFieldArray = CorpusMetadataUtils.toFieldKeyArray(fieldList);
            this.sectionFieldArray = CorpusMetadataUtils.toFieldKeyArray(corpusMetadata.getSectionList());
            this.withSection = this.sectionFieldArray.length != 0;
        }

        private boolean isEmpty() {
            return this.linkFieldArray.length == 0 && !this.withSection;
        }

        private void scanFiche(FicheMeta ficheMeta) {
            Object value;
            FieldKey fieldKey;
            int n;
            this.currentFicheMeta = ficheMeta;
            FicheAPI ficheAPI = ficheMeta.getFicheAPI(this.withSection);
            FieldKey[] fieldKeyArray = this.linkFieldArray;
            int n2 = fieldKeyArray.length;
            for (n = 0; n < n2; ++n) {
                this.currentFieldKey = fieldKey = fieldKeyArray[n];
                value = ficheAPI.getValue(fieldKey);
                if (value == null) continue;
                if (value instanceof FicheItem) {
                    this.testFicheItem((FicheItem)value);
                    continue;
                }
                if (!(value instanceof FicheItems)) continue;
                for (FicheItem ficheItem : (FicheItems)value) {
                    this.testFicheItem(ficheItem);
                }
            }
            if (this.withSection) {
                fieldKeyArray = this.sectionFieldArray;
                n2 = fieldKeyArray.length;
                for (n = 0; n < n2; ++n) {
                    this.currentFieldKey = fieldKey = fieldKeyArray[n];
                    value = ficheAPI.getValue(fieldKey);
                    if (value == null) continue;
                    this.testFicheBlocks((FicheBlocks)value);
                }
            }
        }

        private void testFicheItem(FicheItem ficheItem) {
            LinkItem link;
            String href;
            if (ficheItem instanceof LinkItem && !(href = (link = (LinkItem)ficheItem).getHref()).isEmpty()) {
                UrlScanEngine.this.add(href, this.currentFicheMeta, this.currentFieldKey);
            }
        }

        private void testFicheBlocks(FicheBlocks ficheBlocks) {
            for (FicheBlock ficheBlock : ficheBlocks) {
                if (ficheBlock instanceof ParagraphBlock) {
                    this.testTextContent((TextContent)((Object)ficheBlock));
                    continue;
                }
                if (ficheBlock instanceof Ul) {
                    for (Li li : (Ul)ficheBlock) {
                        this.testFicheBlocks(li);
                    }
                    continue;
                }
                if (!(ficheBlock instanceof ZoneBlock)) continue;
                ZoneBlock zoneBlock = (ZoneBlock)ficheBlock;
                this.testTextContent(zoneBlock.getLegende());
                this.testTextContent(zoneBlock.getLegende());
                if (zoneBlock instanceof Insert) {
                    Insert insert = (Insert)zoneBlock;
                    this.testTextContent(insert.getAlt());
                    this.testTextContent(insert.getCredit());
                    continue;
                }
                if (!(zoneBlock instanceof Table)) continue;
                Table table = (Table)zoneBlock;
                for (Tr tr : (Table)zoneBlock) {
                    for (Td td : tr) {
                        this.testTextContent(td);
                    }
                }
            }
        }

        private void testTextContent(TextContent textContent) {
            for (Object object : textContent) {
                if (!(object instanceof S)) continue;
                S span = (S)object;
                this.testSpan(span);
            }
        }

        private void testSpan(S span) {
            switch (span.getType()) {
                case 5: 
                case 6: 
                case 8: 
                case 24: {
                    break;
                }
                default: {
                    String ref = span.getRef();
                    if (ref.isEmpty() || ref.startsWith("#")) break;
                    UrlScanEngine.this.add(ref, this.currentFicheMeta, this.currentFieldKey);
                }
            }
        }
    }
}

