/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.tools.balayage.engine;

import fr.exemole.bdfserver.api.BdfServer;
import fr.exemole.bdfserver.api.balayage.BalayageUnitRunner;
import fr.exemole.bdfserver.api.externalscript.ExternalScript;
import fr.exemole.bdfserver.tools.balayage.engine.BalayageLog;
import fr.exemole.bdfserver.tools.balayage.engine.BalayageParameters;
import fr.exemole.bdfserver.tools.balayage.engine.SiteMapBuilder;
import fr.exemole.bdfserver.tools.balayage.engine.runners.RunnerFactory;
import fr.exemole.bdfserver.tools.runners.ScrutariExportRunner;
import fr.exemole.bdfserver.tools.runners.SqlExportRunner;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import net.fichotheque.exportation.balayage.BalayageMode;
import net.fichotheque.exportation.balayage.BalayagePostscriptum;
import net.fichotheque.exportation.balayage.BalayageUnit;
import net.fichotheque.exportation.scrutari.ScrutariExportDef;
import net.fichotheque.exportation.sql.SqlExportDef;
import net.mapeadores.util.logging.CommandMessage;

public class BalayageEngine {
    private final BalayageParameters balayageParameters;
    private final List<BalayageUnitRunner> balayageUnitRunnerList = new ArrayList<BalayageUnitRunner>();
    private final SiteMapBuilder siteMapBuilder;

    public BalayageEngine(BalayageParameters balayageParameters) {
        this.balayageParameters = balayageParameters;
        this.siteMapBuilder = (SiteMapBuilder)balayageParameters.getFileGenerationListener();
        List<BalayageUnit> balayageUnitList = balayageParameters.getBalayageDef().getBalayageUnitList();
        int balayageUnitLength = balayageUnitList.size();
        for (int i = 0; i < balayageUnitLength; ++i) {
            BalayageUnit balayageUnit = balayageUnitList.get(i);
            if (!this.doBalayageUnit(balayageUnit)) continue;
            BalayageUnitRunner bu = RunnerFactory.get(balayageParameters, i, balayageUnit);
            this.balayageUnitRunnerList.add(bu);
        }
    }

    private boolean doBalayageUnit(BalayageUnit balayageUnit) {
        BalayageMode balayageMode = this.balayageParameters.getBalayageMode();
        if (balayageMode == null) {
            return true;
        }
        return balayageUnit.hasMode(balayageMode.getName());
    }

    public void run() {
        BalayageLog balayageLog = this.balayageParameters.getBalayageLog();
        balayageLog.runStarted();
        for (BalayageUnitRunner bu : this.balayageUnitRunnerList) {
            bu.run();
            bu.dispose();
        }
        this.balayageUnitRunnerList.clear();
        if (this.siteMapBuilder != null) {
            try {
                String path = this.siteMapBuilder.writeSiteMapFile(this.balayageParameters.getBalayageRootDirectory());
                balayageLog.addPostscriptumLog("sitemap", path);
            }
            catch (IOException ioe) {
                balayageLog.addPostscriptumError("sitemap", "", "ioException", this.getMessage(ioe));
            }
        }
        this.execPostscriptum();
        balayageLog.runEnded();
    }

    private void execPostscriptum() {
        BalayageLog balayageLog = this.balayageParameters.getBalayageLog();
        if (balayageLog.hasError()) {
            return;
        }
        BdfServer bdfServer = this.balayageParameters.getBdfServer();
        BalayagePostscriptum postscriptum = this.balayageParameters.getBalayageDef().getPostscriptum();
        for (String name : postscriptum.getScrutariExportNameList()) {
            ScrutariExportDef scrutariExportDef = bdfServer.getScrutariExportManager().getScrutariExportDef(name);
            if (scrutariExportDef != null) {
                try {
                    ScrutariExportRunner.run(scrutariExportDef, bdfServer, this.balayageParameters.getPathConfiguration());
                    balayageLog.addPostscriptumLog("scrutariexport", name);
                }
                catch (IOException ioe) {
                    balayageLog.addPostscriptumError("scrutariexport", name, "ioException", this.getMessage(ioe));
                }
                continue;
            }
            balayageLog.addPostscriptumError("scrutariexport", name, "unknownName", name);
        }
        for (String name : postscriptum.getSqlExportNameList()) {
            SqlExportDef sqlExportDef = bdfServer.getSqlExportManager().getSqlExportDef(name);
            if (sqlExportDef != null) {
                try {
                    CommandMessage message = SqlExportRunner.run(sqlExportDef, bdfServer, this.balayageParameters.getPathConfiguration(), false);
                    if (message.isErrorMessage()) {
                        balayageLog.addPostscriptumError("sqlexport", name, "sqlExportError", message.getMessageKey());
                        continue;
                    }
                    balayageLog.addPostscriptumLog("sqlexport", name);
                }
                catch (IOException ioe) {
                    balayageLog.addPostscriptumError("sqlexport", name, "ioException", this.getMessage(ioe));
                }
                continue;
            }
            balayageLog.addPostscriptumError("sqlexport", name, "unknownName", name);
        }
        if (balayageLog.hasError()) {
            return;
        }
        for (String name : postscriptum.getExternalScriptNameList()) {
            ExternalScript externalScript = bdfServer.getExternalScriptManager().getExternalScript(name);
            if (externalScript != null) {
                try {
                    externalScript.exec();
                    balayageLog.addPostscriptumLog("command", name);
                }
                catch (IOException ioe) {
                    balayageLog.addPostscriptumError("command", name, "commandIOException", this.getMessage(ioe));
                }
                continue;
            }
            balayageLog.addPostscriptumError("command", name, "commandCheck", "wrong script name : " + name);
        }
    }

    private String getMessage(IOException ioe) {
        String msg = ioe.getMessage();
        String message = ioe.getClass().getName();
        if (msg != null) {
            message = message + " : " + msg;
        }
        return message;
    }
}

