/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.storage.directory.implementations;

import fr.exemole.bdfserver.api.storage.BdfStorageException;
import fr.exemole.bdfserver.api.storage.PasswordStorage;
import fr.exemole.bdfserver.storage.directory.StorageDirectory;
import fr.exemole.bdfserver.storage.directory.bdfdata.BdfdataStorageFileCatalog;
import fr.exemole.bdfserver.tools.storage.StorageFile;
import fr.exemole.bdfserver.tools.storage.StorageUtils;
import java.io.BufferedWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class PasswordStorageImpl
implements PasswordStorage {
    private final StorageDirectory bdfdataDirectory;

    public PasswordStorageImpl(StorageDirectory bdfdataDirectory) {
        this.bdfdataDirectory = bdfdataDirectory;
    }

    @Override
    public String[] getPasswordArray() {
        ArrayList<String> result = new ArrayList<String>();
        List<String> lines = BdfdataStorageFileCatalog.password(this.bdfdataDirectory).readLines();
        if (lines != null) {
            for (String line : lines) {
                int idx = line.indexOf(58);
                if (idx < 1 || idx == line.length() - 1) continue;
                String passwordKey = line.substring(0, idx);
                String passwordValue = line.substring(idx + 1);
                result.add(passwordKey);
                result.add(passwordValue);
            }
        }
        return result.toArray(new String[result.size()]);
    }

    @Override
    public void savePasswordArray(String[] passwordArray) {
        StorageFile passwordStorageFile = BdfdataStorageFileCatalog.password(this.bdfdataDirectory);
        try (BufferedWriter writer = passwordStorageFile.getWriter();){
            StorageUtils.writePasswordArray(writer, passwordArray);
        }
        catch (IOException ioe) {
            throw new BdfStorageException(ioe);
        }
    }
}

