/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.storage.directory.bdfdata;

import fr.exemole.bdfserver.api.storage.BdfStorageException;
import fr.exemole.bdfserver.storage.directory.bdfdata.BdfdataDirectory;
import fr.exemole.bdfserver.storage.directory.bdfdata.BdfdataStorageFileCatalog;
import fr.exemole.bdfserver.storage.directory.bdfdata.DocumentDirectory;
import fr.exemole.bdfserver.storage.directory.bdfdata.ExceptionHandler;
import fr.exemole.bdfserver.storage.directory.bdfdata.IllustrationDirectory;
import fr.exemole.bdfserver.storage.directory.bdfdata.Save;
import fr.exemole.bdfserver.storage.directory.bdfdata.SubsetInfo;
import fr.exemole.bdfserver.storage.directory.bdfdata.SubsetInfoList;
import fr.exemole.bdfserver.storage.directory.implementations.FichothequeDataSourceImpl;
import fr.exemole.bdfserver.storage.directory.jdbm.EnteteFiche;
import fr.exemole.bdfserver.storage.directory.jdbm.FichothequeJdbm;
import fr.exemole.bdfserver.storage.directory.oldversions.AlbumDOMReader;
import fr.exemole.bdfserver.storage.directory.oldversions.OldFicheDOMReader;
import fr.exemole.bdfserver.storage.directory.oldversions.OldJunctionDOMReader;
import fr.exemole.bdfserver.storage.directory.oldversions.SphereDOMReader;
import fr.exemole.bdfserver.storage.directory.oldversions.ThesaurusDOMReader;
import fr.exemole.bdfserver.tools.storage.StorageFile;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import java.util.TreeSet;
import javax.imageio.IIOException;
import jdbm.RecordManager;
import jdbm.RecordManagerFactory;
import net.fichotheque.ExistingIdException;
import net.fichotheque.ExistingSubsetException;
import net.fichotheque.Fichotheque;
import net.fichotheque.FichothequeEditorProvider;
import net.fichotheque.Subset;
import net.fichotheque.SubsetItem;
import net.fichotheque.SubsetKey;
import net.fichotheque.addenda.AddendaEditor;
import net.fichotheque.addenda.Document;
import net.fichotheque.album.Album;
import net.fichotheque.album.AlbumEditor;
import net.fichotheque.album.Illustration;
import net.fichotheque.corpus.Corpus;
import net.fichotheque.corpus.CorpusEditor;
import net.fichotheque.corpus.FicheMeta;
import net.fichotheque.corpus.NoMasterIdException;
import net.fichotheque.corpus.fiche.Fiche;
import net.fichotheque.impl.FichothequeImpl;
import net.fichotheque.junction.Junction;
import net.fichotheque.junction.Junctions;
import net.fichotheque.sphere.Redacteur;
import net.fichotheque.sphere.Sphere;
import net.fichotheque.sphere.SphereEditor;
import net.fichotheque.thesaurus.Motcle;
import net.fichotheque.thesaurus.Thesaurus;
import net.fichotheque.thesaurus.ThesaurusEditor;
import net.fichotheque.tools.dom.AddendaMetadataDOMReader;
import net.fichotheque.tools.dom.AlbumMetadataDOMReader;
import net.fichotheque.tools.dom.CorpusMetadataDOMReader;
import net.fichotheque.tools.dom.DocumentDOMReader;
import net.fichotheque.tools.dom.FicheAttributesDOMReader;
import net.fichotheque.tools.dom.FicheDOMReader;
import net.fichotheque.tools.dom.FichothequeMetadataDOMReader;
import net.fichotheque.tools.dom.IllustrationDOMReader;
import net.fichotheque.tools.dom.JunctionDOMReader;
import net.fichotheque.tools.dom.MotcleDOMReader;
import net.fichotheque.tools.dom.RedacteurDOMReader;
import net.fichotheque.tools.dom.SphereListDOMReader;
import net.fichotheque.tools.dom.SphereMetadataDOMReader;
import net.fichotheque.tools.dom.ThesaurusMetadataDOMReader;
import net.fichotheque.tools.dom.ThesaurusTreeDOMReader;
import net.fichotheque.utils.FichothequeUtils;
import net.fichotheque.xml.storage.FicheStorageXMLPart;
import net.mapeadores.util.exceptions.ImplementationException;
import net.mapeadores.util.html.HtmlCleaner;
import net.mapeadores.util.io.FileUtils;
import net.mapeadores.util.localisation.LocalisationUtils;
import net.mapeadores.util.logging.ErrorMessageException;
import net.mapeadores.util.logging.MessageHandler;
import net.mapeadores.util.logging.MultiMessageHandler;
import net.mapeadores.util.primitives.FuzzyDate;
import net.mapeadores.util.primitives.PrimUtils;
import net.mapeadores.util.xml.AppendableXMLWriter;
import net.mapeadores.util.xml.XMLUtils;
import org.w3c.dom.Element;

public final class DirectoryFichotheque {
    private DirectoryFichotheque() {
    }

    public static Fichotheque buildReadOnly(BdfdataDirectory bdfdataDirectory, HtmlCleaner htmlCleaner, MultiMessageHandler messageHandler, ExceptionHandler exceptionHandler) {
        return DirectoryFichotheque.buildReadAndWrite(bdfdataDirectory, htmlCleaner, messageHandler, exceptionHandler).getFichotheque();
    }

    public static FichothequeEditorProvider buildReadAndWrite(BdfdataDirectory bdfdataDirectory, HtmlCleaner htmlCleaner, MultiMessageHandler messageHandler, ExceptionHandler exceptionHandler) {
        FichothequeImpl.InitEditor initEditor = FichothequeImpl.init();
        FichothequeInitializer fichothequeInitializer = new FichothequeInitializer(bdfdataDirectory, htmlCleaner, messageHandler, initEditor);
        fichothequeInitializer.init();
        return initEditor.endInit(new FichothequeDataSourceImpl(bdfdataDirectory, bdfdataDirectory.getCacheDir(), fichothequeInitializer.getFichothequeJdbm()), htmlCleaner);
    }

    private static class FichothequeInitializer {
        private final FichothequeImpl.InitEditor fichothequeInitEditor;
        private final BdfdataDirectory bdfdataDirectory;
        private final Fichotheque fichotheque;
        private final HtmlCleaner htmlCleaner;
        private final MultiMessageHandler messageHandler;
        private final Properties recManagerProps = new Properties();
        private boolean initFromJdbm = false;
        private String fichothequeJdbmPath;
        private RecordManager initRecordManager;
        private FichothequeJdbm fichothequeJdbm;

        private FichothequeInitializer(BdfdataDirectory bdfdataDirectory, HtmlCleaner htmlCleaner, MultiMessageHandler messageHandler, FichothequeImpl.InitEditor initEditor) {
            this.bdfdataDirectory = bdfdataDirectory;
            this.htmlCleaner = htmlCleaner;
            this.messageHandler = messageHandler;
            this.fichotheque = initEditor.getFichotheque();
            this.fichothequeInitEditor = initEditor;
        }

        private void initFichothequeJdbm() {
            File cacheDirectory = this.bdfdataDirectory.getCacheDir();
            File jdbmFile = new File(cacheDirectory, "fichotheque.db");
            if (jdbmFile.exists()) {
                this.initFromJdbm = true;
            }
            this.fichothequeJdbmPath = new File(cacheDirectory, "fichotheque").getPath();
            this.recManagerProps.setProperty("jdbm.provider", "fr.exemole.bdfserver.storage.directory.jdbm.Provider");
            this.recManagerProps.setProperty("jdbm.disableTransactions", "true");
            this.initRecordManager = null;
            try {
                this.initRecordManager = RecordManagerFactory.createRecordManager((String)this.fichothequeJdbmPath, (Properties)this.recManagerProps);
            }
            catch (IOException ioe) {
                if (this.initFromJdbm) {
                    jdbmFile.delete();
                    this.initFromJdbm = false;
                    try {
                        this.initRecordManager = RecordManagerFactory.createRecordManager((String)this.fichothequeJdbmPath, (Properties)this.recManagerProps);
                    }
                    catch (IOException ioe2) {
                        throw new BdfStorageException(ioe2);
                    }
                }
                throw new BdfStorageException(ioe);
            }
            if (this.initFromJdbm) {
                this.fichothequeJdbm = FichothequeJdbm.checkJdbmVersion(this.initRecordManager);
                if (this.fichothequeJdbm == null) {
                    jdbmFile.delete();
                    this.initFromJdbm = false;
                    try {
                        this.initRecordManager = RecordManagerFactory.createRecordManager((String)this.fichothequeJdbmPath, (Properties)this.recManagerProps);
                        this.fichothequeJdbm = FichothequeJdbm.initEmptyInstance(this.initRecordManager);
                    }
                    catch (IOException ioe2) {
                        throw new BdfStorageException(ioe2);
                    }
                }
            } else {
                this.fichothequeJdbm = FichothequeJdbm.initEmptyInstance(this.initRecordManager);
            }
        }

        private void setCurrentURI(StorageFile storageFile) {
            this.messageHandler.setCurrentSource(storageFile.toURI());
        }

        private FichothequeJdbm getFichothequeJdbm() {
            return this.fichothequeJdbm;
        }

        void init() {
            this.initFichothequeJdbm();
            this.initFichothequeMetadata();
            this.initSphereList();
            this.initThesaurusList();
            this.initAlbumList();
            this.initAddendaList();
            this.initCorpusList();
            this.initFiches();
            Subset[] subsetArray = FichothequeUtils.getSortedSubsetArray(this.fichotheque, null);
            int subsetCount = subsetArray.length;
            for (int i = 0; i < subsetCount; ++i) {
                Subset firstSubset = subsetArray[i];
                for (int j = i; j < subsetCount; ++j) {
                    Subset secondSubset = subsetArray[j];
                    this.initJunction(firstSubset, secondSubset);
                }
            }
            this.fichothequeJdbm.commitChanges();
            try {
                this.initRecordManager.close();
                this.recManagerProps.setProperty("jdbm.disableTransactions", "false");
                RecordManager recordManager = RecordManagerFactory.createRecordManager((String)this.fichothequeJdbmPath, (Properties)this.recManagerProps);
                this.fichothequeJdbm.setRecordManager(recordManager);
            }
            catch (IOException ioe2) {
                throw new BdfStorageException(ioe2);
            }
        }

        private void initFichothequeMetadata() {
            StorageFile storageFile = BdfdataStorageFileCatalog.fichothequeMetadata(this.bdfdataDirectory);
            org.w3c.dom.Document doc = storageFile.readDocument();
            if (doc != null) {
                this.setCurrentURI(storageFile);
                FichothequeMetadataDOMReader domReader = new FichothequeMetadataDOMReader(this.fichothequeInitEditor.getFichothequeMetadataEditor(), (MessageHandler)this.messageHandler);
                domReader.fillMetadata(doc.getDocumentElement());
            }
        }

        private void initSphereList() {
            SubsetKey sphereKey;
            ArrayList<SphereEditor> sphereEditorList = new ArrayList<SphereEditor>();
            ArrayList<Sphere> oldVersionList = new ArrayList<Sphere>();
            SubsetInfoList infoList = BdfdataStorageFileCatalog.getSubsetInfoList(this.bdfdataDirectory, (short)3);
            int standardlCount = infoList.getStandardSubsetCount();
            for (int i = 0; i < standardlCount; ++i) {
                StorageFile listStorageFile;
                SphereEditor sphereEditor;
                SubsetInfo subsetInfo = infoList.getStandardSubsetInfo(i);
                sphereKey = subsetInfo.getSubsetKey();
                StorageFile storageFile = subsetInfo.getStorageFile();
                this.setCurrentURI(storageFile);
                org.w3c.dom.Document document = storageFile.readDocument();
                boolean parseList = false;
                try {
                    Element root = document.getDocumentElement();
                    String tagName = root.getTagName();
                    sphereEditor = this.fichothequeInitEditor.createSphere(sphereKey);
                    if (tagName.equals("sphere")) {
                        SphereDOMReader sphereDOMReader = new SphereDOMReader(sphereEditor, this.messageHandler);
                        sphereDOMReader.fillSphere(document.getDocumentElement());
                        oldVersionList.add(sphereEditor.getSphere());
                    } else {
                        parseList = true;
                        SphereMetadataDOMReader sphereMetadataDOMReader = new SphereMetadataDOMReader(sphereEditor.getSphereMetadataEditor(), (MessageHandler)this.messageHandler);
                        sphereMetadataDOMReader.fillMetadata(root);
                    }
                    sphereEditorList.add(sphereEditor);
                }
                catch (ExistingSubsetException ese) {
                    throw new ImplementationException(ese);
                }
                if (!parseList || !(listStorageFile = BdfdataStorageFileCatalog.sphereList(this.bdfdataDirectory, sphereEditor.getSphere().getSubsetKey())).exists()) continue;
                this.setCurrentURI(listStorageFile);
                org.w3c.dom.Document listDocument = listStorageFile.readDocument();
                SphereListDOMReader sphereListDOMReader = new SphereListDOMReader(sphereEditor, (MessageHandler)this.messageHandler);
                sphereListDOMReader.fillSphere(listDocument.getDocumentElement());
            }
            for (SphereEditor sphereEditor : sphereEditorList) {
                sphereKey = sphereEditor.getSphere().getSubsetKey();
                RedacteurDOMReader redacteurDOMReader = new RedacteurDOMReader(sphereEditor, this.messageHandler);
                for (Redacteur redacteur : sphereEditor.getSphere().getRedacteurList()) {
                    StorageFile storageFile = BdfdataStorageFileCatalog.redacteur(this.bdfdataDirectory, sphereKey, redacteur.getId());
                    if (!storageFile.exists()) continue;
                    this.setCurrentURI(storageFile);
                    org.w3c.dom.Document document = storageFile.readDocument();
                    redacteurDOMReader.fillRedacteur(redacteur, document.getDocumentElement());
                }
            }
            if (!oldVersionList.isEmpty()) {
                for (Sphere sphere : oldVersionList) {
                    Save.saveSphereMetadata(this.bdfdataDirectory, sphere, null);
                    Save.saveSphereList(this.bdfdataDirectory, sphere, null);
                    for (Redacteur redacteur : sphere.getRedacteurList()) {
                        Save.saveRedacteur(this.bdfdataDirectory, redacteur, null);
                    }
                }
            }
        }

        private void initThesaurusList() {
            SubsetKey thesaurusKey;
            ArrayList<ThesaurusEditor> thesaurusEditorList = new ArrayList<ThesaurusEditor>();
            ArrayList<Thesaurus> oldVersionList = new ArrayList<Thesaurus>();
            SubsetInfoList infoList = BdfdataStorageFileCatalog.getSubsetInfoList(this.bdfdataDirectory, (short)2);
            int standardCount = infoList.getStandardSubsetCount();
            for (int i = 0; i < standardCount; ++i) {
                StorageFile treeStorageFile;
                ThesaurusEditor thesaurusEditor;
                SubsetInfo subsetInfo = infoList.getStandardSubsetInfo(i);
                thesaurusKey = subsetInfo.getSubsetKey();
                StorageFile storageFile = subsetInfo.getStorageFile();
                this.setCurrentURI(storageFile);
                org.w3c.dom.Document document = storageFile.readDocument();
                boolean parseTree = false;
                try {
                    Element root = document.getDocumentElement();
                    String tagName = root.getTagName();
                    String thesaurusType = ThesaurusMetadataDOMReader.getThesaurusType(root);
                    thesaurusEditor = this.fichothequeInitEditor.createThesaurus(thesaurusKey, thesaurusType);
                    if (tagName.equals("thesaurus")) {
                        ThesaurusDOMReader thesaurusDOMReader = new ThesaurusDOMReader(thesaurusEditor, this.messageHandler);
                        thesaurusDOMReader.fillThesaurus(root);
                        oldVersionList.add(thesaurusEditor.getThesaurus());
                    } else {
                        parseTree = true;
                        ThesaurusMetadataDOMReader thesaurusMetadataDOMReader = new ThesaurusMetadataDOMReader(thesaurusEditor.getThesaurusMetadataEditor(), (MessageHandler)this.messageHandler);
                        thesaurusMetadataDOMReader.fillMetadata(root);
                    }
                    thesaurusEditorList.add(thesaurusEditor);
                }
                catch (ExistingSubsetException ese) {
                    throw new ImplementationException(ese);
                }
                if (!parseTree || !(treeStorageFile = BdfdataStorageFileCatalog.thesaurusTree(this.bdfdataDirectory, thesaurusEditor.getThesaurus().getSubsetKey())).exists()) continue;
                this.setCurrentURI(treeStorageFile);
                org.w3c.dom.Document treeDocument = treeStorageFile.readDocument();
                ThesaurusTreeDOMReader thesaurusTreeDOMReader = new ThesaurusTreeDOMReader(thesaurusEditor, this.messageHandler);
                thesaurusTreeDOMReader.fillThesaurus(treeDocument.getDocumentElement());
            }
            for (ThesaurusEditor thesaurusEditor : thesaurusEditorList) {
                thesaurusKey = thesaurusEditor.getThesaurus().getSubsetKey();
                MotcleDOMReader motcleDOMReader = new MotcleDOMReader(thesaurusEditor, this.messageHandler);
                for (Motcle motcle : thesaurusEditor.getThesaurus().getMotcleList()) {
                    StorageFile motcleStorageFile = BdfdataStorageFileCatalog.motcle(this.bdfdataDirectory, thesaurusKey, motcle.getId());
                    if (!motcleStorageFile.exists()) continue;
                    this.setCurrentURI(motcleStorageFile);
                    org.w3c.dom.Document document = motcleStorageFile.readDocument();
                    motcleDOMReader.fillMotcle(motcle, document.getDocumentElement());
                }
            }
            if (!oldVersionList.isEmpty()) {
                for (Thesaurus thesaurus : oldVersionList) {
                    Save.saveThesaurusMetadata(this.bdfdataDirectory, thesaurus, null);
                    Save.saveThesaurusTree(this.bdfdataDirectory, thesaurus, null);
                    for (Motcle motcle : thesaurus.getMotcleList()) {
                        Save.saveMotcle(this.bdfdataDirectory, motcle, null);
                    }
                }
            }
        }

        private void initAlbumList() {
            SubsetInfoList infoList = BdfdataStorageFileCatalog.getSubsetInfoList(this.bdfdataDirectory, (short)5);
            ArrayList<Album> oldVersionList = new ArrayList<Album>();
            int standardCount = infoList.getStandardSubsetCount();
            for (int i = 0; i < standardCount; ++i) {
                SubsetInfo subsetInfo = infoList.getStandardSubsetInfo(i);
                SubsetKey albumKey = subsetInfo.getSubsetKey();
                StorageFile storageFile = subsetInfo.getStorageFile();
                this.setCurrentURI(storageFile);
                org.w3c.dom.Document document = storageFile.readDocument();
                try {
                    Element root = document.getDocumentElement();
                    AlbumEditor albumEditor = this.fichothequeInitEditor.createAlbum(albumKey);
                    String tagName = root.getTagName();
                    if (tagName.equals("album")) {
                        AlbumDOMReader albumDOMReader = new AlbumDOMReader(albumEditor, this.messageHandler);
                        albumDOMReader.fillAlbum(root);
                        oldVersionList.add(albumEditor.getAlbum());
                    } else {
                        AlbumMetadataDOMReader albumMetadataDOMReader = new AlbumMetadataDOMReader(albumEditor.getAlbumMetadataEditor(), (MessageHandler)this.messageHandler);
                        albumMetadataDOMReader.fillMetadata(root);
                    }
                    IllustrationDOMReader illustrationDOMReader = new IllustrationDOMReader(albumEditor, this.messageHandler);
                    List<IllustrationDirectory.IllustrationInfo> illustrationInfoList = IllustrationDirectory.getIllustrationInfoList(this.bdfdataDirectory, albumKey);
                    for (IllustrationDirectory.IllustrationInfo illustrationInfo : illustrationInfoList) {
                        StorageFile illustrationStorageFile;
                        Illustration illustration;
                        int illustrationId = illustrationInfo.getId();
                        try {
                            illustration = albumEditor.createIllustration(illustrationId, illustrationInfo.getType());
                        }
                        catch (ExistingIdException eie) {
                            throw new ImplementationException(eie);
                        }
                        try (FileInputStream is = new FileInputStream(illustrationInfo.getFile());){
                            albumEditor.updateIllustration(illustration, is, illustrationInfo.getType());
                        }
                        catch (IIOException iioe) {
                            this.messageHandler.setCurrentSource(illustrationInfo.getFile().getPath());
                            this.addMessage("IMAGE FORMAT", "_ error.exception.iio", iioe.getMessage());
                        }
                        catch (ErrorMessageException eme) {
                            this.messageHandler.setCurrentSource(illustrationInfo.getFile().getPath());
                            this.messageHandler.addMessage("IMAGE FORMAT", eme.getErrorMessage());
                        }
                        catch (IOException ioe) {
                            throw new BdfStorageException(ioe);
                        }
                        if (!(illustrationStorageFile = BdfdataStorageFileCatalog.illustration(this.bdfdataDirectory, albumKey, illustrationId)).exists()) continue;
                        this.setCurrentURI(illustrationStorageFile);
                        org.w3c.dom.Document xmlDocument = illustrationStorageFile.readDocument();
                        illustrationDOMReader.fillIllustration(illustration, xmlDocument.getDocumentElement());
                    }
                    continue;
                }
                catch (ExistingSubsetException ese) {
                    throw new ImplementationException(ese);
                }
            }
            if (!oldVersionList.isEmpty()) {
                for (Album album : oldVersionList) {
                    Save.saveAlbumMetadata(this.bdfdataDirectory, album, null);
                }
            }
        }

        private void initAddendaList() {
            SubsetInfoList infoList = BdfdataStorageFileCatalog.getSubsetInfoList(this.bdfdataDirectory, (short)4);
            int standardCount = infoList.getStandardSubsetCount();
            for (int i = 0; i < standardCount; ++i) {
                SubsetInfo subsetInfo = infoList.getStandardSubsetInfo(i);
                SubsetKey addendaKey = subsetInfo.getSubsetKey();
                StorageFile storageFile = subsetInfo.getStorageFile();
                this.setCurrentURI(storageFile);
                org.w3c.dom.Document document = storageFile.readDocument();
                try {
                    Element root = document.getDocumentElement();
                    AddendaEditor addendaEditor = this.fichothequeInitEditor.createAddenda(addendaKey);
                    AddendaMetadataDOMReader addendaMetadataDOMReader = new AddendaMetadataDOMReader(addendaEditor.getAddendaMetadataEditor(), (MessageHandler)this.messageHandler);
                    addendaMetadataDOMReader.fillMetadata(root);
                    DocumentDOMReader documentDOMReader = new DocumentDOMReader(addendaEditor, this.messageHandler);
                    List<DocumentDirectory.DocumentInfo> documentInfoList = DocumentDirectory.getDocumentInfoList(this.bdfdataDirectory, addendaKey);
                    for (DocumentDirectory.DocumentInfo documentInfo : documentInfoList) {
                        Document bdfDoc;
                        int documentid = documentInfo.getId();
                        try {
                            bdfDoc = addendaEditor.createDocument(documentid, documentInfo.getVersionInfoList());
                        }
                        catch (ExistingIdException eie) {
                            throw new ImplementationException(eie);
                        }
                        StorageFile documentStorageFile = BdfdataStorageFileCatalog.document(this.bdfdataDirectory, addendaKey, documentid);
                        if (!documentStorageFile.exists()) continue;
                        this.setCurrentURI(documentStorageFile);
                        org.w3c.dom.Document xmlDocument = documentStorageFile.readDocument();
                        documentDOMReader.fillDocument(bdfDoc, xmlDocument.getDocumentElement());
                    }
                    continue;
                }
                catch (ExistingSubsetException ese) {
                    throw new ImplementationException(ese);
                }
            }
        }

        private void initCorpusList() {
            SubsetInfoList infoList = BdfdataStorageFileCatalog.getSubsetInfoList(this.bdfdataDirectory, (short)1);
            int standardCount = infoList.getStandardSubsetCount();
            for (int i = 0; i < standardCount; ++i) {
                SubsetInfo subsetInfo = infoList.getStandardSubsetInfo(i);
                SubsetKey corpusKey = subsetInfo.getSubsetKey();
                StorageFile storageFile = subsetInfo.getStorageFile();
                this.setCurrentURI(storageFile);
                org.w3c.dom.Document document = storageFile.readDocument();
                try {
                    CorpusEditor corpusEditor = this.fichothequeInitEditor.createCorpus(corpusKey, null);
                    CorpusMetadataDOMReader domReader = new CorpusMetadataDOMReader(corpusEditor.getCorpusMetadataEditor(), (MessageHandler)this.messageHandler);
                    domReader.fillMetadata(document.getDocumentElement());
                    continue;
                }
                catch (ExistingSubsetException ese) {
                    throw new ImplementationException(ese);
                }
            }
            int satelliteCount = infoList.getSatelliteSubsetCount();
            for (int i = 0; i < satelliteCount; ++i) {
                SubsetInfo subsetInfo = infoList.getSatelliteSubsetInfo(i);
                SubsetKey corpusKey = subsetInfo.getSubsetKey();
                StorageFile storageFile = subsetInfo.getStorageFile();
                this.setCurrentURI(storageFile);
                if (this.fichotheque.containsSubset(corpusKey)) {
                    this.addMessage("severe.directorystorage.filename", "_ error.existing.corpus", corpusKey.getKeyString());
                    continue;
                }
                Subset masterSubset = this.fichotheque.getSubset(subsetInfo.getMasterSubsetKey());
                if (masterSubset == null) {
                    this.addMessage("severe.directorystorage.filename", "_ error.unknown.subset", subsetInfo.getMasterSubsetKey());
                    continue;
                }
                org.w3c.dom.Document document = storageFile.readDocument();
                try {
                    CorpusEditor corpusEditor = this.fichothequeInitEditor.createCorpus(corpusKey, masterSubset);
                    CorpusMetadataDOMReader domReader = new CorpusMetadataDOMReader(corpusEditor.getCorpusMetadataEditor(), (MessageHandler)this.messageHandler);
                    domReader.fillMetadata(document.getDocumentElement());
                    continue;
                }
                catch (ExistingSubsetException ese) {
                    throw new ImplementationException(ese);
                }
            }
        }

        private void initFiches() {
            ArrayList<Corpus> satelliteCorpus = new ArrayList<Corpus>();
            for (Corpus corpus : this.fichotheque.getCorpusList()) {
                if (corpus.getMasterSubset() != null) {
                    satelliteCorpus.add(corpus);
                    continue;
                }
                if (this.initFromJdbm) {
                    this.initFichesFromJdbm(corpus);
                    continue;
                }
                this.initFichesFromXml(corpus);
            }
            for (Corpus corpus : satelliteCorpus) {
                if (this.initFromJdbm) {
                    this.initFichesFromJdbm(corpus);
                    continue;
                }
                this.initFichesFromXml(corpus);
            }
        }

        private void initFichesFromJdbm(Corpus corpus) {
            CorpusEditor corpusInitEditor = this.fichothequeInitEditor.getCorpusEditor(corpus);
            FicheAttributesDOMReader attributesDOMReader = new FicheAttributesDOMReader(corpusInitEditor, this.messageHandler);
            for (EnteteFiche enteteFiche : this.fichothequeJdbm.getEnteteFicheArray(corpus)) {
                try {
                    FicheMeta ficheMeta = corpusInitEditor.createFiche(enteteFiche.getId());
                    corpusInitEditor.saveFiche(ficheMeta, enteteFiche.getFiche());
                    this.initChrono(corpusInitEditor, ficheMeta);
                    this.initAttributes(attributesDOMReader, ficheMeta);
                }
                catch (ExistingIdException | NoMasterIdException exception) {
                    // empty catch block
                }
            }
        }

        private void initFichesFromXml(Corpus corpus) {
            CorpusEditor corpusInitEditor = this.fichothequeInitEditor.getCorpusEditor(corpus);
            SubsetKey corpusKey = corpus.getSubsetKey();
            OldFicheDOMReader oldFicheDOMReader = new OldFicheDOMReader(this.fichotheque, this.htmlCleaner);
            FicheDOMReader ficheDOMReader = new FicheDOMReader(this.htmlCleaner);
            FicheAttributesDOMReader attributesDOMReader = new FicheAttributesDOMReader(corpusInitEditor, this.messageHandler);
            String corpusPath = "fichotheque" + File.separator + "corpus" + File.separator + corpusKey.getSubsetName();
            File corpusDirectory = this.bdfdataDirectory.getDataFile(corpusPath);
            if (!corpusDirectory.exists()) {
                corpusDirectory.mkdir();
                return;
            }
            TreeMap<Integer, File> sortedDir = new TreeMap<Integer, File>();
            for (File f : corpusDirectory.listFiles()) {
                String name = f.getName();
                if (!f.isDirectory() || !name.startsWith("f.")) continue;
                try {
                    int integer = Integer.parseInt(name.substring(2));
                    if (integer < 0) continue;
                    sortedDir.put(integer, f);
                }
                catch (NumberFormatException integer) {
                    // empty catch block
                }
            }
            for (File fDir : sortedDir.values()) {
                String name;
                String fPath = corpusPath + File.separator + fDir.getName();
                File[] list2 = fDir.listFiles();
                int length2 = list2.length;
                TreeSet<Integer> sortedSet = new TreeSet<Integer>();
                for (int j = 0; j < length2; ++j) {
                    String extension;
                    int idxpoint;
                    File ficheFile = list2[j];
                    name = ficheFile.getName();
                    if (ficheFile.isDirectory() || (idxpoint = name.indexOf(46)) == -1 || !(extension = name.substring(idxpoint + 1)).equals("xml")) continue;
                    try {
                        int ficheid = Integer.parseInt(name.substring(0, idxpoint));
                        StorageFile fsf = this.bdfdataDirectory.getStorageFile(fPath + File.separator + name);
                        this.setCurrentURI(fsf);
                        org.w3c.dom.Document document = fsf.readDocument();
                        Fiche fiche = oldFicheDOMReader.readFiche(document.getDocumentElement());
                        StorageFile storageFile = BdfdataStorageFileCatalog.fiche(this.bdfdataDirectory, corpusKey, ficheid);
                        try (BufferedWriter buf = storageFile.getWriter();){
                            AppendableXMLWriter xmlWriter = XMLUtils.toXMLWriter(buf);
                            xmlWriter.appendXMLDeclaration();
                            FicheStorageXMLPart ficheStorageXMLPart = new FicheStorageXMLPart(xmlWriter);
                            ficheStorageXMLPart.appendFiche(fiche);
                        }
                        catch (IOException ioe) {
                            throw new BdfStorageException(ioe);
                        }
                        fsf.delete();
                        continue;
                    }
                    catch (NumberFormatException ficheid) {
                        // empty catch block
                    }
                }
                for (File ficheDir : fDir.listFiles()) {
                    if (!ficheDir.isDirectory()) continue;
                    name = ficheDir.getName();
                    try {
                        int ficheid = Integer.parseInt(name);
                        sortedSet.add(ficheid);
                    }
                    catch (NumberFormatException ficheid) {
                        // empty catch block
                    }
                }
                Iterator iterator = sortedSet.iterator();
                while (iterator.hasNext()) {
                    int ficheid = (Integer)iterator.next();
                    StorageFile fsf = BdfdataStorageFileCatalog.fiche(this.bdfdataDirectory, corpusKey, ficheid);
                    this.setCurrentURI(fsf);
                    try {
                        FicheMeta ficheMeta = corpusInitEditor.createFiche(ficheid);
                        org.w3c.dom.Document document = fsf.readDocument();
                        Fiche fiche = ficheDOMReader.readFiche(document.getDocumentElement());
                        this.fichothequeJdbm.updateFiche(ficheMeta, fiche);
                        corpusInitEditor.saveFiche(ficheMeta, fiche);
                        this.initChrono(corpusInitEditor, ficheMeta);
                        this.initAttributes(attributesDOMReader, ficheMeta);
                    }
                    catch (ExistingIdException eie) {
                        this.addMessage("severe.directorystorage.filename", "_ error.existing.id", String.valueOf(ficheid));
                    }
                    catch (NoMasterIdException nmie) {
                        this.addMessage("severe.directorystorage.filename", "_ error.unknown.mastersubsetitem", String.valueOf(ficheid), corpus.getMasterSubset().getSubsetKeyString());
                    }
                }
            }
        }

        private void initJunction(Subset firstSubset, Subset secondSubset) {
            SubsetKey subsetKey2;
            SubsetKey subsetKey1 = firstSubset.getSubsetKey();
            StorageFile oldStorageFile = BdfdataStorageFileCatalog.getOldJunctionStorageFile(this.bdfdataDirectory, subsetKey1, subsetKey2 = secondSubset.getSubsetKey());
            if (oldStorageFile.exists()) {
                this.setCurrentURI(oldStorageFile);
                OldJunctionDOMReader junctionDOMReader = new OldJunctionDOMReader(this.messageHandler);
                org.w3c.dom.Document document = oldStorageFile.readDocument();
                junctionDOMReader.readJunction(this.fichothequeInitEditor.getJunctionEditor(), firstSubset, secondSubset, document.getDocumentElement());
                boolean same = subsetKey1.equals(subsetKey2);
                for (SubsetItem subsetItem : firstSubset.getSubsetItemList()) {
                    Junctions junctions = this.fichotheque.getJunctions(subsetItem, secondSubset);
                    for (Junctions.Entry entry : junctions.getEntryList()) {
                        SubsetItem otherSubsetItem;
                        Junction junction = entry.getJunction();
                        if (same && (otherSubsetItem = entry.getSubsetItem()).getId() < subsetItem.getId()) continue;
                        Save.saveJunction(this.bdfdataDirectory, junction, null);
                    }
                }
                oldStorageFile.delete();
                return;
            }
            StorageFile junctionDirectory = BdfdataStorageFileCatalog.junctionDirectory(this.bdfdataDirectory, subsetKey1, subsetKey2);
            if (!junctionDirectory.exists()) {
                return;
            }
            String path = junctionDirectory.getRelativePath();
            JunctionDOMReader junctionDOMReader = new JunctionDOMReader(this.fichothequeInitEditor.getJunctionEditor(), this.messageHandler);
            TreeMap<Long, File> sortedDir = new TreeMap<Long, File>();
            for (File f : junctionDirectory.getFile().listFiles()) {
                int idx;
                String name = f.getName();
                if (!f.isDirectory() || !name.startsWith("c.") || (idx = name.indexOf(95)) < 3) continue;
                try {
                    int plage1 = Integer.parseInt(name.substring(2, idx));
                    int plage2 = Integer.parseInt(name.substring(idx + 1));
                    if (plage1 < 0 || plage2 < 0) continue;
                    sortedDir.put(PrimUtils.toLong(plage1, plage2), f);
                }
                catch (NumberFormatException plage1) {
                    // empty catch block
                }
            }
            for (File cDir : sortedDir.values()) {
                String cPath = path + File.separator + cDir.getName();
                File[] subList = cDir.listFiles();
                TreeMap<Long, String> sortedFileName = new TreeMap<Long, String>();
                for (File junctionFile : subList) {
                    int idxtiret;
                    String extension;
                    String name;
                    int idxpoint;
                    if (junctionFile.isDirectory() || (idxpoint = (name = junctionFile.getName()).indexOf(46)) == -1 || !(extension = name.substring(idxpoint + 1)).equals("xml") || (idxtiret = name.indexOf(95)) == -1 || idxtiret > idxpoint || idxtiret == 0) continue;
                    try {
                        int id1 = Integer.parseInt(name.substring(0, idxtiret));
                        int id2 = Integer.parseInt(name.substring(idxtiret + 1, idxpoint));
                        long l = PrimUtils.toLong(id1, id2);
                        sortedFileName.put(l, name);
                    }
                    catch (NumberFormatException id1) {
                        // empty catch block
                    }
                }
                for (Map.Entry entry : sortedFileName.entrySet()) {
                    long l = (Long)entry.getKey();
                    int id1 = PrimUtils.getInt1(l);
                    int id2 = PrimUtils.getInt2(l);
                    String name = (String)entry.getValue();
                    StorageFile fsf = this.bdfdataDirectory.getStorageFile(cPath + File.separator + name);
                    this.setCurrentURI(fsf);
                    SubsetItem subsetItem1 = firstSubset.getSubsetItemById(id1);
                    SubsetItem subsetItem2 = secondSubset.getSubsetItemById(id2);
                    boolean ok = true;
                    if (subsetItem1 == null) {
                        this.addMessage("severe.directorystorage.filename", "_ error.unknown.id", id1);
                        ok = false;
                    }
                    if (subsetItem2 == null) {
                        this.addMessage("severe.directorystorage.filename", "_ error.unknown.id", id2);
                        ok = false;
                    }
                    if (!ok) continue;
                    org.w3c.dom.Document document = fsf.readDocument();
                    junctionDOMReader.readJunction(document.getDocumentElement(), subsetItem1, subsetItem2);
                }
            }
        }

        private void initChrono(CorpusEditor corpusInitEditor, FicheMeta ficheMeta) {
            block10: {
                StorageFile storageFile = BdfdataStorageFileCatalog.ficheChrono(this.bdfdataDirectory, ficheMeta.getSubsetKey(), ficheMeta.getId());
                if (!storageFile.exists()) {
                    return;
                }
                this.setCurrentURI(storageFile);
                File file = storageFile.getFile();
                try {
                    String modificationDateString;
                    String creationDateString;
                    String chronoString = FileUtils.readFileToString(file, "UTF-8");
                    int idx = chronoString.indexOf(10);
                    if (idx > 0) {
                        creationDateString = chronoString.substring(0, idx);
                        modificationDateString = chronoString.substring(idx + 1);
                    } else {
                        creationDateString = chronoString;
                        modificationDateString = "";
                    }
                    try {
                        FuzzyDate creationDate = FuzzyDate.parse(creationDateString);
                        corpusInitEditor.setDate(ficheMeta, creationDate, false);
                        if (modificationDateString.length() <= 0) break block10;
                        try {
                            FuzzyDate modificationDate = FuzzyDate.parse(modificationDateString);
                            if (modificationDate.compareTo(creationDate) > 0) {
                                corpusInitEditor.setDate(ficheMeta, modificationDate, true);
                            }
                        }
                        catch (ParseException pe2) {
                            this.addMessage("severe.date.format", "_ error.wrong.date", modificationDateString);
                        }
                    }
                    catch (ParseException pe1) {
                        this.addMessage("severe.date.format", "_ error.wrong.date", creationDateString);
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }

        private void initAttributes(FicheAttributesDOMReader attributesDOMReader, FicheMeta ficheMeta) {
            StorageFile storageFile = BdfdataStorageFileCatalog.ficheAttributes(this.bdfdataDirectory, ficheMeta.getSubsetKey(), ficheMeta.getId());
            if (!storageFile.exists()) {
                return;
            }
            this.setCurrentURI(storageFile);
            org.w3c.dom.Document document = storageFile.readDocument();
            attributesDOMReader.fillFicheMeta(ficheMeta, document.getDocumentElement());
        }

        private void addMessage(String category, String messageKey, Object ... messageValues) {
            this.messageHandler.addMessage(category, LocalisationUtils.toMessage(messageKey, messageValues));
        }
    }
}

