/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.multi.subscribe;

import fr.exemole.bdfserver.html.consumers.PageUnit;
import fr.exemole.bdfserver.multi.api.Multi;
import fr.exemole.bdfserver.multi.htmlproducers.MultiHtmlProducer;
import fr.exemole.bdfserver.multi.subscribe.SubscribeResult;
import net.mapeadores.util.html.HA;
import net.mapeadores.util.html.HtmlPrinter;
import net.mapeadores.util.html.HtmlPrinterUtils;
import net.mapeadores.util.logging.CommandMessage;

public class SubscribeMessageHtmlProducer
extends MultiHtmlProducer {
    private final SubscribeResult subscribeResult;
    private final CommandMessage commandMessage;

    public SubscribeMessageHtmlProducer(Multi multi, SubscribeResult subscribeResult, CommandMessage commandMessage) {
        super(multi);
        this.subscribeResult = subscribeResult;
        this.commandMessage = commandMessage;
        this.addThemeCss("multisubscribe.css");
    }

    public SubscribeMessageHtmlProducer(Multi multi, CommandMessage commandMessage) {
        this(multi, null, commandMessage);
    }

    public SubscribeMessageHtmlProducer(Multi multi, SubscribeResult subscribeResult) {
        this(multi, subscribeResult, null);
    }

    @Override
    public void printHtml() {
        this.startLoc("_ title.multi.subcribe");
        this.MAIN("multisubscribe-Main").__(PageUnit.start("action-Subscribe", "_ title.multi.subcribe")).__(this.printMessage()).__(this.printTokenWarning()).__(this.printSubscribeLink()).__(this.printFichothequeInfo()).__(PageUnit.END)._MAIN();
        this.end();
    }

    private boolean printMessage() {
        CommandMessage message = this.getMessage();
        if (message != null) {
            this.__(HtmlPrinterUtils.printCommandMessage((HtmlPrinter)this, message, "multisubscribe-Info", "global-ErrorMessage"));
            return true;
        }
        return false;
    }

    private boolean printTokenWarning() {
        CommandMessage message = this.getMessage();
        if (message == null) {
            return false;
        }
        if (message.isErrorMessage() && message.getMessageKey().contains("token")) {
            this.P("multisubscribe-TokenWarning").__localize("_ warning.subscribe.redosubcribe")._P();
            return true;
        }
        return false;
    }

    private boolean printSubscribeLink() {
        if (this.withFichothequeName()) {
            return false;
        }
        this.P("multisubscribe-Link").A(HA.href("multi-subscribe")).__localize("_ link.subscribe.backtosubcribe")._A()._P();
        return true;
    }

    private boolean printFichothequeInfo() {
        if (!this.withFichothequeName()) {
            return false;
        }
        String relativeUrl = this.subscribeResult.fichothequeName() + "/session";
        String absoluteUrl = this.subscribeResult.subscribeParameters().rootUrl() + relativeUrl;
        this.P("multisubscribe-Info").__localize("_ submit.subscribe.fichothequesubscribe")._P().P("multisubscribe-Info").__localize("_ label.subscribe.fichothequeurl").__colon()._P().P("multisubscribe-Code").CODE().__escape(absoluteUrl)._CODE()._P().P("multisubscribe-Link").A(HA.href(relativeUrl + "?" + "bdf-default-login" + "=" + this.subscribeResult.login())).__localize("_ link.subscribe.fichotheque")._A()._P();
        return true;
    }

    private CommandMessage getMessage() {
        if (this.commandMessage != null) {
            return this.commandMessage;
        }
        if (this.subscribeResult != null) {
            return this.subscribeResult.commandMessage();
        }
        return null;
    }

    private boolean withFichothequeName() {
        if (this.subscribeResult == null) {
            return false;
        }
        return this.subscribeResult.fichothequeName() != null;
    }
}

