/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.multi.streamproducers;

import fr.exemole.bdfserver.multi.api.Multi;
import fr.exemole.bdfserver.tools.BdfServerUtils;
import fr.exemole.bdfserver.tools.synthesis.Synthesis;
import fr.exemole.bdfserver.tools.synthesis.SynthesisOds;
import java.io.IOException;
import java.io.OutputStream;
import net.mapeadores.opendocument.io.odtable.OdsOptions;
import net.mapeadores.util.io.StreamProducer;
import net.mapeadores.util.text.RelativePath;

public class SynthesisOdsProducer
implements StreamProducer {
    private final Multi multi;
    private final Synthesis synthesis;

    public SynthesisOdsProducer(Multi multi, Synthesis synthesis) {
        this.multi = multi;
        this.synthesis = synthesis;
    }

    @Override
    public String getMimeType() {
        return "application/vnd.oasis.opendocument.spreadsheet";
    }

    @Override
    public String getCharset() {
        return null;
    }

    @Override
    public String getFileName() {
        return "synthesis.ods";
    }

    @Override
    public void writeStream(OutputStream outputStream) throws IOException {
        OdsOptions odsOptions = BdfServerUtils.buildOdsOptions(this.multi.getWebappsResourceStorages(), RelativePath.build("css/ods/synthesis.css"));
        SynthesisOds synthesisOds = new SynthesisOds(this.synthesis, odsOptions, this.multi.getAdminLang(), this.multi.getAdminMessageLocalisation());
        synthesisOds.write(outputStream);
    }
}

