/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.jsonproducers.main;

import fr.exemole.bdfserver.api.BdfServer;
import fr.exemole.bdfserver.api.users.BdfUser;
import java.io.IOException;
import java.text.DecimalFormatSymbols;
import java.util.Collection;
import java.util.List;
import net.fichotheque.Subset;
import net.fichotheque.SubsetItem;
import net.fichotheque.corpus.Corpus;
import net.fichotheque.corpus.Fiches;
import net.fichotheque.exportation.table.ColDef;
import net.fichotheque.exportation.table.SubsetTable;
import net.fichotheque.exportation.table.SumCellConverter;
import net.fichotheque.exportation.table.SumResult;
import net.fichotheque.exportation.table.TableExportContext;
import net.fichotheque.thesaurus.Thesaurus;
import net.fichotheque.tools.exportation.table.TableExportEngine;
import net.fichotheque.utils.CorpusUtils;
import net.fichotheque.utils.FichothequeUtils;
import net.fichotheque.utils.TableDefUtils;
import net.fichotheque.utils.ThesaurusUtils;
import net.mapeadores.util.exceptions.NestedIOException;
import net.mapeadores.util.exceptions.SwitchException;
import net.mapeadores.util.json.JSONWriter;
import net.mapeadores.util.json.JsonProperty;
import net.mapeadores.util.localisation.Lang;
import net.mapeadores.util.money.Amount;
import net.mapeadores.util.primitives.Decimal;
import net.mapeadores.util.primitives.FuzzyDate;
import net.mapeadores.util.table.TableWriter;

public class TableJsonProperty
implements JsonProperty {
    private final BdfServer bdfServer;
    private final BdfUser bdfUser;
    private final SubsetTable subsetTable;
    private final TableExportContext tableExportContext;
    private final SumCellConverter sumCellConverter;

    public TableJsonProperty(BdfServer bdfServer, BdfUser bdfUser, SubsetTable subsetTable, TableExportContext tableExportContext, SumCellConverter cellConverter) {
        this.bdfServer = bdfServer;
        this.bdfUser = bdfUser;
        this.subsetTable = subsetTable;
        this.tableExportContext = tableExportContext;
        this.sumCellConverter = cellConverter;
    }

    @Override
    public String getName() {
        return "table";
    }

    @Override
    public void writeValue(JSONWriter jw) throws IOException {
        DecimalFormatSymbols symbols = new DecimalFormatSymbols(this.bdfUser.getFormatLocale());
        Subset subset = this.subsetTable.getSubset();
        Collection<SubsetItem> subsetItems = this.getSubsetItems(subset);
        Lang workingLang = this.bdfUser.getWorkingLang();
        List<ColDef> colDefList = this.subsetTable.getColDefList();
        int colCount = colDefList.size();
        boolean[] hiddenArray = new boolean[colCount];
        jw.object();
        jw.key("coldef");
        jw.array();
        for (int j = 0; j < colCount; ++j) {
            ColDef colDef = colDefList.get(j);
            if (colDef.isFormula()) {
                hiddenArray[j] = true;
                continue;
            }
            hiddenArray[j] = false;
            jw.object();
            jw.key("name").value(colDef.getColName());
            jw.key("title").value(TableDefUtils.getColTitle(colDef, workingLang, this.tableExportContext.getSourceLabelProvider(), subset));
            jw.endObject();
        }
        jw.endArray();
        jw.key("data");
        jw.array();
        JsonTableWriter jsonTableWriter = new JsonTableWriter(jw, symbols, hiddenArray);
        TableExportEngine.exportSubset(this.subsetTable, jsonTableWriter, this.sumCellConverter, subsetItems);
        SumResult sumResult = this.sumCellConverter.getSumResult(this.subsetTable);
        jw.endArray();
        if (sumResult.hasColumnSum()) {
            List<SumResult.Entry> entryList = sumResult.getEntryList();
            jw.key("sum");
            jw.array();
            for (int j = 0; j < colCount; ++j) {
                if (hiddenArray[j]) continue;
                SumResult.ColumnSum columnSum = entryList.get(j).getColumnSum();
                if (columnSum != null) {
                    if (columnSum instanceof SumResult.IntegerColumnSum) {
                        TableJsonProperty.writeIntegerObject(jw, ((SumResult.IntegerColumnSum)columnSum).getResult());
                        continue;
                    }
                    if (columnSum instanceof SumResult.DecimalColumnSum) {
                        TableJsonProperty.writeDecimalObject(jw, ((SumResult.DecimalColumnSum)columnSum).getResult());
                        continue;
                    }
                    if (columnSum instanceof SumResult.PercentageColumnSum) {
                        TableJsonProperty.writePercentageObject(jw, ((SumResult.PercentageColumnSum)columnSum).getResult());
                        continue;
                    }
                    if (columnSum instanceof SumResult.MoneyColumnSum) {
                        jw.object();
                        SumResult.MoneyColumnSum moneyColumnSum = (SumResult.MoneyColumnSum)columnSum;
                        int resultCount = moneyColumnSum.getResultCount();
                        jw.key("moneyArray");
                        jw.array();
                        for (int k = 0; k < resultCount; ++k) {
                            Amount resultAmount = moneyColumnSum.getResult(k);
                            TableJsonProperty.writeAmountObject(jw, resultAmount, symbols);
                        }
                        jw.endArray();
                        jw.endObject();
                        continue;
                    }
                    jw.value(false);
                    continue;
                }
                jw.value(false);
            }
            jw.endArray();
        }
        jw.endObject();
    }

    private Collection<SubsetItem> getSubsetItems(Subset subset) {
        if (subset instanceof Corpus) {
            Fiches fiches = this.bdfUser.getSelectedFiches();
            return CorpusUtils.getFicheMetaListByCorpus(fiches, subset.getSubsetKey());
        }
        if (subset instanceof Thesaurus) {
            Thesaurus thesaurus = (Thesaurus)subset;
            if (thesaurus == null || thesaurus.size() == 0) {
                return FichothequeUtils.EMPTY_SUBSETITEMLIST;
            }
            return ThesaurusUtils.toSubsetItemList(thesaurus, -1);
        }
        throw new SwitchException("Unknown subset: " + subset.getSubsetKeyString());
    }

    private static void writeAmountObject(JSONWriter jw, Amount amount, DecimalFormatSymbols symbols) throws IOException {
        jw.object();
        jw.key("currency").value(amount.getCurrencyCode());
        jw.key("value").value(amount.toDecimal(true));
        jw.key("text").value(amount.toLitteralString(symbols, false));
        jw.endObject();
    }

    private static void writeIntegerObject(JSONWriter jw, long value) throws IOException {
        jw.object();
        jw.key("integer").value(value);
        jw.endObject();
    }

    private static void writeDecimalObject(JSONWriter jw, Decimal decimal) throws IOException {
        jw.object();
        jw.key("decimal").value(decimal);
        jw.endObject();
    }

    private static void writePercentageObject(JSONWriter jw, Decimal decimal) throws IOException {
        jw.object();
        jw.key("decimal").value(decimal);
        jw.endObject();
    }

    private static class JsonTableWriter
    implements TableWriter {
        private final JSONWriter jw;
        private final DecimalFormatSymbols symbols;
        private final boolean[] hiddenArray;
        private int rowNumber;
        private int columnNumber;

        private JsonTableWriter(JSONWriter jw, DecimalFormatSymbols symbols, boolean[] hiddenArray) {
            this.jw = jw;
            this.symbols = symbols;
            this.rowNumber = 0;
            this.hiddenArray = hiddenArray;
        }

        @Override
        public int startRow() {
            ++this.rowNumber;
            try {
                this.jw.array();
            }
            catch (IOException ioe) {
                throw new NestedIOException(ioe);
            }
            this.columnNumber = 0;
            return this.rowNumber;
        }

        @Override
        public int addIntegerCell(Long lg) {
            ++this.columnNumber;
            if (this.isCurrentHidden()) {
                return this.columnNumber;
            }
            try {
                if (lg == null) {
                    this.jw.value("");
                } else {
                    TableJsonProperty.writeIntegerObject(this.jw, lg);
                }
            }
            catch (IOException ioe) {
                throw new NestedIOException(ioe);
            }
            return this.columnNumber;
        }

        @Override
        public int addDecimalCell(Decimal decimal) {
            ++this.columnNumber;
            if (this.isCurrentHidden()) {
                return this.columnNumber;
            }
            try {
                if (decimal == null) {
                    this.jw.value("");
                } else {
                    TableJsonProperty.writeDecimalObject(this.jw, decimal);
                }
            }
            catch (IOException ioe) {
                throw new NestedIOException(ioe);
            }
            return this.columnNumber;
        }

        @Override
        public int addStringCell(String s) {
            ++this.columnNumber;
            if (this.isCurrentHidden()) {
                return this.columnNumber;
            }
            try {
                if (s == null) {
                    this.jw.value("");
                } else {
                    this.jw.value(s);
                }
            }
            catch (IOException ioe) {
                throw new NestedIOException(ioe);
            }
            return this.columnNumber;
        }

        @Override
        public int addDateCell(FuzzyDate date) {
            ++this.columnNumber;
            if (this.isCurrentHidden()) {
                return this.columnNumber;
            }
            try {
                if (date == null) {
                    this.jw.value("");
                } else {
                    this.jw.value(date.toISOString());
                }
            }
            catch (IOException ioe) {
                throw new NestedIOException(ioe);
            }
            return this.columnNumber;
        }

        @Override
        public int addMoneyCell(Amount amount) {
            ++this.columnNumber;
            if (this.isCurrentHidden()) {
                return this.columnNumber;
            }
            try {
                if (amount == null) {
                    this.jw.value("");
                } else {
                    TableJsonProperty.writeAmountObject(this.jw, amount, this.symbols);
                }
            }
            catch (IOException ioe) {
                throw new NestedIOException(ioe);
            }
            return this.columnNumber;
        }

        @Override
        public int addPercentageCell(Decimal decimal) {
            ++this.columnNumber;
            if (this.isCurrentHidden()) {
                return this.columnNumber;
            }
            try {
                if (decimal == null) {
                    this.jw.value("");
                } else {
                    TableJsonProperty.writePercentageObject(this.jw, decimal);
                }
            }
            catch (IOException ioe) {
                throw new NestedIOException(ioe);
            }
            return this.columnNumber;
        }

        @Override
        public int endRow() {
            try {
                this.jw.endArray();
            }
            catch (IOException ioe) {
                throw new NestedIOException(ioe);
            }
            return this.rowNumber;
        }

        private boolean isCurrentHidden() {
            return this.hiddenArray[this.columnNumber - 1];
        }
    }
}

