/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.jsonproducers.addenda;

import fr.exemole.bdfserver.api.BdfServer;
import fr.exemole.bdfserver.api.instruction.BdfParameters;
import fr.exemole.bdfserver.api.users.BdfUser;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.fichotheque.Fichotheque;
import net.fichotheque.SubsetKey;
import net.fichotheque.addenda.Addenda;
import net.fichotheque.addenda.Document;
import net.fichotheque.corpus.Corpus;
import net.fichotheque.corpus.FicheMeta;
import net.fichotheque.json.DocumentJson;
import net.fichotheque.junction.Junctions;
import net.fichotheque.permission.PermissionEntry;
import net.fichotheque.permission.PermissionSummary;
import net.fichotheque.tools.permission.ListFilterEngine;
import net.fichotheque.utils.CorpusMetadataUtils;
import net.fichotheque.utils.FichothequeUtils;
import net.mapeadores.util.json.JSONWriter;
import net.mapeadores.util.json.JsonProducer;
import net.mapeadores.util.json.JsonUtils;

public class DocumentArrayJsonProducer
implements JsonProducer {
    private final BdfServer bdfServer;
    private final BdfUser bdfUser;
    private final Addenda addenda;
    private final PermissionSummary permissionSummary;
    private final List<PermissionEntry> permissionEntryList;

    public DocumentArrayJsonProducer(BdfParameters bdfParameters, Addenda addenda) {
        this.bdfServer = bdfParameters.getBdfServer();
        this.bdfUser = bdfParameters.getBdfUser();
        this.addenda = addenda;
        this.permissionSummary = bdfParameters.getPermissionSummary();
        this.permissionEntryList = ListFilterEngine.filter(addenda, addenda.getSubsetItemList(), this.permissionSummary);
    }

    @Override
    public void writeJson(Appendable appendable) throws IOException {
        JSONWriter jw = new JSONWriter(appendable);
        Fichotheque fichotheque = this.bdfServer.getFichotheque();
        Corpus[] corpusArray = FichothequeUtils.toCorpusArray(this.bdfServer.getFichotheque(), this.permissionSummary.getSubsetAccessPredicate());
        int corpusCount = corpusArray.length;
        Map[] mapArray = new Map[corpusCount];
        for (int i = 0; i < corpusCount; ++i) {
            mapArray[i] = new HashMap();
        }
        jw.object();
        jw.key("documentArray");
        jw.array();
        for (PermissionEntry permissionEntry : this.permissionEntryList) {
            Document document = (Document)permissionEntry.getSubsetItem();
            boolean editable = permissionEntry.isEditable();
            jw.object();
            DocumentJson.properties(jw, document, this.bdfUser, JsonUtils.ALL_ELIGIBILITY);
            jw.key("editable").value(editable);
            int ficheCount = 0;
            if (corpusCount > 0) {
                boolean here = false;
                for (int j = 0; j < corpusCount; ++j) {
                    Corpus corpus = corpusArray[j];
                    Junctions ficheJunctions = fichotheque.getJunctions(document, corpus);
                    if (ficheJunctions.isEmpty()) continue;
                    if (!here) {
                        here = true;
                        jw.key("corpusMap");
                        jw.object();
                    }
                    Map map = mapArray[j];
                    SubsetKey corpusKey = corpus.getSubsetKey();
                    jw.key(corpusKey.getSubsetName());
                    jw.array();
                    for (Junctions.Entry entry : ficheJunctions.getEntryList()) {
                        FicheMeta ficheMeta = (FicheMeta)entry.getSubsetItem();
                        jw.value(ficheMeta.getId());
                        ++ficheCount;
                        map.put(ficheMeta.getId(), ficheMeta);
                    }
                    jw.endArray();
                }
                if (here) {
                    jw.endObject();
                }
            }
            jw.key("ficheCount").value(ficheCount);
            jw.endObject();
        }
        jw.endArray();
        jw.key("corpusMap");
        jw.object();
        for (int i = 0; i < corpusCount; ++i) {
            Map map = mapArray[i];
            if (map.isEmpty()) continue;
            jw.key(corpusArray[i].getSubsetName());
            jw.object();
            for (FicheMeta ficheMeta : map.values()) {
                jw.key(String.valueOf(ficheMeta.getId()));
                jw.object();
                jw.key("title").value(CorpusMetadataUtils.getFicheTitle(ficheMeta, this.bdfUser.getWorkingLang(), this.bdfUser.getFormatLocale()));
                jw.endObject();
            }
            jw.endObject();
        }
        jw.endObject();
        jw.endObject();
    }
}

