/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.htmlproducers.main;

import fr.exemole.bdfserver.api.instruction.BdfParameters;
import fr.exemole.bdfserver.api.subsettree.GroupNode;
import fr.exemole.bdfserver.api.subsettree.SubsetNode;
import fr.exemole.bdfserver.api.subsettree.SubsetTree;
import fr.exemole.bdfserver.html.BdfHtmlUtils;
import fr.exemole.bdfserver.html.BdfServerHtmlProducer;
import fr.exemole.bdfserver.html.consumers.Button;
import fr.exemole.bdfserver.html.consumers.SubsetIcon;
import fr.exemole.bdfserver.html.consumers.Tree;
import fr.exemole.bdfserver.html.consumers.attributes.Deploy;
import fr.exemole.bdfserver.html.jslib.BdfJsLibs;
import fr.exemole.bdfserver.tools.BH;
import fr.exemole.bdfserver.tools.subsettree.TreeFilterEngine;
import fr.exemole.bdfserver.tools.subsettree.TreeUtils;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import net.fichotheque.Subset;
import net.fichotheque.SubsetKey;
import net.fichotheque.corpus.Corpus;
import net.fichotheque.permission.PermissionSummary;
import net.fichotheque.thesaurus.Thesaurus;
import net.fichotheque.utils.FichothequeUtils;
import net.mapeadores.util.html.HA;
import net.mapeadores.util.html.HtmlAttributes;
import net.mapeadores.util.html.HtmlPrinter;
import net.mapeadores.util.html.HtmlWrapper;
import net.mapeadores.util.text.Label;

public class CollectionsHtmlProducer
extends BdfServerHtmlProducer {
    private static final HtmlWrapper GROUP_BRANCH = Tree.branch("collections-Branch");
    private static final HtmlWrapper TREE = Tree.tree("collections-Tree");
    private static final HtmlWrapper SUBSET_LEAF = Tree.leaf("collections-SubsetLeaf");
    private final PermissionSummary permissionSummary;
    private final boolean isFichothequeAdmin;
    private final Button isoButton = Button.link();

    public CollectionsHtmlProducer(BdfParameters bdfParameters) {
        super(bdfParameters);
        this.permissionSummary = bdfParameters.getPermissionSummary();
        this.isFichothequeAdmin = this.permissionSummary.isFichothequeAdmin();
        this.addThemeCss("collections.css");
        this.addJsLib(BdfJsLibs.DEPLOY);
        this.setMainStorageKey("main", "collections");
    }

    @Override
    public void printHtml() {
        this.start();
        this.__(this.printCorpusCategory()).__(this.printThesaurusCategory()).__(this.printSphereCategory()).__(this.printAlbumCategory()).__(this.printAddendaCategory()).__(this.printIso());
        this.end();
    }

    private boolean printCorpusCategory() {
        SubsetTree subsetTree = TreeFilterEngine.admin(this.permissionSummary, this.bdfServer.getTreeManager().getSubsetTree((short)1));
        int size = TreeUtils.size(subsetTree);
        if (size == 0 && !this.isFichothequeAdmin) {
            return false;
        }
        String unitId = "unit_corpus";
        this.DETAILS(HA.id(unitId).classes("unit-Unit").populate(Deploy.DETAILS)).SUMMARY("collections-category-Summary family-CRP family-Colors").__(this.printEntryTitle((short)1, size)).__(this.isFichothequeAdmin ? this.printButton("action-New", BH.domain("corpus").page("corpus-creationform"), "_ CRP-01") : false)._SUMMARY().DIV("unit-Body").__(new CollectionTree(subsetTree, unitId))._DIV()._DETAILS();
        return true;
    }

    private boolean printThesaurusCategory() {
        SubsetTree subsetTree = TreeFilterEngine.read(this.permissionSummary, this.bdfServer.getTreeManager().getSubsetTree((short)2));
        int size = TreeUtils.size(subsetTree);
        if (size == 0 && !this.isFichothequeAdmin) {
            return false;
        }
        String unitId = "unit_thesaurus";
        this.DETAILS(HA.id(unitId).classes("unit-Unit").populate(Deploy.DETAILS)).SUMMARY("collections-category-Summary family-THS family-Colors").__(this.printEntryTitle((short)2, size)).__(this.isFichothequeAdmin ? this.printButton("action-New", BH.domain("thesaurus").page("thesaurus-creationform"), "_ THS-01") : false)._SUMMARY().DIV("unit-Body").__(new CollectionTree(subsetTree, unitId))._DIV()._DETAILS();
        return true;
    }

    private boolean printSphereCategory() {
        SubsetTree subsetTree = TreeFilterEngine.read(this.permissionSummary, this.bdfServer.getTreeManager().getSubsetTree((short)3));
        int size = TreeUtils.size(subsetTree);
        if (size == 0 && !this.isFichothequeAdmin) {
            return false;
        }
        String unitId = "unit_sphere";
        this.DETAILS(HA.id(unitId).classes("unit-Unit").populate(Deploy.DETAILS)).SUMMARY("collections-category-Summary family-SPH family-Colors").__(this.printEntryTitle((short)3, size)).__(this.isFichothequeAdmin ? this.printButton("action-New", BH.domain("sphere").page("sphere-creationform"), "_ SPH-01") : false)._SUMMARY().DIV("unit-Body").__(new CollectionTree(subsetTree, unitId))._DIV()._DETAILS();
        return true;
    }

    private boolean printAlbumCategory() {
        SubsetTree subsetTree = TreeFilterEngine.read(this.permissionSummary, this.bdfServer.getTreeManager().getSubsetTree((short)5));
        int size = TreeUtils.size(subsetTree);
        if (size == 0 && !this.isFichothequeAdmin) {
            return false;
        }
        String unitId = "unit_album";
        this.DETAILS(HA.id(unitId).classes("unit-Unit").populate(Deploy.DETAILS)).SUMMARY("collections-category-Summary family-ALB family-Colors").__(this.printEntryTitle((short)5, size)).__(this.isFichothequeAdmin ? this.printButton("action-New", BH.domain("album").page("album-creationform"), "_ ALB-01") : false)._SUMMARY().DIV("unit-Body").__(new CollectionTree(subsetTree, unitId))._DIV()._DETAILS();
        return true;
    }

    private boolean printAddendaCategory() {
        SubsetTree subsetTree = TreeFilterEngine.read(this.permissionSummary, this.bdfServer.getTreeManager().getSubsetTree((short)4));
        int size = TreeUtils.size(subsetTree);
        if (size == 0 && !this.isFichothequeAdmin) {
            return false;
        }
        String unitId = "unit_addenda";
        this.DETAILS(HA.id(unitId).classes("unit-Unit").populate(Deploy.DETAILS)).SUMMARY("collections-category-Summary family-ADD family-Colors").__(this.printEntryTitle((short)4, size)).__(this.isFichothequeAdmin ? this.printButton("action-New", BH.domain("addenda").page("addenda-creationform"), "_ ADD-01") : false)._SUMMARY().DIV("unit-Body").__(new CollectionTree(subsetTree, unitId))._DIV()._DETAILS();
        return true;
    }

    private boolean printIso() {
        String isoId = "unit_iso";
        this.DETAILS(HA.id(isoId).classes("collections-iso-Unit").populate(Deploy.DETAILS)).SUMMARY("collections-iso-Head").__(SubsetIcon.ISO).SPAN("collections-category-Title").__localize("_ title.global.iso_collection")._SPAN()._SUMMARY().DIV("collections-iso-Body").__(this.isoLink("action-List_Lang", "iso-languages", "_ title.misc.lang_list")).__(this.isoLink("action-List_Country", "iso-countries", "_ title.misc.country_list"))._DIV()._DETAILS();
        return true;
    }

    private boolean printEntryTitle(short subsetCategory, int size) {
        this.__(SubsetIcon.getIcon(subsetCategory)).SPAN("collections-category-Title").__localize(BdfHtmlUtils.getSubsetCollectionLocKey(subsetCategory)).__space().__(BdfHtmlUtils.printItemCount(this, this.bdfUser, size))._SPAN();
        return true;
    }

    private boolean printButton(String action, CharSequence href, String titleLocKey) {
        this.SPAN(action).A(HA.href(href).target("Edition").titleLocKey(titleLocKey).classes("global-button-Transparent global-button-Icon"))._A()._SPAN();
        return true;
    }

    private Button isoLink(String action, String page, String messageKey) {
        String href = BH.domain("misc").page(page).toString();
        return this.isoButton.href(href).action(action).textL10nObject(messageKey);
    }

    private class CollectionTree
    implements Consumer<HtmlPrinter> {
        private final String deployPrefix;
        private final SubsetTree subsetTree;
        private final GroupBranch groupBranch = new GroupBranch();
        private final SubsetLi subsetLi = new SubsetLi();

        private CollectionTree(SubsetTree subsetTree, String deployPrefix) {
            this.subsetTree = subsetTree;
            this.deployPrefix = deployPrefix;
        }

        @Override
        public void accept(HtmlPrinter hp) {
            hp.__(TREE, () -> {
                for (SubsetTree.Node node : this.subsetTree.getNodeList()) {
                    if (node instanceof SubsetNode) {
                        this.printSubsetNode(hp, (SubsetNode)node);
                        continue;
                    }
                    if (!(node instanceof GroupNode)) continue;
                    hp.__(this.groupBranch, node);
                }
            });
        }

        private boolean printSubsetNode(HtmlPrinter hp, SubsetNode subsetNode) {
            Subset subset = CollectionsHtmlProducer.this.fichotheque.getSubset(subsetNode.getSubsetKey());
            if (subset == null) {
                return false;
            }
            hp.__(this.subsetLi, subset);
            return true;
        }

        private class GroupBranch
        implements BiConsumer<HtmlPrinter, Object> {
            private GroupBranch() {
            }

            @Override
            public void accept(HtmlPrinter hp, Object object) {
                GroupNode groupNode = (GroupNode)object;
                String groupId = CollectionTree.this.deployPrefix + "-" + groupNode.getName();
                hp.__(Tree.NODE, () -> hp.DETAILS(HA.id(groupId).classes("collections-Group").populate(Deploy.DETAILS)).SUMMARY().__escape(TreeUtils.getTitle(CollectionsHtmlProducer.this.bdfServer, groupNode, CollectionsHtmlProducer.this.workingLang))._SUMMARY().__(GROUP_BRANCH, () -> {
                    for (SubsetTree.Node subnode : groupNode.getSubnodeList()) {
                        if (subnode instanceof SubsetNode) {
                            CollectionTree.this.printSubsetNode(hp, (SubsetNode)subnode);
                            continue;
                        }
                        if (!(subnode instanceof GroupNode)) continue;
                        hp.__(this, subnode);
                    }
                }));
            }
        }

        private class SubsetLi
        implements BiConsumer<HtmlPrinter, Object> {
            private SubsetLi() {
            }

            @Override
            public void accept(HtmlPrinter hp, Object object) {
                Subset subset = (Subset)object;
                short category = subset.getSubsetKey().getCategory();
                hp.__(SUBSET_LEAF, () -> {
                    Corpus corpus;
                    Subset masterSubset;
                    hp.__(this.printSubsetLink(hp, subset, category));
                    if (category == 1 && (masterSubset = (corpus = (Corpus)subset).getMasterSubset()) != null) {
                        String masterTitle = CollectionsHtmlProducer.this.permissionSummary.isSubsetAdmin(masterSubset.getSubsetKey()) ? FichothequeUtils.getTitleWithKey(masterSubset, CollectionsHtmlProducer.this.workingLang) : FichothequeUtils.getTitle(masterSubset, CollectionsHtmlProducer.this.workingLang);
                        String locKey = masterSubset instanceof Thesaurus ? "_ info.corpus.thesaurusmaster" : "_ info.corpus.corpusmaster";
                        hp.DIV("collections-MasterInfo").__localize(locKey, masterTitle)._DIV();
                    }
                });
            }

            private boolean printSubsetLink(HtmlPrinter hp, Subset currentSubset, short currentCategory) {
                HtmlAttributes attr = HA.href(BH.domain(BdfHtmlUtils.getDomain(currentCategory)).subset(currentSubset).page(BdfHtmlUtils.getPage(currentCategory))).classes("collections-SubsetLink");
                SubsetKey subsetKey = currentSubset.getSubsetKey();
                if (subsetKey.isSphereSubset() || CollectionsHtmlProducer.this.permissionSummary.isSubsetAdmin(subsetKey)) {
                    Label label = FichothequeUtils.getTitleLabel(currentSubset, CollectionsHtmlProducer.this.workingLang);
                    if (label != null) {
                        hp.A(attr).__(SubsetIcon.getIcon(currentCategory)).__escape(label.getLabelString()).__space().SPAN("collections-SubsetKey").__escape("[").__escape(subsetKey.getSubsetName()).__escape("]")._SPAN().__space().__(BdfHtmlUtils.printItemCount(hp, CollectionsHtmlProducer.this.bdfUser, currentSubset.size()))._A();
                    } else {
                        hp.A(attr).__(SubsetIcon.getIcon(currentCategory)).__escape("[").__escape(subsetKey.getSubsetName()).__escape("]").__space().__(BdfHtmlUtils.printItemCount(hp, CollectionsHtmlProducer.this.bdfUser, currentSubset.size()))._A();
                    }
                } else {
                    hp.A(attr).__(SubsetIcon.getIcon(currentCategory)).__escape(FichothequeUtils.getTitle(currentSubset, CollectionsHtmlProducer.this.workingLang)).__space().__(BdfHtmlUtils.printItemCount(hp, CollectionsHtmlProducer.this.bdfUser, currentSubset.size()))._A();
                }
                return true;
            }
        }
    }
}

