/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.htmlproducers.corpus;

import fr.exemole.bdfserver.api.instruction.BdfParameters;
import fr.exemole.bdfserver.html.BdfHtmlUtils;
import fr.exemole.bdfserver.html.BdfServerHtmlProducer;
import fr.exemole.bdfserver.html.consumers.Grid;
import fr.exemole.bdfserver.html.jslib.BdfJsLibs;
import fr.exemole.bdfserver.htmlproducers.CommandBoxUtils;
import fr.exemole.bdfserver.htmlproducers.corpus.CorpusHtmlUtils;
import java.util.ArrayList;
import java.util.List;
import net.fichotheque.SubsetKey;
import net.fichotheque.corpus.Corpus;
import net.fichotheque.corpus.metadata.CorpusField;
import net.fichotheque.corpus.metadata.CorpusMetadata;
import net.fichotheque.corpus.metadata.FieldKey;
import net.fichotheque.sphere.Sphere;
import net.fichotheque.utils.CorpusMetadataUtils;
import net.fichotheque.utils.FichothequeUtils;
import net.fichotheque.utils.FieldOptionUtils;
import net.mapeadores.util.html.CommandBox;
import net.mapeadores.util.html.HtmlPrinter;
import net.mapeadores.util.localisation.Lang;
import net.mapeadores.util.localisation.Langs;
import net.mapeadores.util.money.Currencies;
import net.mapeadores.util.money.ExtendedCurrency;
import net.mapeadores.util.text.MultiStringable;

public class FieldOptionsFormHtmlProducer
extends BdfServerHtmlProducer {
    private final Corpus corpus;
    private final List<CorpusField> geopointFieldList = new ArrayList<CorpusField>();

    public FieldOptionsFormHtmlProducer(BdfParameters bdfParameters, Corpus corpus) {
        super(bdfParameters);
        this.corpus = corpus;
        this.addJsLib(BdfJsLibs.COMMANDTEST);
        this.addJsLib(BdfJsLibs.COMMANDVEIL);
        this.addJsLib(BdfJsLibs.SUBSETCHANGE);
        this.addJsLib(BdfJsLibs.DEPLOY);
        this.addJsLib(BdfJsLibs.CODEMIRRORMODE);
        this.addThemeCss("corpus.css");
    }

    @Override
    public void printHtml() {
        CorpusMetadata corpusMetadata = this.corpus.getCorpusMetadata();
        this.start();
        BdfHtmlUtils.printSubsetHeader(this, this.bdfParameters, this.corpus, "field-optionsform");
        CorpusHtmlUtils.printCorpusToolbar(this, this.corpus, "field-optionsform", this.bdfServer);
        this.printCommandMessageUnit();
        CommandBox commandBox = CommandBox.init().action("corpus").family("CRP").veil(true).__(CommandBoxUtils.insert(this.corpus)).name("FieldOptions").lockey("_ CRP-07").page("field-optionsform").submitLocKey("_ submit.corpus.fieldoptions");
        this.__start(commandBox).__(this.printCorpusFieldOptions(corpusMetadata.getPropList(), "_ title.corpus.options_prop")).__(this.printCorpusFieldOptions(corpusMetadata.getInfoList(), "_ title.corpus.options_info")).__(this.printFicheOptions(corpusMetadata)).__end(commandBox);
        this.end();
    }

    private boolean printCorpusFieldOptions(List<CorpusField> list, String titleLocKey) {
        if (list.isEmpty()) {
            return false;
        }
        this.H2().__localize(titleLocKey)._H2().DL("global-DL");
        for (CorpusField corpusField : list) {
            this.DT().__(BdfHtmlUtils.printCodeMirrorSpan((HtmlPrinter)this, corpusField, this.workingLang))._DT().DD().__(this.printFicheItemType(corpusField)).__(Grid.START).__(this.printDefaultSphereKeyList(corpusField)).__(this.printDisplay(corpusField)).__(this.printCurrencyArray(corpusField)).__(this.printAddressFieldArray(corpusField)).__(this.printBaseUrl(corpusField)).__(this.printSubfieldDisplay(corpusField)).__(Grid.END)._DD();
        }
        this._DL();
        return true;
    }

    private boolean printFicheItemType(CorpusField corpusField) {
        this.P("global-SubTitle").__localize("_ label.corpus.ficheitemtype").__colon().__localize(CorpusHtmlUtils.getFicheItemMessageKey(corpusField.getFicheItemType()))._P();
        return true;
    }

    private boolean printBaseUrl(CorpusField corpusField) {
        if (!FieldOptionUtils.testFieldOption("baseUrl", corpusField)) {
            return false;
        }
        String value = corpusField.getStringOption("baseUrl");
        if (value == null) {
            value = "";
        }
        String paramName = corpusField.getFieldString() + "|baseurl";
        this.__(Grid.textInputRow("_ label.corpus.baseurl", this.name(paramName).value(value).size("60")));
        return true;
    }

    private boolean printDefaultSphereKeyList(CorpusField corpusField) {
        if (!FieldOptionUtils.testFieldOption("defaultSphereKey", corpusField)) {
            return false;
        }
        SubsetKey currentDefault = corpusField.getDefaultSphereKey();
        String paramName = corpusField.getFieldString() + "|defaultsphere";
        this.__(Grid.selectRow((Object)"_ label.corpus.defaultsphere", this.name(paramName), () -> {
            this.OPTION("", currentDefault == null).__localize("_ label.corpus.defaultsphere_user")._OPTION();
            for (Sphere sphere : this.fichotheque.getSphereList()) {
                SubsetKey sphereKey = sphere.getSubsetKey();
                boolean selected = currentDefault != null && currentDefault.equals(sphereKey);
                this.OPTION(sphereKey.getSubsetName(), selected).__escape(FichothequeUtils.getTitleWithKey(sphere, this.workingLang))._OPTION();
            }
        }));
        return true;
    }

    private boolean printSubfieldDisplay(CorpusField corpusField) {
        if (!FieldOptionUtils.testFieldOption("subfieldDisplay", corpusField)) {
            return false;
        }
        String paramName = corpusField.getFieldString() + "|subfielddisplay";
        boolean checked = corpusField.isSubfieldDisplay();
        this.__(Grid.checkboxRow("_ label.corpus.subfielddisplay", this.name(paramName).value("1").checked(checked)));
        return true;
    }

    private boolean printCurrencyArray(CorpusField corpusField) {
        if (!FieldOptionUtils.testFieldOption("currencyArray", corpusField)) {
            return false;
        }
        String paramName = corpusField.getFieldString() + "|currencies";
        Currencies currencies = corpusField.getCurrencies();
        String value = "";
        if (currencies != null) {
            StringBuilder buf = new StringBuilder();
            for (ExtendedCurrency currency : currencies) {
                buf.append(currency.getCurrencyCode());
                buf.append("; ");
            }
            value = buf.toString();
        }
        this.__(Grid.textInputRow("_ label.corpus.currencyarray", this.name(paramName).value(value).size("30")));
        return true;
    }

    private boolean printAddressFieldArray(CorpusField corpusField) {
        if (!FieldOptionUtils.testFieldOption("addressFieldArray", corpusField)) {
            return false;
        }
        this.geopointFieldList.add(corpusField);
        String paramName = corpusField.getFieldString() + "|addressfieldarray";
        MultiStringable addressFieldNames = corpusField.getAddressFieldNames();
        String value = "";
        if (addressFieldNames != null) {
            value = addressFieldNames.toString(", ");
        }
        this.__(Grid.textInputRow("_ label.corpus.addressfieldarray", this.name(paramName).value(value).size("60")));
        return true;
    }

    private boolean printDisplay(CorpusField corpusField) {
        if (!FieldOptionUtils.testFieldOption("infoDisplay", corpusField)) {
            return false;
        }
        this.__(Grid.checkboxRow("_ label.corpus.display", this.name(corpusField.getFieldString() + "|blockdisplay").value("1").checked(corpusField.isBlockDisplayInfoField())));
        return true;
    }

    private boolean printFicheOptions(CorpusMetadata corpusMetadata) {
        this.H2().__localize("_ title.corpus.options_global")._H2().__(Grid.START).__(Grid.textAreaBlockRow((Object)"_ label.corpus.fieldgeneration", this.name("fieldgeneration").cols(60).rows(6).attr("data-codemirror-mode", "tableexport"), () -> this.__escape(corpusMetadata.getFieldGeneration().getRawString(), true))).__(this.printGeolocalisationFieldSelect(corpusMetadata)).__(this.printLangScope(corpusMetadata.getCorpusField(FieldKey.LANG))).__(Grid.END);
        return true;
    }

    private boolean printGeolocalisationFieldSelect(CorpusMetadata corpusMetadata) {
        if (this.geopointFieldList.isEmpty()) {
            return false;
        }
        CorpusField currentField = corpusMetadata.getGeolocalisationField();
        this.__(Grid.selectRow((Object)"_ label.corpus.geolocalisationfield", this.name("geolocalisationfield"), () -> {
            this.OPTION("", currentField == null).__localize("_ label.corpus.nofield")._OPTION();
            for (CorpusField otherCorpusField : this.geopointFieldList) {
                FieldKey fieldKey = otherCorpusField.getFieldKey();
                boolean selected = currentField != null && currentField.equals(otherCorpusField);
                this.OPTION(fieldKey.getKeyString(), selected).__escape(CorpusMetadataUtils.getFieldTitle(otherCorpusField, this.workingLang, true))._OPTION();
            }
        }));
        return true;
    }

    private boolean printLangScope(CorpusField corpusField) {
        String radioName = corpusField.getFieldString() + "|langscope";
        String langScope = corpusField.getLangScope();
        Langs langs = corpusField.getLangs();
        this.__(Grid.choiceSetRow((Object)"_ label.corpus.langscope", () -> {
            boolean listChecked;
            boolean multiChecked = false;
            boolean nolangChecked = false;
            if (langScope.equals("list")) {
                if (langs.size() == 1) {
                    switch (((Lang)langs.get(0)).toString()) {
                        case "mul": {
                            multiChecked = true;
                            listChecked = false;
                            break;
                        }
                        case "zxx": {
                            nolangChecked = true;
                            listChecked = false;
                            break;
                        }
                        default: {
                            listChecked = true;
                            break;
                        }
                    }
                } else {
                    listChecked = true;
                }
            } else {
                listChecked = false;
            }
            String listValue = listChecked && langs != null ? langs.toString("; ") : "";
            this.__(Grid.radioCell("_ label.corpus.langscope_config", this.name(radioName).value("config").checked(langScope))).__(Grid.radioCell("_ label.corpus.langscope_all", this.name(radioName).value("all").checked(langScope))).__(Grid.radioCell("_ label.corpus.langscope_mul", this.name(radioName).value("mul").checked(multiChecked))).__(Grid.radioCell("_ label.corpus.langscope_zxx", this.name(radioName).value("zxx").checked(nolangChecked))).__(Grid.radioCell((Object)"_ label.corpus.langscope_list", this.name(radioName).value("list").checked(listChecked), () -> this.__(Grid.START).__(Grid.textInputRow("_ label.corpus.langarray", this.name(corpusField.getFieldString() + "|langs").value(listValue).size("30"))).__(Grid.END)));
        }));
        return true;
    }
}

