/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.get.instructions;

import fr.exemole.bdfserver.api.BdfServer;
import fr.exemole.bdfserver.api.instruction.BdfInstruction;
import fr.exemole.bdfserver.api.instruction.BdfParameters;
import fr.exemole.bdfserver.api.users.BdfUser;
import fr.exemole.bdfserver.get.streamproducers.LexieDistributionOdsProducer;
import fr.exemole.bdfserver.get.streamproducers.LexieDistributionXmlProducer;
import fr.exemole.bdfserver.get.streamproducers.StatsThesaurusOdsProducer;
import fr.exemole.bdfserver.get.streamproducers.transformation.TransformationFactory;
import fr.exemole.bdfserver.tools.BdfServerUtils;
import fr.exemole.bdfserver.tools.instruction.DefaultBdfParameters;
import java.text.ParseException;
import java.util.function.Predicate;
import net.fichotheque.corpus.FicheMeta;
import net.fichotheque.exportation.transformation.TransformationKey;
import net.fichotheque.extraction.ExtractionContext;
import net.fichotheque.permission.PermissionSummary;
import net.fichotheque.thesaurus.Thesaurus;
import net.fichotheque.tools.misc.MotcleLexieDistributionFactory;
import net.mapeadores.util.localisation.Lang;
import net.mapeadores.util.request.RequestMap;
import net.mapeadores.util.servlets.ResponseHandler;
import net.mapeadores.util.servlets.exceptions.ForbiddenException;
import net.mapeadores.util.servlets.handlers.StreamResponseHandler;
import net.mapeadores.util.servlets.handlers.XmlResponseHandler;
import net.mapeadores.util.text.FileName;
import net.mapeadores.util.text.lexie.LexieDistribution;
import net.mapeadores.util.text.lexie.xml.LexieDistributionXMLPart;

public class MotclesInstruction
implements BdfInstruction {
    public static final short STATS_OPTION = 1;
    public static final short STATSSEL_OPTION = 2;
    public static final short INVERSE_OPTION = 3;
    private final BdfServer bdfServer;
    private final RequestMap requestMap;
    private final String filePath;
    private Thesaurus thesaurus;
    private short outputOption = 0;
    private String baseName;
    private String extension;

    public MotclesInstruction(BdfServer bdfServer, String filePath, RequestMap requestMap) {
        this.bdfServer = bdfServer;
        this.filePath = filePath;
        this.requestMap = requestMap;
    }

    @Override
    public short getBdfUserNeed() {
        return 3;
    }

    @Override
    public ResponseHandler runInstruction(BdfUser bdfUser) {
        FileName fileName;
        DefaultBdfParameters bdfParameters = new DefaultBdfParameters(this.bdfServer, bdfUser);
        PermissionSummary permissionSummary = bdfParameters.getPermissionSummary();
        try {
            fileName = FileName.parse(this.filePath);
        }
        catch (ParseException pe) {
            return null;
        }
        this.baseName = fileName.getBasename();
        this.extension = fileName.getExtension();
        boolean optionInit = this.initOption(permissionSummary);
        if (!optionInit) {
            return null;
        }
        TransformationKey transformationKey = MotclesInstruction.getTransformationKey(this.outputOption);
        if (this.outputOption == 3) {
            return this.getInverseResponseHandler(bdfParameters);
        }
        Predicate<FicheMeta> fichePredicate = this.getFichePredicate(bdfUser);
        ExtractionContext extractionContext = bdfParameters.getDefaultExtractionContext();
        TransformationFactory transformationFactory = TransformationFactory.init(bdfParameters).extractionContext(extractionContext).transformationKey(transformationKey).dynamicObject(this.thesaurus).fichePredicate(fichePredicate);
        if (this.extension.equals("xml")) {
            switch (this.outputOption) {
                case 1: 
                case 2: {
                    return XmlResponseHandler.init(transformationFactory.getSourceXmlProducer());
                }
            }
            return null;
        }
        if (this.extension.equals("html")) {
            switch (this.outputOption) {
                case 1: 
                case 2: {
                    return StreamResponseHandler.init(transformationFactory.getStreamProducer());
                }
            }
            return null;
        }
        if (this.extension.equals("ods")) {
            StatsThesaurusOdsProducer streamProducer;
            switch (this.outputOption) {
                case 1: 
                case 2: {
                    streamProducer = new StatsThesaurusOdsProducer(null, this.thesaurus, permissionSummary, BdfServerUtils.checkLangDisponibility(this.bdfServer, this.thesaurus, bdfUser.getWorkingLang()), fichePredicate);
                    break;
                }
                default: {
                    return null;
                }
            }
            return StreamResponseHandler.init(streamProducer);
        }
        return null;
    }

    private ResponseHandler getInverseResponseHandler(BdfParameters bdfParameters) {
        TransformationKey transformationKey = TransformationKey.INVERSETHESAURUS_INSTANCE;
        Lang thesaurusLang = BdfServerUtils.checkLangDisponibility(this.bdfServer, this.thesaurus, bdfParameters.getWorkingLang());
        LexieDistribution lexieDistribution = MotcleLexieDistributionFactory.getLexieDistribution(this.thesaurus, thesaurusLang);
        if (this.extension.equals("xml")) {
            return XmlResponseHandler.init(new LexieDistributionXmlProducer(lexieDistribution));
        }
        if (this.extension.equals("html")) {
            TransformationFactory transformationFactory = TransformationFactory.init(bdfParameters).sourceString(LexieDistributionXMLPart.toString(lexieDistribution, false, false)).transformationKey(transformationKey);
            return StreamResponseHandler.init(transformationFactory.getStreamProducer());
        }
        if (this.extension.equals("ods")) {
            return StreamResponseHandler.init(new LexieDistributionOdsProducer(null, lexieDistribution, this.thesaurus));
        }
        return null;
    }

    private boolean initOption(PermissionSummary permissionSummary) {
        int idx = this.baseName.indexOf(45);
        String outputString = null;
        if (idx != -1) {
            outputString = this.baseName.substring(idx + 1);
            this.baseName = this.baseName.substring(0, idx);
        }
        this.thesaurus = this.bdfServer.getFichotheque().getThesaurus(this.baseName);
        if (this.thesaurus == null || outputString == null) {
            return false;
        }
        if (!permissionSummary.hasAccess(this.thesaurus)) {
            throw new ForbiddenException();
        }
        this.outputOption = MotclesInstruction.toShort(outputString);
        return this.outputOption != 0;
    }

    private Predicate<FicheMeta> getFichePredicate(BdfUser bdfUser) {
        switch (this.outputOption) {
            case 2: {
                return bdfUser.getSelectedFiches();
            }
        }
        return null;
    }

    private static short toShort(String optionString) {
        switch (optionString) {
            case "stats": {
                return 1;
            }
            case "statssel": {
                return 2;
            }
            case "inverse": {
                return 3;
            }
        }
        return 0;
    }

    private static TransformationKey getTransformationKey(short outputOption) {
        switch (outputOption) {
            case 1: {
                return TransformationKey.STATTHESAURUS_INSTANCE;
            }
            case 2: {
                return TransformationKey.STATTHESAURUS_INSTANCE;
            }
            case 3: {
                return TransformationKey.INVERSETHESAURUS_INSTANCE;
            }
        }
        return null;
    }
}

