/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.commands.exportation;

import fr.exemole.bdfserver.api.BdfServer;
import fr.exemole.bdfserver.api.managers.TransformationManager;
import fr.exemole.bdfserver.tools.instruction.AbstractBdfCommand;
import net.fichotheque.EditOrigin;
import net.fichotheque.exportation.transformation.TemplateDef;
import net.fichotheque.exportation.transformation.TemplateDescription;
import net.fichotheque.exportation.transformation.TemplateKey;
import net.fichotheque.tools.exportation.transformation.TemplateDefBuilder;
import net.mapeadores.util.attr.AttributeParser;
import net.mapeadores.util.logging.ErrorMessageException;
import net.mapeadores.util.request.RequestMap;
import net.mapeadores.util.text.Label;
import net.mapeadores.util.text.LabelChange;

public class TemplateDefChangeCommand
extends AbstractBdfCommand {
    public static final String COMMANDNAME = "TemplateDefChange";
    public static final String COMMANDKEY = "_ EXP-33";
    public static final String TITLE_PARAMPREFIX = "title/";
    public static final String ATTRIBUTES_PARAMNAME = "attributes";
    private TemplateDef templateDef;

    public TemplateDefChangeCommand(BdfServer bdfServer, RequestMap requestMap) {
        super(bdfServer, requestMap);
    }

    @Override
    public boolean needSynchronisation() {
        return true;
    }

    @Override
    protected void doCommand() {
        EditOrigin editOrigin = this.bdfUser.newEditOrigin("exportation", COMMANDNAME);
        TransformationManager transformationManager = this.bdfServer.getTransformationManager();
        transformationManager.putTemplateDef(this.templateDef, editOrigin);
        TemplateKey templateKey = this.templateDef.getTemplateKey();
        TemplateDescription templateDescription = transformationManager.updateTemplateDescription(templateKey);
        this.putResultObject("obj.templatedescription", templateDescription);
        this.setDone("_ done.exportation.templatedefchange", templateKey.getKeyString());
    }

    @Override
    protected void checkParameters() throws ErrorMessageException {
        this.checkFichothequeAdmin();
        TemplateDescription templateDescription = this.requestHandler.getMandatoryTemplateDescription();
        TemplateDefBuilder templateDefBuilder = new TemplateDefBuilder(templateDescription.getTemplateKey(), templateDescription.getTemplateDef().getAttributes());
        LabelChange labelChange = this.requestHandler.getLabelChange(TITLE_PARAMPREFIX);
        for (Label label : labelChange.getChangedLabels()) {
            templateDefBuilder.putLabel(label);
        }
        String attributes = this.requestHandler.getTrimedParameter(ATTRIBUTES_PARAMNAME);
        if (!attributes.isEmpty()) {
            templateDefBuilder.getAttributesBuilder().changeAttributes(AttributeParser.parse(attributes));
        }
        this.templateDef = templateDefBuilder.toTemplateDef();
    }
}

