/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.commands.corpus;

import fr.exemole.bdfserver.api.BdfServer;
import fr.exemole.bdfserver.api.BdfServerConstants;
import fr.exemole.bdfserver.api.BdfServerEditor;
import fr.exemole.bdfserver.api.EditSession;
import fr.exemole.bdfserver.api.ui.FieldUi;
import fr.exemole.bdfserver.api.ui.IncludeUi;
import fr.exemole.bdfserver.api.ui.SpecialIncludeUi;
import fr.exemole.bdfserver.api.ui.SubsetIncludeUi;
import fr.exemole.bdfserver.api.ui.UiComponent;
import fr.exemole.bdfserver.api.ui.UiComponents;
import fr.exemole.bdfserver.tools.instruction.AbstractBdfCommand;
import fr.exemole.bdfserver.tools.instruction.BdfErrors;
import fr.exemole.bdfserver.tools.ui.components.FieldUiBuilder;
import fr.exemole.bdfserver.tools.ui.components.IncludeUiBuilder;
import fr.exemole.bdfserver.tools.ui.components.UiComponentBuilder;
import java.util.ArrayList;
import java.util.List;
import net.fichotheque.corpus.Corpus;
import net.mapeadores.util.logging.ErrorMessageException;
import net.mapeadores.util.request.RequestMap;

public class UiComponentOptionsCommand
extends AbstractBdfCommand {
    public static final String COMMANDNAME = "UiComponentOptions";
    public static final String COMMANDKEY = "_ CRP-19";
    public static final String WIDTH_PARAMSUFFIX = "|width";
    public static final String ROWS_PARAMSUFFIX = "|rows";
    public static final String INPUT_PARAMSUFFIX = "|input";
    public static final String DEFAULT_PARAMSUFFIX = "|default";
    public static final String STATUS_PARAMSUFFIX = "|status";
    public static final String VARIANT_PARAMSUFFIX = "|variant";
    private Corpus corpus;
    private UiComponents uiComponents;
    private List<UiComponent> uiComponentList;

    public UiComponentOptionsCommand(BdfServer bdfServer, RequestMap requestMap) {
        super(bdfServer, requestMap);
    }

    @Override
    public boolean needSynchronisation() {
        return true;
    }

    @Override
    protected void doCommand() {
        boolean done = false;
        try (EditSession session = this.startEditSession("corpus", COMMANDNAME);){
            BdfServerEditor bdfServerEditor = session.getBdfServerEditor();
            for (UiComponent componentUi : this.uiComponentList) {
                boolean stepDone = bdfServerEditor.putComponentUi(this.uiComponents, componentUi);
                if (!stepDone) continue;
                done = true;
            }
        }
        this.putResultObject("obj.corpus", this.corpus);
        if (done) {
            this.setDone("_ done.corpus.uicomponentoptions", new Object[0]);
        }
    }

    @Override
    protected void checkParameters() throws ErrorMessageException {
        this.corpus = this.requestHandler.getMandatoryCorpus();
        this.checkSubsetAdmin(this.corpus);
        this.uiComponents = this.bdfServer.getUiManager().getMainUiComponents(this.corpus);
        this.uiComponentList = new ArrayList<UiComponent>();
        for (UiComponent uiComponent : this.uiComponents.getUiComponentList()) {
            IncludeUi includeUi;
            if (uiComponent instanceof FieldUi) {
                FieldUi fieldUi = (FieldUi)uiComponent;
                String racine = fieldUi.getFieldString();
                FieldUiBuilder fieldUiBuilder = FieldUiBuilder.derive(fieldUi);
                this.update(racine, fieldUiBuilder);
                this.uiComponentList.add(fieldUiBuilder.toFieldUi());
                continue;
            }
            if (uiComponent instanceof SpecialIncludeUi) {
                includeUi = (SpecialIncludeUi)uiComponent;
                if (!includeUi.getName().equals("liage")) continue;
                this.uiComponentList.add(IncludeUiBuilder.init(includeUi).setStatus(this.getStatus(includeUi.getName())).toIncludeUi());
                continue;
            }
            if (!(uiComponent instanceof SubsetIncludeUi)) continue;
            includeUi = (SubsetIncludeUi)uiComponent;
            IncludeUiBuilder includeUiBuilder = IncludeUiBuilder.init(includeUi);
            this.update(includeUi.getName(), includeUiBuilder);
            this.uiComponentList.add(includeUiBuilder.toIncludeUi());
        }
    }

    private void update(String key, UiComponentBuilder uiComponentBuilder) throws ErrorMessageException {
        String rows;
        boolean ignoreSizeInput = false;
        uiComponentBuilder.setStatus(this.getStatus(key));
        if (this.requestHandler.hasParameter(key + VARIANT_PARAMSUFFIX)) {
            uiComponentBuilder.putOption("includeVariant", this.requestHandler.getMandatoryParameter(key + VARIANT_PARAMSUFFIX));
        }
        if (this.requestHandler.hasParameter(key + DEFAULT_PARAMSUFFIX)) {
            uiComponentBuilder.putOption("defaultValue", this.requestHandler.getMandatoryParameter(key + DEFAULT_PARAMSUFFIX));
        }
        if (this.requestHandler.hasParameter(key + INPUT_PARAMSUFFIX)) {
            String inputType = this.requestHandler.getMandatoryParameter(key + INPUT_PARAMSUFFIX);
            if (inputType.equals("text")) {
                inputType = "";
            }
            ignoreSizeInput = UiComponentOptionsCommand.isIgnoreSizeInput(inputType);
            uiComponentBuilder.putOption("inputType", inputType);
        }
        if (this.requestHandler.hasParameter(key + WIDTH_PARAMSUFFIX)) {
            String inputWidth = this.requestHandler.getMandatoryParameter(key + WIDTH_PARAMSUFFIX);
            if (ignoreSizeInput) {
                inputWidth = "";
            }
            try {
                uiComponentBuilder.putOption("inputWidth", inputWidth);
            }
            catch (IllegalArgumentException iae) {
                throw BdfErrors.unknownParameterValue(key + WIDTH_PARAMSUFFIX, inputWidth);
            }
        }
        if ((rows = this.getRows(key)) != null) {
            if (ignoreSizeInput) {
                rows = "";
            }
            uiComponentBuilder.putOption("inputRows", rows);
        }
    }

    private String getStatus(String key) throws ErrorMessageException {
        String status = this.requestHandler.getTrimedParameter(key + STATUS_PARAMSUFFIX);
        if (!status.isEmpty()) {
            try {
                return BdfServerConstants.checkValidStatus(status);
            }
            catch (IllegalArgumentException iae) {
                throw BdfErrors.unknownParameterValue(key + STATUS_PARAMSUFFIX, status);
            }
        }
        return null;
    }

    private String getRows(String key) throws ErrorMessageException {
        String rows = this.requestHandler.getTrimedParameter(key + ROWS_PARAMSUFFIX);
        try {
            int r = Integer.parseInt(rows);
            if (r > 0) {
                return String.valueOf(r);
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return null;
    }

    private static boolean isIgnoreSizeInput(String type) {
        switch (type) {
            case "": 
            case "text": {
                return false;
            }
        }
        return true;
    }
}

