/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.commands.corpus;

import fr.exemole.bdfserver.api.BdfServer;
import fr.exemole.bdfserver.api.EditSession;
import fr.exemole.bdfserver.api.ui.IncludeUi;
import fr.exemole.bdfserver.api.ui.UiComponents;
import fr.exemole.bdfserver.tools.instruction.AbstractBdfCommand;
import fr.exemole.bdfserver.tools.instruction.BdfErrors;
import fr.exemole.bdfserver.tools.ui.components.IncludeUiBuilder;
import net.fichotheque.corpus.Corpus;
import net.mapeadores.util.logging.ErrorMessageException;
import net.mapeadores.util.request.RequestMap;

public class SpecialIncludeAddCommand
extends AbstractBdfCommand {
    public static final String COMMANDNAME = "SpecialIncludeAdd";
    public static final String COMMANDKEY = "_ CRP-31";
    public static final String NAME_PARAMNAME = "name";
    private Corpus corpus;
    private String name;

    public SpecialIncludeAddCommand(BdfServer bdfServer, RequestMap requestMap) {
        super(bdfServer, requestMap);
    }

    @Override
    public boolean needSynchronisation() {
        return true;
    }

    @Override
    protected void doCommand() {
        boolean done;
        UiComponents uiComponents = this.bdfServer.getUiManager().getMainUiComponents(this.corpus);
        try (EditSession session = this.startEditSession("corpus", COMMANDNAME);){
            done = session.getBdfServerEditor().putComponentUi(uiComponents, this.buildIncludeUi());
        }
        this.putResultObject("obj.corpus", this.corpus);
        if (done) {
            this.setDone("_ done.corpus.subsetincludecreation", this.name);
        }
    }

    @Override
    protected void checkParameters() throws ErrorMessageException {
        this.corpus = this.requestHandler.getMandatoryCorpus();
        this.checkSubsetAdmin(this.corpus);
        this.name = this.getMandatory(NAME_PARAMNAME);
        if (!this.testName(this.name)) {
            throw BdfErrors.unknownParameterValue(NAME_PARAMNAME, this.name);
        }
    }

    private boolean testName(String name) {
        switch (name) {
            case "liage": 
            case "parentage": {
                return true;
            }
        }
        return false;
    }

    private IncludeUi buildIncludeUi() {
        IncludeUiBuilder includeUiBuilder = IncludeUiBuilder.initSpecial(this.name);
        return includeUiBuilder.toIncludeUi();
    }
}

