/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.commands.addenda;

import fr.exemole.bdfserver.api.BdfServer;
import fr.exemole.bdfserver.api.EditSession;
import fr.exemole.bdfserver.tools.instruction.AbstractBdfCommand;
import fr.exemole.bdfserver.tools.instruction.BdfErrors;
import java.text.ParseException;
import net.fichotheque.ExistingSubsetException;
import net.fichotheque.SubsetKey;
import net.fichotheque.addenda.Addenda;
import net.fichotheque.addenda.AddendaEditor;
import net.mapeadores.util.exceptions.ShouldNotOccurException;
import net.mapeadores.util.logging.ErrorMessageException;
import net.mapeadores.util.request.RequestMap;

public class AddendaCreationCommand
extends AbstractBdfCommand {
    public static final String COMMANDNAME = "AddendaCreation";
    public static final String COMMANDKEY = "_ ADD-01";
    public static final String NEWADDENDA_PARAMNAME = "newaddenda";
    private SubsetKey newSubsetKey;

    public AddendaCreationCommand(BdfServer bdfServer, RequestMap requestMap) {
        super(bdfServer, requestMap);
    }

    @Override
    public boolean needSynchronisation() {
        return true;
    }

    @Override
    protected void doCommand() throws ErrorMessageException {
        Addenda addenda;
        try (EditSession session = this.startEditSession("addenda", COMMANDNAME);){
            try {
                AddendaEditor addendaEditor = session.getFichothequeEditor().createAddenda(this.newSubsetKey);
                addenda = addendaEditor.getAddenda();
            }
            catch (ExistingSubsetException ese) {
                throw new ShouldNotOccurException("test done before", ese);
            }
        }
        this.putResultObject("obj.addenda", addenda);
        this.setDone("_ done.addenda.addendacreation", this.newSubsetKey.getKeyString());
    }

    @Override
    protected void checkParameters() throws ErrorMessageException {
        this.checkFichothequeAdmin();
        String newAddendaName = this.getMandatory(NEWADDENDA_PARAMNAME);
        newAddendaName = newAddendaName.trim();
        if (newAddendaName.length() == 0) {
            throw BdfErrors.error("_ error.empty.addendaname");
        }
        try {
            this.newSubsetKey = SubsetKey.parse((short)4, newAddendaName);
        }
        catch (ParseException pe) {
            throw BdfErrors.error("_ error.wrong.addendaname", newAddendaName);
        }
        if (this.fichotheque.containsSubset(this.newSubsetKey)) {
            throw BdfErrors.error("_ error.existing.addenda", newAddendaName);
        }
    }
}

