/*
 * Decompiled with CFR 0.152.
 */
package net.scrutari.dataexport.xml;

import java.util.LinkedHashMap;
import java.util.Map;
import net.scrutari.dataexport.api.MotcleExport;
import net.scrutari.dataexport.xml.XmlAttributeExport;
import net.scrutari.dataexport.xml.XmlWriter;

public class XmlMotcleExport
extends XmlAttributeExport
implements MotcleExport {
    private final Map<String, String> libelleMap = new LinkedHashMap<String, String>();
    private String motcleId;

    public void reinit(String motcleId) {
        this.motcleId = motcleId;
        this.libelleMap.clear();
        super.clear();
    }

    @Override
    public void setLibelle(String lang, String libelleValue) {
        if ((libelleValue = libelleValue == null ? "" : libelleValue.trim()).isEmpty()) {
            this.libelleMap.remove(lang);
        } else {
            this.libelleMap.put(lang, libelleValue);
        }
    }

    @Override
    public void writeXML(XmlWriter xmlWriter) {
        xmlWriter.openTagWithAttribute("motcle", "motcle-id", this.motcleId);
        for (Map.Entry<String, String> entry : this.libelleMap.entrySet()) {
            xmlWriter.addLibElement(entry.getKey(), entry.getValue());
        }
        this.writeAttributes(xmlWriter);
        xmlWriter.closeTag("motcle");
    }
}

