/*
 * Decompiled with CFR 0.152.
 */
package net.mapeadores.util.xml;

import java.io.IOException;
import net.mapeadores.util.xml.XMLWriter;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class DOMXMLWriter
implements XMLWriter {
    private Document document;
    private Node currentNode;
    private Element currentElement;

    public DOMXMLWriter(Document document) {
        this.document = document;
        this.currentNode = document;
    }

    @Override
    public DOMXMLWriter startOpenTag(String name) throws IOException {
        this.newCurrentElement(name);
        return this;
    }

    @Override
    public DOMXMLWriter startOpenTag(String name, boolean indentBefore) throws IOException {
        this.newCurrentElement(name);
        return this;
    }

    @Override
    public DOMXMLWriter endOpenTag() throws IOException {
        return this;
    }

    @Override
    public DOMXMLWriter closeEmptyTag() throws IOException {
        this.closeCurrentElement();
        return this;
    }

    @Override
    public DOMXMLWriter openTag(String name) throws IOException {
        this.newCurrentElement(name);
        return this;
    }

    @Override
    public DOMXMLWriter openTag(String name, boolean indentBefore) throws IOException {
        this.newCurrentElement(name);
        return this;
    }

    @Override
    public DOMXMLWriter closeTag(String name) throws IOException {
        this.closeCurrentElement();
        return this;
    }

    @Override
    public DOMXMLWriter closeTag(String name, boolean indentBefore) throws IOException {
        this.closeCurrentElement();
        return this;
    }

    @Override
    public DOMXMLWriter addText(CharSequence charSequence) throws IOException {
        if (charSequence.length() > 0) {
            this.appendToCurrent(this.document.createTextNode(charSequence.toString()));
        }
        return this;
    }

    @Override
    public DOMXMLWriter addCData(CharSequence charSequence) throws IOException {
        if (charSequence.length() > 0) {
            this.currentElement.appendChild(this.document.createCDATASection(charSequence.toString()));
        }
        return this;
    }

    @Override
    public DOMXMLWriter addAttribute(String attributeName, String value) throws IOException {
        if (value != null && value.length() > 0) {
            this.currentElement.setAttribute(attributeName, value);
        }
        return this;
    }

    @Override
    public DOMXMLWriter addAttribute(String attributeName, int i) throws IOException {
        this.currentElement.setAttribute(attributeName, Integer.toString(i));
        return this;
    }

    @Override
    public DOMXMLWriter addSimpleElement(String tagname, String value) throws IOException {
        if (value == null || value.length() == 0) {
            return this;
        }
        Element element = this.document.createElement(tagname);
        element.appendChild(this.document.createTextNode(value));
        this.appendToCurrent(element);
        return this;
    }

    @Override
    public DOMXMLWriter addEmptyElement(String tagname) throws IOException {
        Element element = this.document.createElement(tagname);
        this.appendToCurrent(element);
        return this;
    }

    private void newCurrentElement(String name) {
        Element element = this.document.createElement(name);
        this.appendToCurrent(element);
        this.currentElement = element;
        this.currentNode = element;
    }

    private void closeCurrentElement() {
        this.currentNode = this.currentElement.getParentNode();
        this.currentElement = this.currentNode instanceof Element ? (Element)this.currentNode : null;
    }

    private void appendToCurrent(Node node) {
        this.currentNode.appendChild(node);
    }
}

