/*
 * Decompiled with CFR 0.152.
 */
package net.mapeadores.util.text.lexie.xml;

import java.io.IOException;
import net.mapeadores.util.text.SubstringPosition;
import net.mapeadores.util.text.lexie.LexieDistribution;
import net.mapeadores.util.text.lexie.Occurrence;
import net.mapeadores.util.text.lexie.ParsedLexieSource;
import net.mapeadores.util.text.lexie.TextLexieUnit;
import net.mapeadores.util.xml.AppendableXMLWriter;
import net.mapeadores.util.xml.XMLPart;
import net.mapeadores.util.xml.XMLUtils;
import net.mapeadores.util.xml.XMLWriter;

public class LexieDistributionXMLPart
extends XMLPart {
    public LexieDistributionXMLPart(XMLWriter xmlWriter) {
        super(xmlWriter);
    }

    public void appendLexieDistribution(LexieDistribution lexieDistribution) throws IOException {
        this.openTag("lexie-distribution");
        this.openTag("lexies");
        int lexieCount = lexieDistribution.getLexieUnitCount();
        for (int i = 0; i < lexieCount; ++i) {
            this.appendLexieUnit(lexieDistribution.getLexieUnit(i));
        }
        this.closeTag("lexies");
        this.openTag("sources");
        int count = lexieDistribution.getParserLexieSourceCount();
        for (int i = 0; i < count; ++i) {
            this.appendParsedLexieSource(lexieDistribution.getParsedLexieSourceByIndex(i));
        }
        this.closeTag("sources");
        this.closeTag("lexie-distribution");
    }

    public void appendLexieUnit(TextLexieUnit lexieUnit) throws IOException {
        this.startOpenTag("lexie");
        this.addAttribute("lexie-id", lexieUnit.getLexieId());
        this.addAttribute("value", lexieUnit.getCanonicalLexie());
        this.endOpenTag();
        int occurrenceCount = lexieUnit.getOccurrenceCount();
        for (int i = 0; i < occurrenceCount; ++i) {
            Occurrence occurrence = lexieUnit.getOccurrence(i);
            ParsedLexieSource parsedLexieSource = occurrence.getParsedLexieSource();
            this.startOpenTag("occurrence");
            this.addAttribute("source-id", parsedLexieSource.getLexieSource().getSourceId());
            this.addAttribute("position", String.valueOf(occurrence.getOccurrencePosition()));
            this.closeEmptyTag();
        }
        this.closeTag("lexie");
    }

    public void appendParsedLexieSource(ParsedLexieSource parsedLexieSource) throws IOException {
        this.startOpenTag("source");
        this.addAttribute("source-id", parsedLexieSource.getLexieSource().getSourceId());
        this.endOpenTag();
        this.openTag("text");
        this.appendText(parsedLexieSource);
        this.closeTag("text", false);
        this.closeTag("source");
    }

    private void appendText(ParsedLexieSource parsedLexieSource) throws IOException {
        String text = parsedLexieSource.getLexieSource().getSourceText();
        int size = parsedLexieSource.getOccurrenceCount();
        if (size == 0) {
            this.addText(text);
            return;
        }
        Occurrence currentOccurrence = parsedLexieSource.getOccurrence(0);
        int currentOccurrenceIndex = 0;
        SubstringPosition substringPosition = currentOccurrence.getSubstringPosition();
        int startLexieIndex = substringPosition.getBeginIndex();
        int endLexieIndex = substringPosition.getEndIndex();
        if (startLexieIndex > 0) {
            this.addText(text.substring(0, startLexieIndex));
        }
        while (true) {
            this.startOpenTag("lx", false);
            this.addAttribute("lexie-id", currentOccurrence.getLexieUnit().getLexieId());
            this.addAttribute("position", String.valueOf(currentOccurrence.getOccurrencePosition()));
            this.endOpenTag();
            this.addText(text.substring(startLexieIndex, endLexieIndex + 1));
            this.closeTag("lx", false);
            if (++currentOccurrenceIndex >= size) break;
            currentOccurrence = parsedLexieSource.getOccurrence(currentOccurrenceIndex);
            substringPosition = currentOccurrence.getSubstringPosition();
            startLexieIndex = substringPosition.getBeginIndex();
            if (startLexieIndex > endLexieIndex + 1) {
                this.addText(text.substring(endLexieIndex + 1, startLexieIndex));
            }
            endLexieIndex = substringPosition.getEndIndex();
        }
        if (endLexieIndex < text.length() - 1) {
            this.addText(text.substring(endLexieIndex + 1));
        }
    }

    public static String toString(LexieDistribution lexieDistribution, boolean prettyXml, boolean omitXmlDeclaration) {
        StringBuilder buf = new StringBuilder(512);
        AppendableXMLWriter xmlWriter = XMLUtils.toXMLWriter(buf, prettyXml ? 0 : -999);
        LexieDistributionXMLPart lexieDistributionXMLPart = new LexieDistributionXMLPart(xmlWriter);
        try {
            if (!omitXmlDeclaration) {
                xmlWriter.appendXMLDeclaration();
            }
            lexieDistributionXMLPart.appendLexieDistribution(lexieDistribution);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return buf.toString();
    }
}

