/*
 * Decompiled with CFR 0.152.
 */
package net.mapeadores.util.sql;

import java.io.IOException;
import java.io.Writer;
import net.mapeadores.util.primitives.Decimal;

public class InsertWriter {
    private final Writer writer;
    private boolean firstField = true;
    private String defaultString = "";

    public InsertWriter(Writer writer) {
        this.writer = writer;
    }

    public void setDefaultString(String defaultString) {
        this.defaultString = defaultString;
    }

    public void startInsert(String tableName) throws IOException {
        this.writer.write("INSERT INTO ");
        this.writer.write(tableName);
        this.writer.write(" VALUES(");
        this.firstField = true;
    }

    public void endInsert() throws IOException {
        this.writer.write(")");
    }

    public void endLine() throws IOException {
        this.writer.write(";\n");
    }

    public void endInsertLine() throws IOException {
        this.endInsert();
        this.endLine();
    }

    public void addInteger(long lg) throws IOException {
        this.testFirstField();
        this.writer.write(String.valueOf(lg));
    }

    public void addDouble(double d) throws IOException {
        this.testFirstField();
        this.writer.write(String.valueOf(d));
    }

    public void addDecimal(Decimal decimal) throws IOException {
        this.testFirstField();
        this.writer.write(decimal.toString());
    }

    public void addText(CharSequence charSequence) throws IOException {
        this.testFirstField();
        if (charSequence == null) {
            this.writer.write("NULL");
        } else {
            this.writer.write(39);
            int length = charSequence.length();
            for (int i = 0; i < length; ++i) {
                char carac = charSequence.charAt(i);
                if (carac == '\'') {
                    this.writer.write("''");
                    continue;
                }
                if (carac == '\\') {
                    this.writer.write("\\\\");
                    continue;
                }
                this.writer.write(carac);
            }
            this.writer.write(39);
        }
    }

    public void addNull() throws IOException {
        this.testFirstField();
        this.writer.write("NULL");
    }

    public void addNull(int length) throws IOException {
        for (int i = 0; i < length; ++i) {
            this.addNull();
        }
    }

    public void addDefaultString(int length) throws IOException {
        for (int i = 0; i < length; ++i) {
            this.addText(this.defaultString);
        }
    }

    private void testFirstField() throws IOException {
        if (this.firstField) {
            this.firstField = false;
        } else {
            this.writer.write(",");
        }
    }
}

