/*
 * Decompiled with CFR 0.152.
 */
package net.mapeadores.util.primitives;

public class BitmaskUtils {
    public static final int ALLBITMASK = -1;
    static int[] bitValueArray = new int[32];

    public static int getBitValue(int rank) {
        return bitValueArray[rank];
    }

    public static boolean booleanValueAt(int mask, int rank) {
        if (rank < 0 || rank > 31) {
            throw new IllegalArgumentException();
        }
        return (mask & bitValueArray[rank]) != 0;
    }

    public static int getFirstRank(int mask) {
        for (int i = 0; i < 31; ++i) {
            if ((bitValueArray[i] & mask) == 0) continue;
            return i;
        }
        return -1;
    }

    public static boolean isLoneValue(int mask) {
        if (mask == bitValueArray[31]) {
            return true;
        }
        for (int i = 0; i < 31; ++i) {
            int val = bitValueArray[i];
            if (mask < val) {
                return false;
            }
            if (mask != val) continue;
            return true;
        }
        return false;
    }

    static {
        for (int i = 0; i < 31; ++i) {
            BitmaskUtils.bitValueArray[i] = (int)Math.pow(2.0, i);
        }
        BitmaskUtils.bitValueArray[31] = Integer.MIN_VALUE;
    }
}

