/*
 * Decompiled with CFR 0.152.
 */
package net.mapeadores.util.money;

import java.text.DecimalFormatSymbols;
import java.text.ParseException;
import net.mapeadores.util.money.ExtendedCurrency;
import net.mapeadores.util.money.MoneyLong;
import net.mapeadores.util.money.MoneyUtils;
import net.mapeadores.util.primitives.Decimal;
import net.mapeadores.util.text.StringUtils;

public final class Amount {
    private final long moneyLong;
    private final ExtendedCurrency currency;

    public Amount(long moneyLong, ExtendedCurrency currency) {
        this.moneyLong = moneyLong;
        this.currency = currency;
    }

    public long getMoneyLong() {
        return this.moneyLong;
    }

    public ExtendedCurrency getCurrency() {
        return this.currency;
    }

    public String getCurrencyCode() {
        return this.currency.getCurrencyCode();
    }

    public Decimal toDecimal(boolean avoidDecimal) {
        return MoneyLong.toDecimal(this.moneyLong, this.currency.getDefaultFractionDigits(), avoidDecimal);
    }

    public String toString() {
        return MoneyLong.toString(this.moneyLong, this.currency.getDefaultFractionDigits());
    }

    public String toLitteralString(DecimalFormatSymbols symbols, boolean avoidDecimal) {
        return MoneyUtils.toLitteralString(this.moneyLong, this.currency, symbols, avoidDecimal);
    }

    public static Amount parse(String s) throws ParseException {
        ExtendedCurrency currency;
        Decimal decimal;
        String[] result = MoneyUtils.splitMoney(s);
        if (result == null) {
            throw new ParseException(s, 0);
        }
        try {
            decimal = StringUtils.parseDecimal(result[0]);
        }
        catch (NumberFormatException nfe) {
            throw new ParseException(result[0], 0);
        }
        try {
            currency = ExtendedCurrency.parse(result[1]);
        }
        catch (ParseException pe) {
            throw new ParseException(result[1], 0);
        }
        return new Amount(MoneyLong.toMoneyLong(decimal, currency.getDefaultFractionDigits()), currency);
    }
}

