/*
 * Decompiled with CFR 0.152.
 */
package net.mapeadores.util.html;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import net.mapeadores.util.html.HtmlProducer;
import net.mapeadores.util.instruction.Argument;
import net.mapeadores.util.instruction.Instruction;
import net.mapeadores.util.instruction.InstructionResolver;
import net.mapeadores.util.instruction.InstructionUtils;
import net.mapeadores.util.logging.ErrorMessageException;

public class GabaritHtmlProducer
implements HtmlProducer {
    private final String gabaritString;
    private final InstructionResolver instructionResolver;

    public GabaritHtmlProducer(String gabaritString, InstructionResolver instructionResolver) {
        this.gabaritString = gabaritString;
        this.instructionResolver = instructionResolver;
    }

    @Override
    public void writeHtml(Appendable appendable) throws IOException {
        GabaritHtmlProducer.resolve(this.gabaritString, this.instructionResolver, appendable);
    }

    private static void resolve(String gabaritString, InstructionResolver instructionResolver, Appendable appendable) throws IOException {
        String ligne;
        BufferedReader bufreader = new BufferedReader(new StringReader(gabaritString));
        InternalParser parser = new InternalParser();
        while ((ligne = bufreader.readLine()) != null) {
            parser.testNewLine(ligne);
        }
        GabaritHtmlProducer.resolve(parser.toObjectArray(), instructionResolver, appendable);
    }

    private static void resolve(Object[] objectArray, InstructionResolver instructionResolver, Appendable appendable) throws IOException {
        for (Object element : objectArray) {
            if (element instanceof String) {
                appendable.append((String)element);
                continue;
            }
            Instruction instruction = (Instruction)element;
            try {
                Object obj = instructionResolver.resolve(instruction);
                if (obj == null) continue;
                appendable.append(obj.toString());
            }
            catch (ErrorMessageException errorMessageException) {
                // empty catch block
            }
        }
    }

    private static boolean testFirstChar(char c) {
        if (c >= 'A' && c <= 'Z') {
            return true;
        }
        return c >= 'a' && c <= 'z';
    }

    private static boolean testNameChar(char c) {
        if (c == '_') {
            return true;
        }
        if (c >= 'A' && c <= 'Z') {
            return true;
        }
        if (c >= 'a' && c <= 'z') {
            return true;
        }
        return c >= '0' && c <= '9';
    }

    private static boolean testArgumentChar(char c) {
        if (c >= 'A' && c <= 'Z') {
            return true;
        }
        if (c >= 'a' && c <= 'z') {
            return true;
        }
        if (c >= '0' && c <= '9') {
            return true;
        }
        switch (c) {
            case ',': 
            case '-': 
            case '.': 
            case '/': 
            case ';': 
            case '_': 
            case '|': {
                return true;
            }
        }
        return false;
    }

    private static class InternalParser {
        private final List<Object> objectList = new ArrayList<Object>();
        private StringBuilder currentStringBuilder = new StringBuilder();
        private boolean firstLine = true;

        private InternalParser() {
        }

        private void testNewLine(String line) {
            if (this.firstLine) {
                this.firstLine = false;
            } else {
                this.currentStringBuilder.append('\n');
            }
            int openIndex = line.indexOf(36);
            if (openIndex == -1) {
                this.currentStringBuilder.append(line);
                return;
            }
            int closeIndex = line.indexOf(36, openIndex + 1);
            if (closeIndex == -1) {
                this.currentStringBuilder.append(line);
                return;
            }
            Instruction instruction = this.parseInclusion(line, openIndex + 1, closeIndex);
            if (instruction != null) {
                this.currentStringBuilder.append(line, 0, openIndex);
                this.flush();
                this.objectList.add(instruction);
                this.testRemainInLine(line, closeIndex + 1);
            } else {
                this.currentStringBuilder.append(line, 0, closeIndex);
                this.testRemainInLine(line, closeIndex);
            }
        }

        private void testRemainInLine(String line, int startIndex) {
            int openIndex = line.indexOf(36, startIndex);
            if (openIndex == -1) {
                this.currentStringBuilder.append(line, startIndex, line.length());
                return;
            }
            int closeIndex = line.indexOf(36, openIndex + 1);
            if (closeIndex == -1) {
                this.currentStringBuilder.append(line, startIndex, line.length());
                return;
            }
            Instruction instruction = this.parseInclusion(line, openIndex + 1, closeIndex);
            if (instruction != null) {
                this.currentStringBuilder.append(line, startIndex, openIndex);
                this.flush();
                this.objectList.add(instruction);
                this.testRemainInLine(line, closeIndex + 1);
            } else {
                this.currentStringBuilder.append(line, 0, closeIndex);
                this.testRemainInLine(line, closeIndex);
            }
        }

        private void flush() {
            if (this.currentStringBuilder.length() > 0) {
                this.objectList.add(this.currentStringBuilder.toString());
                this.currentStringBuilder = new StringBuilder();
            }
        }

        private Instruction parseInclusion(String s, int startIndex, int endIndex) {
            if (startIndex == endIndex) {
                return null;
            }
            char firstChar = s.charAt(startIndex);
            if (!GabaritHtmlProducer.testFirstChar(firstChar)) {
                return null;
            }
            StringBuilder nameBuilder = new StringBuilder();
            nameBuilder.append(firstChar);
            int argumentIndex = -1;
            for (int i = startIndex + 1; i < endIndex; ++i) {
                char c = s.charAt(i);
                if (c == ':') {
                    argumentIndex = i + 1;
                    break;
                }
                if (!GabaritHtmlProducer.testNameChar(c)) {
                    return null;
                }
                nameBuilder.append(c);
            }
            ArrayList<Argument> argumentList = new ArrayList<Argument>();
            argumentList.add(InstructionUtils.toArgument(nameBuilder.toString(), null));
            while (argumentIndex != -1) {
                StringBuilder argumentBuilder = new StringBuilder();
                boolean newArgument = false;
                for (int i = argumentIndex; i < endIndex; ++i) {
                    char c = s.charAt(i);
                    if (c == ':') {
                        argumentIndex = i + 1;
                        newArgument = true;
                        break;
                    }
                    if (!GabaritHtmlProducer.testArgumentChar(c)) {
                        return null;
                    }
                    argumentBuilder.append(c);
                }
                argumentList.add(InstructionUtils.toArgument(argumentBuilder.toString(), null));
                if (newArgument) continue;
                break;
            }
            return InstructionUtils.toInstruction(argumentList);
        }

        private Object[] toObjectArray() {
            this.flush();
            Object[] gabaritElementArray = new Object[this.objectList.size()];
            return gabaritElementArray;
        }
    }
}

