/*
 * Decompiled with CFR 0.152.
 */
package net.mapeadores.util.exec;

import java.lang.reflect.Method;
import java.net.URL;

public class BareBonesBrowserLaunch {
    public static void openURL(URL url) throws Exception {
        BareBonesBrowserLaunch.openURL(url.toString());
    }

    public static void openURL(String url) throws Exception {
        String osName = System.getProperty("os.name");
        if (osName.startsWith("Mac OS")) {
            Class<?> macUtils = Class.forName("com.apple.mrj.MRJFileUtils");
            Method openURL = macUtils.getDeclaredMethod("openURL", String.class);
            openURL.invoke(null, url);
        } else if (osName.startsWith("Windows")) {
            Runtime.getRuntime().exec("rundll32 url.dll,FileProtocolHandler " + url);
        } else {
            String[] browsers = new String[]{"firefox", "mozilla-firefox", "opera", "konqueror", "mozilla", "netscape"};
            String browser = null;
            for (int count = 0; count < browsers.length && browser == null; ++count) {
                if (Runtime.getRuntime().exec(new String[]{"which", browsers[count]}).waitFor() != 0) continue;
                browser = browsers[count];
            }
            if (browser == null) {
                throw new Exception("Could not find web browser.");
            }
            Runtime.getRuntime().exec(new String[]{browser, url});
        }
    }
}

