/*
 * Decompiled with CFR 0.152.
 */
package net.mapeadores.opendocument.elements;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.TreeMap;
import net.mapeadores.opendocument.elements.ListStyleElement;
import net.mapeadores.opendocument.elements.OdElement;
import net.mapeadores.opendocument.elements.OdElementUtils;
import net.mapeadores.opendocument.elements.StyleElement;

public class ElementMaps {
    private final Map<String, Map<String, StyleElement>> mapOfMaps = new HashMap<String, Map<String, StyleElement>>();
    private final Map<Integer, StyleElement> hMap = new TreeMap<Integer, StyleElement>();
    private final Map<String, ListStyleElement> listStyleMap = new HashMap<String, ListStyleElement>();

    public Map<Integer, StyleElement> getHMap() {
        return this.hMap;
    }

    public Map<String, StyleElement> getFamilyMap(String family) {
        return this.mapOfMaps.get(family);
    }

    public OdElement getElement(String elementName, String styleName, boolean createIfMissing) {
        int level = OdElementUtils.getHLevel(elementName);
        if (level == 0) {
            return this.getFromStyleFamily("paragraph", "Heading", createIfMissing);
        }
        if (level > 0) {
            return this.getHStyle(level, createIfMissing);
        }
        String styleFamily = StyleElement.getMatchingStyleFamily(elementName);
        if (styleFamily == null) {
            return null;
        }
        return this.getFromStyleFamily(styleFamily, styleName, createIfMissing);
    }

    public OdElement getElement(String elementName, String styleName, String attributeName, String attributeValue, boolean createIfMissing) {
        if (elementName.equals("ul") || elementName.equals("ol")) {
            if (attributeName.equals("level")) {
                try {
                    ListStyleElement listStyleElement;
                    int level = Integer.parseInt(attributeValue);
                    if (level < 1 || level > 10) {
                        return null;
                    }
                    short type = 1;
                    if (elementName.equals("ol")) {
                        type = 2;
                    }
                    if ((listStyleElement = this.getListStyleElement(styleName, type, createIfMissing)) == null) {
                        return null;
                    }
                    return listStyleElement.getOrCreateListLevelElement(level);
                }
                catch (NumberFormatException nfe) {
                    return null;
                }
            }
            return null;
        }
        return null;
    }

    public Map<String, ListStyleElement> getListStyleMap() {
        return this.listStyleMap;
    }

    public void append(ElementMaps importElementMaps) {
        this.importH(importElementMaps);
        for (Map.Entry<String, Map<String, StyleElement>> entry : importElementMaps.mapOfMaps.entrySet()) {
            String family = entry.getKey();
            Map<String, StyleElement> map = entry.getValue();
            if (!this.mapOfMaps.containsKey(family)) {
                HashMap<String, StyleElement> newMap = new HashMap<String, StyleElement>(map);
                this.mapOfMaps.put(family, newMap);
                continue;
            }
            this.append(map, this.mapOfMaps.get(family));
        }
        this.importListStyle(importElementMaps);
    }

    private ListStyleElement getListStyleElement(String styleName, short listLevelType, boolean createIfMissing) {
        ListStyleElement listStyleElement = this.listStyleMap.get(styleName);
        if (listStyleElement == null && createIfMissing) {
            listStyleElement = new ListStyleElement(styleName, listLevelType);
            this.listStyleMap.put(styleName, listStyleElement);
        }
        return listStyleElement;
    }

    private StyleElement getFromStyleFamily(String styleFamily, String styleName, boolean createIfMissing) {
        StyleElement styleElement;
        if (styleName == null) {
            return null;
        }
        Map<String, StyleElement> map = this.mapOfMaps.get(styleFamily);
        if (map == null) {
            if (!createIfMissing) {
                return null;
            }
            map = new LinkedHashMap<String, StyleElement>();
            this.mapOfMaps.put(styleFamily, map);
        }
        if ((styleElement = map.get(styleName)) == null && createIfMissing) {
            styleElement = StyleElement.newInstance(styleFamily, styleName);
            map.put(styleName, styleElement);
        }
        return styleElement;
    }

    private StyleElement getHStyle(int level, boolean createIfMissing) {
        StyleElement hStyle = this.hMap.get(level);
        if (hStyle == null && createIfMissing) {
            hStyle = StyleElement.newHInstance(level);
            this.hMap.put(level, hStyle);
        }
        return hStyle;
    }

    private void importListStyle(ElementMaps importElementMaps) {
        for (Map.Entry<String, ListStyleElement> entry : importElementMaps.listStyleMap.entrySet()) {
            String styleName = entry.getKey();
            ListStyleElement importStyle = entry.getValue();
            ListStyleElement current = this.listStyleMap.get(styleName);
            if (current == null) {
                this.listStyleMap.put(styleName, importStyle);
                continue;
            }
            current.importAttributes(importStyle);
        }
    }

    private void importH(ElementMaps importElementMaps) {
        for (Map.Entry<Integer, StyleElement> entry : importElementMaps.hMap.entrySet()) {
            Integer level = entry.getKey();
            StyleElement importStyle = entry.getValue();
            StyleElement hStyle = this.hMap.get(level);
            if (hStyle == null) {
                this.hMap.put(level, importStyle);
                continue;
            }
            hStyle.importAttributes(importStyle);
        }
    }

    private void append(Map<String, StyleElement> importMap, Map<String, StyleElement> destinationMap) {
        for (Map.Entry<String, StyleElement> entry : importMap.entrySet()) {
            String styleName = entry.getKey();
            StyleElement importStyle = entry.getValue();
            StyleElement destinationStyle = destinationMap.get(styleName);
            if (destinationStyle == null) {
                destinationMap.put(styleName, importStyle);
                continue;
            }
            destinationStyle.importAttributes(importStyle);
        }
    }
}

