/*
 * Decompiled with CFR 0.152.
 */
package net.fichotheque.utils.selection;

import java.util.function.Predicate;
import net.fichotheque.Fichotheque;
import net.fichotheque.FichothequeQuestioner;
import net.fichotheque.Subset;
import net.fichotheque.corpus.Corpus;
import net.fichotheque.corpus.FicheMeta;
import net.fichotheque.extraction.ExtractionContext;
import net.fichotheque.selection.SelectionContext;
import net.fichotheque.utils.EligibilityUtils;
import net.mapeadores.util.localisation.Lang;
import net.mapeadores.util.localisation.MessageLocalisationProvider;

public class SelectionContextBuilder {
    private final Fichotheque fichotheque;
    private final FichothequeQuestioner fichothequeQuestioner;
    private final MessageLocalisationProvider messageLocalisationProvider;
    private final Lang lang;
    private Predicate<Subset> subsetAccessPredicate;
    private Predicate<FicheMeta> fichePredicate;
    private Corpus currentCorpus;

    public SelectionContextBuilder(Fichotheque fichotheque, FichothequeQuestioner fichothequeQuestioner, MessageLocalisationProvider messageLocalisationProvider, Lang lang) {
        this.fichotheque = fichotheque;
        this.fichothequeQuestioner = fichothequeQuestioner;
        this.messageLocalisationProvider = messageLocalisationProvider;
        this.lang = lang;
    }

    public SelectionContextBuilder setSubsetAccessPredicate(Predicate<Subset> subsetAccessPredicate) {
        this.subsetAccessPredicate = subsetAccessPredicate;
        return this;
    }

    public SelectionContextBuilder setFichePredicate(Predicate<FicheMeta> fichePredicate) {
        this.fichePredicate = fichePredicate;
        return this;
    }

    public SelectionContextBuilder setCurrentCorpus(Corpus currentCorpus) {
        this.currentCorpus = currentCorpus;
        return this;
    }

    public SelectionContext toSelectionContext() {
        if (this.subsetAccessPredicate == null) {
            throw new IllegalStateException("subsetAccessPredicate must be defined");
        }
        Predicate<FicheMeta> finalFichePredicate = this.fichePredicate != null ? this.fichePredicate : EligibilityUtils.ALL_FICHE_PREDICATE;
        return new InternalSelectionContext(this.fichotheque, this.fichothequeQuestioner, this.messageLocalisationProvider, this.lang, this.subsetAccessPredicate, finalFichePredicate, this.currentCorpus);
    }

    public static SelectionContextBuilder init(Fichotheque fichotheque, FichothequeQuestioner fichothequeQuestioner, MessageLocalisationProvider messageLocalisationProvider, Lang lang) {
        return new SelectionContextBuilder(fichotheque, fichothequeQuestioner, messageLocalisationProvider, lang);
    }

    public static SelectionContextBuilder build(ExtractionContext extractionContext) {
        return SelectionContextBuilder.init(extractionContext.getFichotheque(), extractionContext.getFichothequeQuestioner(), extractionContext.getMessageLocalisationProvider(), extractionContext.getLangContext().getDefaultLang());
    }

    public static SelectionContextBuilder build(ExtractionContext extractionContext, Lang lang) {
        return SelectionContextBuilder.init(extractionContext.getFichotheque(), extractionContext.getFichothequeQuestioner(), extractionContext.getMessageLocalisationProvider(), lang);
    }

    private static class InternalSelectionContext
    implements SelectionContext {
        private final Fichotheque fichotheque;
        private final FichothequeQuestioner fichothequeQuestioner;
        private final MessageLocalisationProvider messageLocalisationProvider;
        private final Lang workingLang;
        private final Predicate<Subset> subsetAccessPredicate;
        private final Predicate<FicheMeta> fichePredicate;
        private final Corpus currentCorpus;

        private InternalSelectionContext(Fichotheque fichotheque, FichothequeQuestioner fichothequeQuestioner, MessageLocalisationProvider messageLocalisationProvider, Lang workingLang, Predicate<Subset> subsetAccessPredicate, Predicate<FicheMeta> fichePredicate, Corpus currentCorpus) {
            this.fichotheque = fichotheque;
            this.fichothequeQuestioner = fichothequeQuestioner;
            this.messageLocalisationProvider = messageLocalisationProvider;
            this.workingLang = workingLang;
            this.subsetAccessPredicate = subsetAccessPredicate;
            this.fichePredicate = fichePredicate;
            this.currentCorpus = currentCorpus;
        }

        @Override
        public Fichotheque getFichotheque() {
            return this.fichotheque;
        }

        @Override
        public FichothequeQuestioner getFichothequeQuestioner() {
            return this.fichothequeQuestioner;
        }

        @Override
        public MessageLocalisationProvider getMessageLocalisationProvider() {
            return this.messageLocalisationProvider;
        }

        @Override
        public Lang getWorkingLang() {
            return this.workingLang;
        }

        @Override
        public Predicate<Subset> getSubsetAccessPredicate() {
            return this.subsetAccessPredicate;
        }

        @Override
        public Predicate<FicheMeta> getFichePredicate() {
            return this.fichePredicate;
        }

        @Override
        public Corpus getCurrentCorpus() {
            return this.currentCorpus;
        }
    }
}

