/*
 * Decompiled with CFR 0.152.
 */
package net.fichotheque.utils;

import java.text.ParseException;
import java.util.ArrayList;
import net.fichotheque.SubsetKey;
import net.fichotheque.corpus.metadata.CorpusField;
import net.fichotheque.corpus.metadata.FieldKey;
import net.fichotheque.corpus.metadata.FieldOptionException;
import net.mapeadores.util.localisation.Lang;
import net.mapeadores.util.localisation.LangsUtils;
import net.mapeadores.util.money.CurrenciesUtils;
import net.mapeadores.util.money.ExtendedCurrency;
import net.mapeadores.util.text.StringUtils;

public final class FieldOptionUtils {
    private FieldOptionUtils() {
    }

    public static boolean haveSubfield(String ficheItemType) {
        switch (ficheItemType) {
            case "person": 
            case "geopoint": 
            case "image": {
                return true;
            }
        }
        return false;
    }

    public static boolean testFieldOption(String optionName, CorpusField corpusField) {
        try {
            FieldOptionUtils.checkUsage(optionName, corpusField.getFieldKey(), corpusField.getFicheItemType());
            return true;
        }
        catch (FieldOptionException foe) {
            return false;
        }
    }

    public static boolean testFieldOption(String optionName, FieldKey fieldKey, String ficheItemType) {
        try {
            FieldOptionUtils.checkUsage(optionName, fieldKey, ficheItemType);
            return true;
        }
        catch (FieldOptionException foe) {
            return false;
        }
    }

    public static void checkUsage(String optionName, FieldKey fieldKey, String ficheItemType) throws FieldOptionException {
        switch (optionName) {
            case "infoDisplay": {
                if (fieldKey.isInfo()) break;
                throw new FieldOptionException("informationDisplay Option applies only to Info Field");
            }
            case "defaultSphereKey": {
                if (ficheItemType.equals("person")) break;
                throw new FieldOptionException("ficheItemType must be PERSON_FIELD");
            }
            case "subfieldDisplay": {
                if (!fieldKey.isProp()) {
                    throw new FieldOptionException("subfieldDisplay Option applies only to Prop Field");
                }
                if (FieldOptionUtils.haveSubfield(ficheItemType)) break;
                throw new FieldOptionException("wrong ficheItemType = " + ficheItemType);
            }
            case "currencyArray": {
                if (ficheItemType.equals("amount")) break;
                throw new FieldOptionException("ficheItemType must be AMOUNT_FIELD");
            }
            case "addressFieldArray": {
                if (!fieldKey.isProp()) {
                    throw new FieldOptionException("addressFields Option applies only to Prop Field");
                }
                if (ficheItemType.equals("geopoint")) break;
                throw new FieldOptionException("ficheItemType must be GEOPOINT_FIELD");
            }
            case "baseUrl": {
                if (ficheItemType.equals("image") || ficheItemType.equals("link")) break;
                throw new FieldOptionException("ficheItemType must be IMAGE_FIELD or lINK_FIELD");
            }
            case "langScope": {
                if (FieldOptionUtils.isLangField(fieldKey, ficheItemType)) break;
                throw new FieldOptionException("langScope applies only to FieldKey.LANG and fields with ficheItemType = LANGUE_FIELD");
            }
            case "langArray": {
                if (FieldOptionUtils.isLangField(fieldKey, ficheItemType) || ficheItemType == "para") break;
                throw new FieldOptionException("langArray applies only to FieldKey.LANG and fields with ficheItemType = PARA_FIELD or LANGUE_FIELD");
            }
            case "geolocalisationField": {
                if (fieldKey.isProp() && ficheItemType.equals("geopoint")) break;
                throw new FieldOptionException("geolocalisationField applies only to Prop Field with ficheItemType = GEOPOINT_FIELD");
            }
        }
    }

    public static Object parseOptionValue(String optionName, String optionValue) throws FieldOptionException {
        if (optionValue == null) {
            return null;
        }
        if ((optionValue = optionValue.trim()).isEmpty()) {
            return null;
        }
        switch (optionName) {
            case "addressFieldArray": {
                String[] tokenArray;
                ArrayList<FieldKey> fieldKeyList = new ArrayList<FieldKey>();
                for (String token : tokenArray = StringUtils.getTechnicalTokens(optionValue, false)) {
                    try {
                        FieldKey fieldKey = FieldKey.parse(token);
                        fieldKeyList.add(fieldKey);
                    }
                    catch (ParseException parseException) {
                        // empty catch block
                    }
                }
                if (fieldKeyList.isEmpty()) {
                    return null;
                }
                return fieldKeyList.toArray(new FieldKey[fieldKeyList.size()]);
            }
            case "langArray": {
                Lang[] langArray = LangsUtils.toCleanLangArray(optionValue);
                if (langArray.length == 0) {
                    return null;
                }
                return langArray;
            }
            case "currencyArray": {
                ExtendedCurrency[] currencyArray = CurrenciesUtils.toCleanCurrencyArray(optionValue);
                if (currencyArray.length == 0) {
                    currencyArray = null;
                }
                return currencyArray;
            }
        }
        FieldOptionUtils.checkString(optionName, optionValue);
        return optionValue;
    }

    public static void checkString(String optionName, String optionValue) throws FieldOptionException {
        switch (optionName) {
            case "defaultSphereKey": {
                try {
                    SubsetKey sphereKey = SubsetKey.parse(optionValue);
                    if (!sphereKey.isSphereSubset()) {
                        throw new FieldOptionException("value must be a key of a sphere");
                    }
                    break;
                }
                catch (ParseException pe) {
                    throw new FieldOptionException("value must be a valid sphereKey");
                }
            }
        }
    }

    private static boolean isLangField(FieldKey fieldKey, String ficheItemType) {
        if (ficheItemType.equals("language")) {
            return true;
        }
        switch (fieldKey.getKeyString()) {
            case "lang": {
                return true;
            }
        }
        return false;
    }
}

