/*
 * Decompiled with CFR 0.152.
 */
package net.fichotheque.tools.thesaurus.sync.dom;

import java.text.ParseException;
import java.util.function.Consumer;
import net.fichotheque.thesaurus.sync.MotcleSync;
import net.fichotheque.tools.thesaurus.sync.MotcleSyncBuilder;
import net.fichotheque.tools.thesaurus.sync.ThesaurusSyncBuilder;
import net.mapeadores.util.attr.AttributeUtils;
import net.mapeadores.util.logging.MessageHandler;
import net.mapeadores.util.text.LabelChangeBuilder;
import net.mapeadores.util.text.LabelUtils;
import net.mapeadores.util.xml.DOMUtils;
import net.mapeadores.util.xml.DomMessages;
import org.w3c.dom.Element;

public class KeywordsDOMReader {
    private final ThesaurusSyncBuilder thesaurusSyncBuilder;
    private final MessageHandler messageHandler;

    public KeywordsDOMReader(ThesaurusSyncBuilder thesaurusSync, MessageHandler messageHandler) {
        this.thesaurusSyncBuilder = thesaurusSync;
        this.messageHandler = messageHandler;
    }

    public KeywordsDOMReader read(Element element) {
        DOMUtils.readChildren(element, new RootConsumer());
        return this;
    }

    public static KeywordsDOMReader init(ThesaurusSyncBuilder thesaurusSync, MessageHandler messageHandler) {
        return new KeywordsDOMReader(thesaurusSync, messageHandler);
    }

    private class RootConsumer
    implements Consumer<Element> {
        private RootConsumer() {
        }

        @Override
        public void accept(Element element) {
            String tagName;
            switch (tagName = element.getTagName()) {
                case "keyword": {
                    this.initMotcleSync(element, "active");
                    break;
                }
                case "group": {
                    this.initMotcleSync(element, "group");
                }
            }
        }

        private void initMotcleSync(Element element, String status) {
            String idalpha = element.getAttribute("id");
            if (KeywordsDOMReader.this.thesaurusSyncBuilder.contains(idalpha)) {
                return;
            }
            MotcleSyncBuilder motcleSyncBuilder = MotcleSyncBuilder.init(idalpha).setStatus(status);
            DOMUtils.readChildren(element, new KeywordConsumer(motcleSyncBuilder));
            KeywordsDOMReader.this.thesaurusSyncBuilder.addFirstLevel(motcleSyncBuilder);
        }
    }

    private class KeywordConsumer
    implements Consumer<Element> {
        private final MotcleSyncBuilder motcleSyncBuilder;

        private KeywordConsumer(MotcleSyncBuilder motcleSyncBuilder) {
            this.motcleSyncBuilder = motcleSyncBuilder;
        }

        @Override
        public void accept(Element element) {
            String tagName;
            switch (tagName = element.getTagName()) {
                case "label": {
                    LabelChangeBuilder labelChangeBuilder = this.motcleSyncBuilder.getLabelChangeBuilder();
                    try {
                        LabelUtils.readLabel(element, labelChangeBuilder);
                    }
                    catch (ParseException pe) {
                        DomMessages.wrongLangAttribute(KeywordsDOMReader.this.messageHandler, tagName, element.getAttribute("xml:lang"));
                    }
                    break;
                }
                case "attr": {
                    AttributeUtils.readAttrElement(this.motcleSyncBuilder.getAttributeChangeBuilder(), element);
                    break;
                }
                case "keyword": {
                    this.initChild(element, "active");
                    break;
                }
                case "group": {
                    this.initChild(element, "group");
                }
            }
        }

        private MotcleSync initChild(Element element, String status) {
            String idalpha = element.getAttribute("id");
            if (KeywordsDOMReader.this.thesaurusSyncBuilder.contains(idalpha)) {
                return null;
            }
            MotcleSyncBuilder childBuilder = MotcleSyncBuilder.init(idalpha).setStatus(status);
            DOMUtils.readChildren(element, new KeywordConsumer(childBuilder));
            MotcleSync motcleSync = this.motcleSyncBuilder.toMotcleSync();
            KeywordsDOMReader.this.thesaurusSyncBuilder.addChild(this.motcleSyncBuilder, childBuilder);
            return motcleSync;
        }
    }
}

