/*
 * Decompiled with CFR 0.152.
 */
package net.fichotheque.tools.permission;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.fichotheque.Fichotheque;
import net.fichotheque.Subset;
import net.fichotheque.SubsetItem;
import net.fichotheque.SubsetKey;
import net.fichotheque.corpus.Corpus;
import net.fichotheque.corpus.FicheMeta;
import net.fichotheque.junction.Junctions;
import net.fichotheque.permission.PermissionEntry;
import net.fichotheque.permission.PermissionSummary;

public final class ListFilterEngine {
    private static final List<PermissionEntry> EMPTY_PERMISSIONENTRYLIST = Collections.emptyList();

    private ListFilterEngine() {
    }

    public static List<PermissionEntry> filter(Subset subset, List<SubsetItem> subsetItemList, PermissionSummary permissionSummary) {
        SubsetKey subsetKey = subset.getSubsetKey();
        if (subsetItemList.isEmpty()) {
            return EMPTY_PERMISSIONENTRYLIST;
        }
        int readLevel = permissionSummary.getReadLevel(subsetKey);
        if (readLevel == 0) {
            return EMPTY_PERMISSIONENTRYLIST;
        }
        if (readLevel == 5) {
            return ListFilterEngine.simpleList(subsetItemList, true);
        }
        int writeLevel = permissionSummary.getWriteLevel(subsetKey);
        if (readLevel == 4) {
            if (writeLevel == 4) {
                return ListFilterEngine.simpleList(subsetItemList, true);
            }
            if (writeLevel == 0) {
                return ListFilterEngine.simpleList(subsetItemList, false);
            }
        }
        if (subsetKey.isCorpusSubset()) {
            return ListFilterEngine.corpusFilter(subsetItemList, permissionSummary);
        }
        if (subsetKey.isAddendaSubset() || subsetKey.isAlbumSubset()) {
            return ListFilterEngine.junctionTestFilter(subset, subsetItemList, permissionSummary);
        }
        throw new IllegalStateException("Sphere and thesaurus has 0, 4 or 5 level only");
    }

    private static List<PermissionEntry> simpleList(List<SubsetItem> list, boolean editable) {
        ArrayList<PermissionEntry> permissionEntryList = new ArrayList<PermissionEntry>();
        for (SubsetItem subsetItem : list) {
            permissionEntryList.add(new InternalPermissionEntry(subsetItem, editable));
        }
        return permissionEntryList;
    }

    private static List<PermissionEntry> corpusFilter(List<SubsetItem> list, PermissionSummary permissionSummary) {
        ArrayList<PermissionEntry> permissionEntryList = new ArrayList<PermissionEntry>();
        for (SubsetItem subsetItem : list) {
            FicheMeta ficheMeta = (FicheMeta)subsetItem;
            if (!permissionSummary.canRead(ficheMeta)) continue;
            boolean editable = permissionSummary.canWrite(ficheMeta);
            permissionEntryList.add(new InternalPermissionEntry(ficheMeta, editable));
        }
        return permissionEntryList;
    }

    private static List<PermissionEntry> junctionTestFilter(Subset subset, List<SubsetItem> list, PermissionSummary permissionSummary) {
        Fichotheque fichotheque = subset.getFichotheque();
        List<Corpus> corpusList = fichotheque.getCorpusList();
        int corpusLength = corpusList.size();
        Corpus[] corpusArray = new Corpus[corpusLength];
        boolean[] writableArray = new boolean[corpusLength];
        int p = 0;
        for (int i = 0; i < corpusLength; ++i) {
            Corpus corpus = corpusList.get(i);
            int readLevel = permissionSummary.getReadLevel(corpus.getSubsetKey());
            if (readLevel <= 0) continue;
            corpusArray[p] = corpus;
            writableArray[p] = permissionSummary.getWriteLevel(corpus.getSubsetKey()) != 0;
            ++p;
        }
        if (p == 0) {
            return EMPTY_PERMISSIONENTRYLIST;
        }
        corpusLength = p;
        ArrayList<PermissionEntry> permissionEntryList = new ArrayList<PermissionEntry>();
        for (SubsetItem subsetItem : list) {
            boolean accept = false;
            boolean editable = false;
            for (int j = 0; j < corpusLength; ++j) {
                Junctions junctions = fichotheque.getJunctions(subsetItem, corpusArray[j]);
                int k = -1;
                for (Junctions.Entry entry : junctions.getEntryList()) {
                    ++k;
                    FicheMeta ficheMeta = (FicheMeta)entry.getSubsetItem();
                    if (!accept) {
                        if (!permissionSummary.canRead(ficheMeta)) continue;
                        accept = true;
                    }
                    if (!writableArray[k]) break;
                    if (!permissionSummary.canWrite(ficheMeta)) continue;
                    editable = true;
                    break;
                }
                if (editable) break;
            }
            if (!accept) continue;
            permissionEntryList.add(new InternalPermissionEntry(subsetItem, editable));
        }
        return permissionEntryList;
    }

    private static class InternalPermissionEntry
    implements PermissionEntry {
        private final SubsetItem subsetItem;
        private final boolean editable;

        private InternalPermissionEntry(SubsetItem subsetItem, boolean editable) {
            this.subsetItem = subsetItem;
            this.editable = editable;
        }

        @Override
        public SubsetItem getSubsetItem() {
            return this.subsetItem;
        }

        @Override
        public boolean isEditable() {
            return this.editable;
        }
    }
}

