/*
 * Decompiled with CFR 0.152.
 */
package net.fichotheque.tools.parsers;

import net.mapeadores.util.text.QuoteOptions;
import net.mapeadores.util.text.TypoOptions;

public final class TypoParser {
    private TypoParser() {
    }

    public static String parseTypo(String s, TypoOptions typoOptions) {
        if (s == null) {
            return "";
        }
        int length = s.length();
        if (length == 0) {
            return "";
        }
        return TypoParser.parseTypo(s, 0, length, typoOptions);
    }

    public static String parseTypo(CharSequence charSequence, int start, int len, TypoOptions typoOptions) {
        QuoteOptions quoteOptions = typoOptions.getQuoteOptions();
        int stopIndex = start + len;
        StringBuilder buf = new StringBuilder();
        block10: for (int i = start; i < stopIndex; ++i) {
            int precedingIndices = i - start;
            int remainingIndices = stopIndex - i - 1;
            char carac = charSequence.charAt(i);
            switch (carac) {
                case ' ': {
                    i = TypoParser.testSpace(charSequence, i, remainingIndices, buf);
                    continue block10;
                }
                case '~': {
                    i = TypoParser.testNonBreakingSpace(charSequence, i, remainingIndices, buf);
                    continue block10;
                }
                case '.': {
                    i = TypoParser.testDot(charSequence, i, remainingIndices, buf);
                    continue block10;
                }
                case '^': {
                    i = TypoParser.testSuperscript(charSequence, i, remainingIndices, buf);
                    continue block10;
                }
                case '\\': {
                    i = TypoParser.testAntiSlash(charSequence, i, remainingIndices, buf);
                    continue block10;
                }
                case '\u00ab': {
                    i = TypoParser.testFollowingSpace(charSequence, i, remainingIndices, buf);
                    continue block10;
                }
                case '\'': {
                    i = TypoParser.parseSimpleQuote(charSequence, i, remainingIndices, precedingIndices, buf);
                    continue block10;
                }
                case '\"': {
                    i = TypoParser.parseDoubleQuote(charSequence, i, remainingIndices, precedingIndices, buf, quoteOptions);
                    continue block10;
                }
                default: {
                    buf.append(carac);
                }
            }
        }
        return buf.toString();
    }

    private static int testNonBreakingSpace(CharSequence charSequence, int currentIndex, int remainingIndices, StringBuilder buf) {
        if (remainingIndices == 0) {
            buf.append('\u00a0');
            return currentIndex;
        }
        char nextChar = charSequence.charAt(currentIndex + 1);
        switch (nextChar) {
            case '!': 
            case ';': 
            case '?': 
            case '\u00bb': {
                buf.append('\u202f');
                break;
            }
            default: {
                buf.append('\u00a0');
            }
        }
        return currentIndex;
    }

    private static int testSpace(CharSequence charSequence, int currentIndex, int remainingIndices, StringBuilder buf) {
        if (remainingIndices == 0) {
            buf.append(' ');
            return currentIndex;
        }
        char nextChar = charSequence.charAt(currentIndex + 1);
        switch (nextChar) {
            case '!': 
            case ';': 
            case '?': 
            case '\u00bb': {
                buf.append('\u202f');
                break;
            }
            case ':': {
                buf.append('\u00a0');
                break;
            }
            default: {
                buf.append(' ');
            }
        }
        return currentIndex;
    }

    private static int testDot(CharSequence charSequence, int currentIndex, int remainingIndices, StringBuilder buf) {
        if (remainingIndices < 2) {
            buf.append('.');
            return currentIndex;
        }
        char nextChar = charSequence.charAt(currentIndex + 1);
        if (nextChar != '.') {
            buf.append('.');
            return currentIndex;
        }
        nextChar = charSequence.charAt(currentIndex + 2);
        if (nextChar != '.') {
            buf.append('.');
            buf.append('.');
            return currentIndex + 1;
        }
        buf.append('\u2026');
        return currentIndex + 2;
    }

    private static int testSuperscript(CharSequence charSequence, int currentIndex, int remainingIndices, StringBuilder buf) {
        char carac;
        char superchar;
        if (remainingIndices == 0) {
            buf.append('^');
            return currentIndex;
        }
        int p = 0;
        int stopIndex = currentIndex + remainingIndices + 1;
        for (int i = currentIndex + 1; i < stopIndex && (superchar = TypoParser.getsSuperscriptForm(carac = charSequence.charAt(i))) != '0'; ++i) {
            buf.append(superchar);
            ++p;
        }
        if (p == 0) {
            buf.append('^');
        }
        return currentIndex + p;
    }

    private static int testAntiSlash(CharSequence charSequence, int currentIndex, int remainingIndices, StringBuilder buf) {
        if (remainingIndices == 0) {
            buf.append('\\');
            return currentIndex;
        }
        char nextChar = charSequence.charAt(currentIndex + 1);
        if (nextChar == ']') {
            buf.append(']');
            return currentIndex + 1;
        }
        if (nextChar == '}') {
            buf.append('}');
            return currentIndex + 1;
        }
        if (nextChar == '\\') {
            buf.append('\\');
            return currentIndex + 1;
        }
        if (nextChar == 'u') {
            char carac;
            int digit;
            int min = currentIndex + 2 + Math.min(6, remainingIndices - 1);
            int p = 0;
            int result = 0;
            for (int i = currentIndex + 2; i < min && (digit = Character.digit(carac = charSequence.charAt(i), 16)) >= 0; ++i) {
                result *= 16;
                result += digit;
                ++p;
            }
            if (p == 0) {
                buf.append("\\u");
            } else {
                buf.appendCodePoint(result);
            }
            return currentIndex + 1 + p;
        }
        buf.append('\\');
        return currentIndex;
    }

    private static int testFollowingSpace(CharSequence charSequence, int currentIndex, int remainingIndices, StringBuilder buf) {
        char currentChar = charSequence.charAt(currentIndex);
        buf.append(currentChar);
        if (remainingIndices == 0) {
            return currentIndex;
        }
        char nextChar = charSequence.charAt(currentIndex + 1);
        if (nextChar != ' ' && nextChar != '~') {
            return currentIndex;
        }
        switch (currentChar) {
            case '\u00ab': {
                buf.append('\u202f');
                break;
            }
            default: {
                buf.append('\u00a0');
            }
        }
        return currentIndex + 1;
    }

    private static int parseSimpleQuote(CharSequence charSequence, int currentIndex, int remainingIndices, int precedingIndices, StringBuilder buf) {
        if (remainingIndices == 0) {
            buf.append('\u2019');
            return currentIndex;
        }
        char next = charSequence.charAt(currentIndex + 1);
        if (precedingIndices == 0) {
            if (next == '\'') {
                buf.append('\u201c');
                return currentIndex + 1;
            }
            buf.append('\u2018');
            return currentIndex;
        }
        int lastIndex = currentIndex + remainingIndices;
        char previous = charSequence.charAt(currentIndex - 1);
        if (Character.isLetterOrDigit(previous)) {
            if (next == '\'') {
                buf.append('\u201d');
                ++currentIndex;
            } else {
                buf.append('\u2019');
            }
        } else if (Character.isLetterOrDigit(next)) {
            buf.append('\u2018');
        } else if (next == '\'') {
            if (currentIndex + 1 == lastIndex) {
                buf.append('\u201d');
            } else {
                char nextOfNext = charSequence.charAt(currentIndex + 2);
                if (Character.isLetterOrDigit(nextOfNext)) {
                    buf.append('\u201c');
                } else if (Character.isWhitespace(nextOfNext)) {
                    if (Character.isWhitespace(previous)) {
                        buf.append('\'');
                        buf.append('\'');
                    } else {
                        buf.append('\u201d');
                    }
                } else if (Character.isWhitespace(previous)) {
                    buf.append('\u201c');
                } else {
                    buf.append('\'');
                    buf.append('\'');
                }
            }
            ++currentIndex;
        } else if (Character.isWhitespace(next)) {
            if (Character.isWhitespace(previous)) {
                buf.append('\'');
            } else {
                buf.append('\u2019');
            }
        } else if (Character.isWhitespace(previous)) {
            buf.append('\u2018');
        } else {
            buf.append('\'');
        }
        return currentIndex;
    }

    private static int parseDoubleQuote(CharSequence charSequence, int currentIndex, int remainingIndices, int precedingIndices, StringBuilder buf, QuoteOptions quoteOptions) {
        if (remainingIndices == 0) {
            TypoParser.appendClosingQuote(buf, quoteOptions);
            return currentIndex;
        }
        if (precedingIndices == 0) {
            TypoParser.appendOpeningQuote(buf, quoteOptions);
            return currentIndex;
        }
        char next = charSequence.charAt(currentIndex + 1);
        char previous = charSequence.charAt(currentIndex - 1);
        if (Character.isLetterOrDigit(next)) {
            if (Character.isLetterOrDigit(previous)) {
                buf.append('\"');
            } else {
                TypoParser.appendOpeningQuote(buf, quoteOptions);
            }
        } else if (Character.isLetterOrDigit(previous)) {
            TypoParser.appendClosingQuote(buf, quoteOptions);
        } else if (Character.isWhitespace(next)) {
            if (Character.isWhitespace(previous)) {
                buf.append('\"');
            } else {
                TypoParser.appendClosingQuote(buf, quoteOptions);
            }
        } else if (Character.isWhitespace(previous)) {
            TypoParser.appendOpeningQuote(buf, quoteOptions);
        } else {
            buf.append('\"');
        }
        return currentIndex;
    }

    private static void appendOpeningQuote(StringBuilder buf, QuoteOptions quoteOptions) {
        buf.append(quoteOptions.getOpeningQuote());
        if (quoteOptions.isWithNonBreakingSpaces()) {
            buf.append('\u202f');
        }
    }

    private static void appendClosingQuote(StringBuilder buf, QuoteOptions quoteOptions) {
        if (quoteOptions.isWithNonBreakingSpaces()) {
            buf.append('\u202f');
        }
        buf.append(quoteOptions.getClosingQuote());
    }

    public static boolean hasSuperscriptForm(char c) {
        switch (c) {
            case '(': 
            case ')': 
            case '+': 
            case '-': 
            case '0': 
            case '1': 
            case '2': 
            case '3': 
            case '4': 
            case '5': 
            case '6': 
            case '7': 
            case '8': 
            case '9': 
            case '=': 
            case 'i': 
            case 'n': {
                return true;
            }
        }
        return false;
    }

    public static char getsSuperscriptForm(char c) {
        switch (c) {
            case '0': {
                return '\u2070';
            }
            case '1': {
                return '\u00b9';
            }
            case '2': {
                return '\u00b2';
            }
            case '3': {
                return '\u00b3';
            }
            case '4': {
                return '\u2074';
            }
            case '5': {
                return '\u2075';
            }
            case '6': {
                return '\u2076';
            }
            case '7': {
                return '\u2077';
            }
            case '8': {
                return '\u2078';
            }
            case '9': {
                return '\u2079';
            }
            case 'i': {
                return '\u2071';
            }
            case '+': {
                return '\u207a';
            }
            case '-': {
                return '\u207b';
            }
            case '=': {
                return '\u207c';
            }
            case '(': {
                return '\u207d';
            }
            case ')': {
                return '\u207e';
            }
            case 'n': {
                return '\u207f';
            }
        }
        return '0';
    }
}

