/*
 * Decompiled with CFR 0.152.
 */
package net.fichotheque.tools.parsers;

import java.text.ParseException;
import net.fichotheque.corpus.Corpus;
import net.fichotheque.corpus.FicheChange;
import net.fichotheque.corpus.FicheMeta;
import net.fichotheque.corpus.fiche.Fiche;
import net.fichotheque.corpus.metadata.CorpusField;
import net.fichotheque.corpus.metadata.CorpusMetadata;
import net.fichotheque.corpus.metadata.FieldKey;
import net.fichotheque.corpus.metadata.SubfieldKey;
import net.fichotheque.tools.corpus.FicheChangeBuilder;
import net.fichotheque.tools.parsers.FicheParser;
import net.fichotheque.utils.CorpusUtils;
import net.mapeadores.util.request.RequestMap;

public class FicheParseEngine {
    public static final short NONE_TYPE = 0;
    public static final short REPLACE_TYPE = 1;
    public static final short UPDATE_TYPE = 2;

    private FicheParseEngine() {
    }

    public static Fiche run(FicheParser ficheParser, FicheMeta ficheMeta, RequestMap requestMap, short type) {
        Corpus corpus = ficheMeta.getCorpus();
        CorpusMetadata corpusMetadata = corpus.getCorpusMetadata();
        FicheChangeBuilder ficheChangeBuilder = new FicheChangeBuilder();
        FicheParser.Buffer buffer = ficheParser.getBuffer(ficheChangeBuilder);
        for (String paramName : requestMap.getParameterNameSet()) {
            boolean subfieldDone = FicheParseEngine.parseSubfield(buffer, corpusMetadata, paramName, requestMap);
            if (subfieldDone) continue;
            FicheParseEngine.parseCorpusField(buffer, corpusMetadata, paramName, requestMap);
        }
        buffer.flushParsedSubfields();
        FicheChange ficheChange = ficheChangeBuilder.toFicheChange();
        if (type == 1) {
            return CorpusUtils.toFiche(ficheChange);
        }
        Fiche originalFiche = ficheMeta.getCorpus().getFiche(ficheMeta);
        CorpusUtils.updateFiche(originalFiche, ficheChange);
        return originalFiche;
    }

    private static boolean parseCorpusField(FicheParser.Buffer buffer, CorpusMetadata corpusMetadata, String paramName, RequestMap requestMap) {
        try {
            FieldKey fieldKey = FieldKey.parse(paramName);
            CorpusField corpusField = corpusMetadata.getCorpusField(fieldKey);
            if (corpusField != null) {
                String[] paramValues;
                for (String value : paramValues = requestMap.getParameterValues(paramName)) {
                    buffer.parseCorpusField(corpusField, value);
                }
            }
            return true;
        }
        catch (ParseException pe) {
            return false;
        }
    }

    private static boolean parseSubfield(FicheParser.Buffer buffer, CorpusMetadata corpusMetadata, String paramName, RequestMap requestMap) {
        try {
            SubfieldKey subfieldKey = SubfieldKey.parse(paramName);
            FieldKey fieldKey = subfieldKey.getFieldKey();
            CorpusField corpusField = corpusMetadata.getCorpusField(fieldKey);
            if (corpusField != null) {
                String value = requestMap.getParameter(paramName);
                buffer.parseSubfield(corpusField, subfieldKey, value);
            }
            return true;
        }
        catch (ParseException pe) {
            return false;
        }
    }
}

