/*
 * Decompiled with CFR 0.152.
 */
package net.fichotheque.tools.junction;

import java.util.ArrayList;
import java.util.List;
import net.fichotheque.SubsetItem;
import net.fichotheque.junction.JunctionChange;
import net.fichotheque.junction.JunctionChanges;
import net.fichotheque.utils.FichothequeUtils;
import net.fichotheque.utils.JunctionUtils;

public class JunctionChangesBuilder {
    private final List<SubsetItem> removedList = new ArrayList<SubsetItem>();
    private final List<JunctionChanges.Entry> entryList = new ArrayList<JunctionChanges.Entry>();

    public JunctionChangesBuilder addRemoved(SubsetItem subsetItem) {
        this.removedList.add(subsetItem);
        return this;
    }

    public JunctionChangesBuilder addEntry(SubsetItem subsetItem, JunctionChange junctionChange) {
        this.entryList.add(JunctionUtils.toEntry(subsetItem, junctionChange));
        return this;
    }

    public JunctionChanges toJunctionChanges() {
        List<SubsetItem> finalRemovedList = FichothequeUtils.wrap(this.removedList.toArray(new SubsetItem[this.removedList.size()]));
        List<JunctionChanges.Entry> finalEntryList = JunctionUtils.wrap(this.entryList.toArray(new JunctionChanges.Entry[this.entryList.size()]));
        return new InternalJunctionChanges(finalRemovedList, finalEntryList);
    }

    public static JunctionChangesBuilder init() {
        return new JunctionChangesBuilder();
    }

    private static class InternalJunctionChanges
    implements JunctionChanges {
        private final List<SubsetItem> removedList;
        private final List<JunctionChanges.Entry> entryList;

        private InternalJunctionChanges(List<SubsetItem> removedList, List<JunctionChanges.Entry> entryList) {
            this.removedList = removedList;
            this.entryList = entryList;
        }

        @Override
        public List<SubsetItem> getRemovedList() {
            return this.removedList;
        }

        @Override
        public List<JunctionChanges.Entry> getEntryList() {
            return this.entryList;
        }
    }
}

